/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * OSF/1 Release 1.0
 */
/*
 * ipc_rec.h 
 *
 *
 * $Header: /afs/ssd/i860/CVS/cmds_libs/src/usr/sbin/netmsgserver/server/ipc_rec.h,v 1.2 1994/11/19 03:11:12 mtm Exp $ 
 *
 */

/*
 * Definitions for records used by the IPC module to register 
 * messages in transit. 
 */


#ifndef	_IPC_REC_
#define	_IPC_REC_

#include <mach/boolean.h>
#include <mach/message.h>

#if	RPCMOD
#include	"sys_queue.h"
#endif	RPCMOD

#include	"ipc_hdr.h"
#include	"sbuf.h"
#include	"mem.h"

#define IPC_OUT_NUM_SEGS	5


typedef struct {
#if	RPCMOD
#else	RPCMOD
	pointer_t	re_send_q;	/* link in queue for ip re-send thread */
	port_rec_ptr_t	dest_port_ptr;	/* port record for destination */
#endif	RPCMOD
	msg_header_t	*ipcbuff;	/* IPC receive buffer */
	sbuf_t		msg;		/* complete msg to transmit */
	sbuf_seg_t	segs[IPC_OUT_NUM_SEGS];	/* statically alloc'd sbuf segs. */
	boolean_t	ool_exists;	/* is there out-of-line data */
	sbuf_t		ool;		/* list of out-of-line sections (for GC) */
	sbuf_seg_t	ool_seg;	/* optimisation for message with 1 ool item */
	boolean_t	npd_exists;	/* is there a NPD */
	sbuf_t		npd;		/* Network Port Dictionary (for GC) */
	ipc_netmsg_hdr_t netmsg_hdr;	/* IPC netmsg header */
	netaddr_t	dest;		/* destination address (machine) */
	int		crypt_level;	/* The encryption level of the message. */
} ipc_outrec_t;

#if	RPCMOD
#else	RPCMOD
typedef ipc_outrec_t *ipc_outrec_ptr_t;
#endif	RPCMOD

typedef struct {
#if	RPCMOD
#else	RPCMOD
	port_rec_ptr_t	dest_port_ptr;	/* port record for destination */
#endif	RPCMOD
	sbuf_ptr_t	msg;		/* data from the transport level */
	msg_header_t	*assem_buff;	/* buffer for assembly */
	int		assem_len;	/* length of assem_buff to dealloc */
			/* or 0 if MEM_ASSEMBUF, -1 if no dealloc needed */
#if	RPCMOD
	int		assem_type;	/* type of assembly area */
#endif	RPCMOD
	netaddr_t	from;		/* message origin (machine) */
#if	RPCMOD
	unsigned long	ipc_seq_no;	/* sequence number */
#endif	RPCMOD
	ipc_netmsg_hdr_t *netmsg_hdr_ptr;	/* IPC netmsg header */
#if	RPCMOD
#else	RPCMOD
	int		(*cleanup) ();	/* cleanup routine in transport */
#endif	RPCMOD
} ipc_inrec_t;

#if	RPCMOD
#else	RPCMOD
typedef ipc_inrec_t *ipc_inrec_ptr_t;
#endif	RPCMOD

typedef struct {
	int			type;		/* type of transaction */
	int			status;		/* current progress status */
	int			trid;		/* transport-level ID */
	int			trmod;		/* index of transport mod used */
#if	RPCMOD
	int			retry_level;	/* port info at last xmit */
	sys_queue_chain_t	re_send_q;	/* link in queue for re-send */
	sys_queue_chain_t	out_q;		/* link in queue of out reqs */
	port_rec_ptr_t		server_port_ptr;
	port_rec_ptr_t		reply_port_ptr;
#endif	RPCMOD
	ipc_outrec_t		out;
	ipc_inrec_t		in;
#if	RPCMOD
} ipc_rec_t;
#else	RPCMOD
} ipc_iorec_t;
#endif	RPCMOD

#if	RPCMOD
typedef	ipc_rec_t *ipc_rec_ptr_t;
#else	RPCMOD
typedef	ipc_iorec_t *ipc_iorec_ptr_t;
#endif	RPCMOD


/*
 * Structure for queue of senders waiting on a blocked port.
 */
typedef struct ipc_block {
	struct ipc_block	*next;
	netaddr_t		addr;
} ipc_block_t, *ipc_block_ptr_t;

#define IPC_BLOCK_NULL		((ipc_block_ptr_t)0)

#if	RPCMOD
/*
 * Values for assem_type field in ipc_outrec.
 */
#define	IPC_REC_ASSEM_OBJ	0	/* MEM_ALLOCOBJ(MEM_ASSEMBUFF) */
#define	IPC_REC_ASSEM_MEMALLOC	1	/* mem_alloc(assem_len) */
#define	IPC_REC_ASSEM_PKT	2	/* (virtual) copy of packet buffer */
#endif	RPCMOD

/*
 * Values for type field in ipc_rec
 */
#if	RPCMOD
#define	IPC_REC_TYPE_UNKNOWN	0	/* not yet specified */
#define	IPC_REC_TYPE_SINGLE	1	/* single message */
#define	IPC_REC_TYPE_CLIENT	2	/* RPC, client side */
#define	IPC_REC_TYPE_SERVER	3	/* RPC, server side */
#else	RPCMOD
#define	IPC_IOREC_TYPE_SINGLE	1	/* single message */
#define	IPC_IOREC_TYPE_CLIENT	2	/* RPC, client side */
#define	IPC_IOREC_TYPE_SERVER	3	/* RPC, server side */
#endif	RPCMOD

/*
 * Values for status field in ipc_rec
 */
#if	RPCMOD
#define	IPC_REC_ACTIVE		1	/* waiting for ack or reply */
#define	IPC_REC_READY		2	/* ready to be transmitted */
#define	IPC_REC_WAITING		3	/* waiting for new information */
#define	IPC_REC_REPLY		4	/* waiting for local reply */
#else	RPCMOD
#define	IPC_IOREC_WAIT_CLEANUP	1	/* msg sent, waiting for cleanup */
#define	IPC_IOREC_WAIT_REPLY	2	/* req sent, waiting for reply */
#define	IPC_IOREC_WAIT_LOCAL	3	/* req delivered, wtng for local reply */
#define	IPC_IOREC_WAIT_BLOCK	4	/* msg not sent, port (b)locked */
#endif	RPCMOD


/*
 * Standard size for an assembly buffer 
 */
#define	IPC_ASSEM_SIZE		(16384)


/*
 * Return codes for IPC operations. These codes are in the same space as
 * the DISP_* and TR_* codes.
 */
#define	IPC_SUCCESS		1
#define	IPC_FAILURE		2
#define	IPC_PORT_BLOCKED	3
#define	IPC_PORT_NOT_HERE	4
#define IPC_BAD_SEQ_NO		5
#define	IPC_REQUEST		6
#define	IPC_ABORT_REPLY		7
#define	IPC_ABORT_REQUEST	8
#define	IPC_PORT_BUSY		9


#if	RPCMOD
/*
 * Packet used for client abort.
 */
typedef struct {
	struct abort_pkt {
		disp_hdr_t	disp_hdr;
		np_uid_t	np_puid;
		unsigned long	ipc_seq_no;
	} abort_pkt;
	sbuf_t		msg;
	sbuf_seg_t	segs[5];
} ipc_abort_rec_t, *ipc_abort_rec_ptr_t;

#endif	RPCMOD


/*
 * Extern definitions internal to the IPC module.
 */
extern void ipc_in_init();

extern void ipc_in_block();
/*
port_rec_ptr	dp_ptr;
netaddr_t	from;
*/

extern int ipc_in_cancel();
/*
int		ipcid;
int		reason;
*/

extern ipc_in_unblock();
/*
sbuf_ptr_t	data;
netaddr_t	from;
boolean_t	broadcast;
int		crypt_level;
*/

extern void ipc_out_init();


/*
 * Memory management definitions.
 */
extern mem_objrec_t		MEM_ASSEMBUFF;
extern mem_objrec_t		MEM_IPCBLOCK;
#if	RPCMOD
extern mem_objrec_t		MEM_IPCREC;
extern mem_objrec_t		MEM_IPCABORT;
#endif	RPCMOD


#endif	_IPC_REC_
