C
C***********************************************************************
      SUBROUTINE  SENSIT( iou, RATES,WG,IQ,SUMW,  MAP,TV,TV1,TV2,TV3,n)
C***********************************************************************
C                                                                      *
C     SENSIT  - Sensitivity Of Harmonic Mean Rate(Mflops) 49 Workloads *
C                                                                      *
C     iou     - input scalar,  i/o unit number                         *
C     RATES   - input array ,  execution rates (Mflops)                *
C     WG      - input array ,  weights paired with RATES               *
C     IQ      - input array ,  1 or 2 quartiles specifier              *
C     SUMW    - input array ,  workload fractions.                     *
C                                                                      *
C     MAP,TV,TV1,TV2,TV3    -  output temporary arrays                 *
C     n       - input scalar,  number of rates, etc.                   *
C                                                                      *
C***********************************************************************
C
      IMPLICIT  DOUBLE PRECISION (A-H,O-Z)
cIBM  IMPLICIT  REAL*8           (A-H,O-Z)
C
c In
      DIMENSION  RATES(n), WG(n), IQ(7), SUMW(7)
c Temp
      DIMENSION  MAP(n), TV(n), TV1(n), TV2(n), TV3(n)
      DIMENSION  NR1(10), NR2(10), STAT2(20)

c     DIMENSION  TAG(4)                                                  f66
      CHARACTER*8  TAG(4)                                                f77
      SAVE  TAG
C
      DATA  ( TAG(i), i= 1,4)
     . /'1st QT: ',  '2nd QT: ',  '3rd QT: ',  '4th QT: '/               f77
c    ./8H1st QT:  , 8H2nd QT:  , 8H3rd QT:  , 8H4th QT:  /               f66
C
      CALL TRACE ('SENSIT  ')
C
C                 Compress valid data sets RATES,  mapping on MAP.

            meff= 0
            neff= 0
              bl= 1.0d-5
              bu= 1.0d+5
            CALL  VALID( TV1,MAP,neff,  bl, RATES, bu, n)

        DO  1  k= 1,neff
          TV3(k)=    WG( MAP(k))
    1  continue


C                 Compress valid data sets WG,  mapping on MAP.

            CALL  VALID( TV3,MAP,meff,  bl, TV3, bu, neff)

        DO  3  k= 1,meff
           TV(k)=TV1( MAP(k))
    3  continue
C
C                 Sort selected rates into descending order

            CALL  SORDID( MAP,TV2,   TV,meff,2)

C
C
       CALL PAGE( iou)
          WRITE ( iou,7001)
C
 7001 FORMAT(/)
 7301 FORMAT(9X,31H           SENSITIVITY ANALYSIS )
 7302 FORMAT(9X,52HThe sensitivity of the harmonic mean rate (Mflops)  )
 7303 FORMAT(9X,52Hto various weightings is shown in the table below.  )
 7304 FORMAT(9X,52HSeven work distributions are generated by assigning )
 7305 FORMAT(9X,52Htwo distinct weights to ranked kernels by quartiles.)
 7306 FORMAT(9X,52HForty nine possible cpu workloads are then evaluated)
 7307 FORMAT(9X,52Husing seven sets of values for the total weights:   )
 7341 FORMAT(3X,A ,6X,43HO      O      O      O      O      X      X)    f77
 7342 FORMAT(3X,A ,6X,43HO      O      O      X      X      X      O)    f77
 7343 FORMAT(3X,A ,6X,43HO      X      X      X      O      O      O)    f77
 7344 FORMAT(3X,A ,6X,43HX      X      O      O      O      O      O)    f77
c7341 FORMAT(3X,A7,6X,43HO      O      O      O      O      X      X)    f66
c7342 FORMAT(3X,A7,6X,43HO      O      O      X      X      X      O)    f66
c7343 FORMAT(3X,A7,6X,43HO      X      X      X      O      O      O)    f66
c7344 FORMAT(3X,A7,6X,43HX      X      O      O      O      O      O)    f66
 7346 FORMAT(13X,  48H------ ------ ------ ------ ------ ------ ------)
 7348 FORMAT(3X,5HTotal,/,3X,7HWeights,20X,11HNet Mflops:,/,4X,6HX    O)
 7349 FORMAT(2X,9H---- ---- )
 7220 FORMAT(/,1X,2F5.2,1X,7F7.2)
C
          WRITE ( iou,7001)
          WRITE ( iou,7001)
          WRITE ( iou,7301)
          WRITE ( iou,7001)
          WRITE ( iou,7302)
          WRITE ( iou,7303)
          WRITE ( iou,7304)
          WRITE ( iou,7305)
          WRITE ( iou,7306)
          WRITE ( iou,7307)
          WRITE ( iou,7001)
          WRITE ( iou,7346)
          WRITE ( iou,7341)   TAG(1)
          WRITE ( iou,7342)   TAG(2)
          WRITE ( iou,7343)   TAG(3)
          WRITE ( iou,7344)   TAG(4)
          WRITE ( iou,7346)
          WRITE ( iou,7348)
          WRITE ( iou,7349)
C
            IF( meff .LE. 0 )  GO TO 73
          fuzz= 1.0d-9
             r= meff
            mq= (meff+3)/4
             q= mq
             j= 1
      DO 21  i= 8,2,-2
      NR1(i  )= j
      NR1(i+1)= j
      NR2(i  )= j + mq + mq - 1
      NR2(i+1)= j + mq - 1
             j= j + mq
   21  continue
C
       DO 29 j= 1,7
          sumo= 1.0d0 - SUMW(j)
       DO 27 i= 1,7
             p= IQ(i)*q
            xt= SUMW(j)/(p + fuzz)
            ot= sumo   /(r - p + fuzz)
       DO 23 k= 1,meff
        TV3(k)= ot
   23  continue
            k1= NR1(i+2)
            k2= NR2(i+2)
       DO 25 k= k1,k2
        TV3(k)= xt
   25  continue
          CALL  STATW( STAT2,TV,MAP, TV2,TV3,meff)
        TV1(i)= STAT2(5)
   27  continue
        WRITE ( iou,7220) SUMW(j), sumo, ( TV1(k), k=1,7)
   29  continue
C
           WRITE ( iou,7349)
           WRITE ( iou,7346)
C
C
   73 CONTINUE
      CALL TRACK ('SENSIT  ')
      RETURN
      END
