/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* static char rcsid[] = "@(#)$RCSfile: terminal.h,v $ $Revision: 1.2 $ (OSF) $Date: 1994/11/19 01:28:09 $"; */
/*
 * COMPONENT_NAME: (CMDKSH) Korn shell
 *
 * FUNCTIONS:
 *
 * ORIGINS: 3, 27
 *
 * This module contains IBM CONFIDENTIAL code. -- (IBM
 * Confidential Restricted when combined with the aggregated
 * modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

/*

 *      Copyright (c) 1984, 1985, 1986, 1987, 
 *                  1988, 1989   AT&T
 *      All Rights Reserved

 *      THIS IS UNPUBLISHED PROPRIETARY SOURCE 
 *      CODE OF AT&T.
 *      The copyright notice above does not 
 *      evidence any actual or intended
 *      publication of such source code.

 */

/*
 * terminal interface
 */

#ifndef _terminal_
#define _terminal_	1
#ifdef _termios_
#define	POSIXLD	"posix"
#   include	<termios.h>
#else
#   ifdef _sys_termios_
#	include	<sys/termios.h>
#	define _termios_
#   endif /* _sys_termios_ */
#endif /* _termios_ */

#ifdef _termios_
#   ifndef TCSANOW
#	define TCSANOW		TCSETS
#	define TCSADRAIN	TCSETSW
#	define TCSAFLUSH	TCSETSF
#	define tcgetattr(fd,tty)	ioctl(fd, TCGETS, tty)
#	define tcsetattr(fd,action,tty)	ioctl(fd, action, tty)
#   endif /* TCSANOW */
#   undef TIOCGETC
#   undef _termio_
#ifdef  KSH_88D
#   undef _sys_termio_
#endif /* KSH_88D */
#   undef _sgtty_
#   undef _sys_ioctl_
#   undef _sys_bsdtty_
#endif /* _termios_ */

#ifdef  KSH_88D
#ifdef _termio_
#   include	<termio.h>
#else
#   ifdef _sys_termio_
#       include <sys/termio.h>
#       define  _termio_        1
#   endif /* _sys_termio_ */
#endif /* _termio_ */
#endif /* KSH_88D */
#ifdef _termio_
#   define termios termio
#   undef _sgtty_
#   undef TIOCGETC
#   undef _sys_ioctl_
#   define tcgetattr(fd,tty)		ioctl(fd, TCGETA, tty)
#   define tcsetattr(fd,action,tty)	ioctl(fd, action, tty)
#endif /* _termio_ */

#ifdef _sys_bsdtty_
#   include	<sys/bsdtty.h>
#endif /* _sys_bsdtty_ */

#ifdef _sgtty_
#   include	<sgtty.h>
#   ifdef       KSH_88D
#       ifdef   _sys_nttyio_
#               ifdef   LPENDIN
#                       include <sys/nttyio.h>
#               endif /* LPENDIN */
#       endif /* LPENDIN */
#   endif /* KSH_88D */
#   define termios sgttyb
#   undef _sys_ioctl_
#   ifdef TIOCSETN
#	undef TCSETAW
#   endif /* TIOCSETN */
#   ifdef _SELECT_
#       ifdef   KSH_88D
#               ifndef  included_sys_time_
#                       ifdef   _sys_Time_
#                               include <sys/time.h>
#                       endif /* _sys_Time_ */
#                       define included_sys_time_
#               endif /* included_sys_time */
#       else
#       define included_sys_time_
#       include <sys/time.h>
#       endif /* KSH_88D */
	extern const int tty_speeds[];
#   endif /* _SELECT_ */
#   ifdef TIOCGETP
#	define tcgetattr(fd,tty)		ioctl(fd, TIOCGETP, tty)
#	define tcsetattr(fd,action,tty)	ioctl(fd, action, tty)
#   else
#	define tcgetattr(fd,tty)	gtty(fd, tty)
#	define tcsetattr(fd,action,tty)	stty(fd, tty)
#   endif /* TIOCGETP */
#endif /* _sgtty_ */

#ifndef TCSANOW
#   ifdef TCSETAW
#	define TCSANOW	TCSETA
#	ifdef u370
	/* delays are too long, don't wait for output to drain */
#	    define TCSADRAIN	TCSETA
#	else
#	   define TCSADRAIN	TCSETAW
#	endif /* u370 */
#	define TCSAFLUSH	TCSETAF
#   else
#	ifdef TIOCSETN
#	    define TCSANOW	TIOCSETN
#	    define TCSADRAIN	TIOCSETN
#	    define TCSAFLUSH	TIOCSETP
#	endif /* TIOCSETN */
#   endif /* TCSETAW */
#endif /* TCSANOW */
#endif /* _terminal_ */

/* set ECHOCTL if driver can echo control charaters as ^c */
#ifdef LCTLECH
#   ifndef ECHOCTL
#	define ECHOCTL	LCTLECH
#   endif /* !ECHOCTL */
#endif /* LCTLECH */
#ifdef  KSH_88D
#ifdef LNEW_CTLECH
#   ifndef ECHOCTL
#       define ECHOCTL  LNEW_CTLECH
#   endif /* !ECHOCTL */
#endif /* LNEW_CTLECH */
#ifdef LNEW_PENDIN
#   ifndef PENDIN
#       define PENDIN LNEW_PENDIN
#  endif /* !PENDIN */
#endif /* LNEW_PENDIN */

#ifdef _sys_filio_
#   ifndef FIONREAD
#       include <sys/filio.h>
#   endif /* FIONREAD */
#endif /* _sys_filio_ */
#endif /* KSH_88D */

/* set FIORDCHK if you can check for characters in input queue */
#ifdef FIONREAD
#   ifndef FIORDCHK
#	define FIORDCHK	FIONREAD
#   endif /* !FIORDCHK */
#endif /* FIONREAD */

#ifdef _NO_PROTO
    extern int	tty_alt();
    extern void tty_cooked();
    extern int	tty_get();
    extern int	tty_raw();
    extern int	tty_check();
#else /* ~ _NO_PROTO */
    extern int	tty_alt(int);
    extern void tty_cooked(int);
    extern int	tty_get(int,struct termios*);
    extern int	tty_raw(int);
    extern int	tty_check(int);
#endif /* _NO_PROTO */
extern int	tty_set();
