/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
#if !defined(lint) && !defined(_NOIDENT)
static char rcsid[] = "@(#)$RCSfile: iconv.c,v $ $Revision: 1.2 $ (OSF) $Date: 1994/11/19 01:26:11 $";
#endif
/*
 * CMDNLS: iconv
 *
 * FUNCTIONS: main
 *
 * ORIGINS: 27
 *
 * IBM CONFIDENTIAL -- (IBM Confidential Restricted when
 * combined with the aggregated modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 * 
 * iconv.c     1.3  com/cmd/nls,3.1,9021 9/14/89 08:29:15
 */                                                                   

/*
 *  Invoked by: iconv -f <from> -t <to> [<infile>]
 *
 *  Iconv converts the contents of <infile> from the code page
 *  represented by <from> to the code page represented by <to>.
 *  If <infile> is not specified, standard input is read
 *  instead. Conversion is performed on a byte-by-byte basis.
 *
 *  Valid combinations for <from> and <to> are:
 *
 *      <from>          <to>
 *      pc850           88591
 *      88591           pc850
 *
 *  Where pc850 is the designator for IBM Personal Computer Code
 *  Page 850 (AIX P0) and 88591 is the designator for ISO 8859/1.
 *
 *  The results are written to standard output.
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include "iconv_msg.h" 
nl_catd  scmc_catd;   /* Cat descriptor for scmc conversion */
#define MSGSTR(Num,Str) catgets(scmc_catd,MS_iconv,Num,Str)
#define STDIN 0
#define STDOUT 1
#define PC850 "pc850"
#define IS591 "88591"

static unsigned char pc850to88591[] = {
	0x00,    /* 0x00     */
	0x01,    /* 0x01     */
	0x02,    /* 0x02     */
	0x03,    /* 0x03     */
	0x04,    /* 0x04     */
	0x05,    /* 0x05     */
	0x06,    /* 0x06     */
	0x07,    /* 0x07     */
	0x08,    /* 0x08     */
	0x09,    /* 0x09     */
	0x0a,    /* 0x0a     */
	0x0b,    /* 0x0b     */
	0x0c,    /* 0x0c     */
	0x0d,    /* 0x0d     */
	0x0e,    /* 0x0e     */
	0x0f,    /* 0x0f     */
	0x10,    /* 0x10     */
	0x11,    /* 0x11     */
	0x12,    /* 0x12     */
	0x13,    /* 0x13     */
	0x14,    /* 0x14     */
	0x15,    /* 0x15     */
	0x16,    /* 0x16     */
	0x17,    /* 0x17     */
	0x18,    /* 0x18     */
	0x19,    /* 0x19     */
	0x1a,    /* 0x1a     */
	0x1b,    /* 0x1b     */
	0x1c,    /* 0x1c     */
	0x1d,    /* 0x1d     */
	0x1e,    /* 0x1e     */
	0x1f,    /* 0x1f     */
	0x20,    /* 0x20 -   */
	0x21,    /* 0x21 - ! */
	0x22,    /* 0x22 - " */
	0x23,    /* 0x23 - # */
	0x24,    /* 0x24 - $ */
	0x25,    /* 0x25 - % */
	0x26,    /* 0x26 - & */
	0x27,    /* 0x27 - ' */
	0x28,    /* 0x28 - ( */
	0x29,    /* 0x29 - ) */
	0x2a,    /* 0x2a - * */
	0x2b,    /* 0x2b - + */
	0x2c,    /* 0x2c - , */
	0x2d,    /* 0x2d - - */
	0x2e,    /* 0x2e - . */
	0x2f,    /* 0x2f - / */
	0x30,    /* 0x30 - 0 */
	0x31,    /* 0x31 - 1 */
	0x32,    /* 0x32 - 2 */
	0x33,    /* 0x33 - 3 */
	0x34,    /* 0x34 - 4 */
	0x35,    /* 0x35 - 5 */
	0x36,    /* 0x36 - 6 */
	0x37,    /* 0x37 - 7 */
	0x38,    /* 0x38 - 8 */
	0x39,    /* 0x39 - 9 */
	0x3a,    /* 0x3a - : */
	0x3b,    /* 0x3b - ; */
	0x3c,    /* 0x3c - < */
	0x3d,    /* 0x3d - = */
	0x3e,    /* 0x3e - > */
	0x3f,    /* 0x3f - ? */
	0x40,    /* 0x40 - @ */
	0x41,    /* 0x41 - A */
	0x42,    /* 0x42 - B */
	0x43,    /* 0x43 - C */
	0x44,    /* 0x44 - D */
	0x45,    /* 0x45 - E */
	0x46,    /* 0x46 - F */
	0x47,    /* 0x47 - G */
	0x48,    /* 0x48 - H */
	0x49,    /* 0x49 - I */
	0x4a,    /* 0x4a - J */
	0x4b,    /* 0x4b - K */
	0x4c,    /* 0x4c - L */
	0x4d,    /* 0x4d - M */
	0x4e,    /* 0x4e - N */
	0x4f,    /* 0x4f - O */
	0x50,    /* 0x50 - P */
	0x51,    /* 0x51 - Q */
	0x52,    /* 0x52 - R */
	0x53,    /* 0x53 - S */
	0x54,    /* 0x54 - T */
	0x55,    /* 0x55 - U */
	0x56,    /* 0x56 - V */
	0x57,    /* 0x57 - W */
	0x58,    /* 0x58 - X */
	0x59,    /* 0x59 - Y */
	0x5a,    /* 0x5a - Z */
	0x5b,    /* 0x5b - [ */
	0x5c,    /* 0x5c - \ */
	0x5d,    /* 0x5d - ] */
	0x5e,    /* 0x5e - ^ */
	0x5f,    /* 0x5f - _ */
	0x60,    /* 0x60 - ` */
	0x61,    /* 0x61 - a */
	0x62,    /* 0x62 - b */
	0x63,    /* 0x63 - c */
	0x64,    /* 0x64 - d */
	0x65,    /* 0x65 - e */
	0x66,    /* 0x66 - f */
	0x67,    /* 0x67 - g */
	0x68,    /* 0x68 - h */
	0x69,    /* 0x69 - i */
	0x6a,    /* 0x6a - j */
	0x6b,    /* 0x6b - k */
	0x6c,    /* 0x6c - l */
	0x6d,    /* 0x6d - m */
	0x6e,    /* 0x6e - n */
	0x6f,    /* 0x6f - o */
	0x70,    /* 0x70 - p */
	0x71,    /* 0x71 - q */
	0x72,    /* 0x72 - r */
	0x73,    /* 0x73 - s */
	0x74,    /* 0x74 - t */
	0x75,    /* 0x75 - u */
	0x76,    /* 0x76 - v */
	0x77,    /* 0x77 - w */
	0x78,    /* 0x78 - x */
	0x79,    /* 0x79 - y */
	0x7a,    /* 0x7a - z */
	0x7b,    /* 0x7b - { */
	0x7c,    /* 0x7c - | */
	0x7d,    /* 0x7d - } */
	0x7e,    /* 0x7e - ~ */
	0x7f,    /* 0x7f -  */
	0xc7,    /* 0x80 -  */
	0xfc,    /* 0x81 -  */
	0xe9,    /* 0x82 -  */
	0xe2,    /* 0x83 -  */
	0xe4,    /* 0x84 -  */
	0xe0,    /* 0x85 -  */
	0xe5,    /* 0x86 -  */
	0xe7,    /* 0x87 -  */
	0xea,    /* 0x88 -  */
	0xeb,    /* 0x89 - 	 */
	0xe8,    /* 0x8a - 
 */
	0xef,    /* 0x8b -  */
	0xee,    /* 0x8c -  */
	0xec,    /* 0x8d - 
 */
	0xc4,    /* 0x8e -  */
	0xc5,    /* 0x8f -  */
	0xc9,    /* 0x90 -  */
	0xe6,    /* 0x91 -  */
	0xc6,    /* 0x92 -  */
	0xf4,    /* 0x93 -  */
	0xf6,    /* 0x94 -  */
	0xf2,    /* 0x95 -  */
	0xfb,    /* 0x96 -  */
	0xf9,    /* 0x97 -  */
	0xff,    /* 0x98 -  */
	0xd6,    /* 0x99 -  */
	0xdc,    /* 0x9a -  */
	0xf8,    /* 0x9b -  */
	0xa3,    /* 0x9c -  */
	0xd8,    /* 0x9d -  */
	0xd7,    /* 0x9e -  */
	0x1a,    /* 0x9f -  */
	0xe1,    /* 0xa0 -   */
	0xed,    /* 0xa1 - ! */
	0xf3,    /* 0xa2 - " */
	0xfa,    /* 0xa3 - # */
	0xf1,    /* 0xa4 - $ */
	0xd1,    /* 0xa5 - % */
	0xaa,    /* 0xa6 - & */
	0xba,    /* 0xa7 - ' */
	0xbf,    /* 0xa8 - ( */
	0xae,    /* 0xa9 - ) */
	0xac,    /* 0xaa - * */
	0xbd,    /* 0xab - + */
	0xbc,    /* 0xac - , */
	0xa1,    /* 0xad - - */
	0xab,    /* 0xae - . */
	0xbb,    /* 0xaf - / */
	0x1a,    /* 0xb0 - 0 */
	0x1a,    /* 0xb1 - 1 */
	0x1a,    /* 0xb2 - 2 */
	0x1a,    /* 0xb3 - 3 */
	0x1a,    /* 0xb4 - 4 */
	0xc1,    /* 0xb5 - 5 */
	0xc2,    /* 0xb6 - 6 */
	0xc0,    /* 0xb7 - 7 */
	0xa9,    /* 0xb8 - 8 */
	0x1a,    /* 0xb9 - 9 */
	0x1a,    /* 0xba - : */
	0x1a,    /* 0xbb - ; */
	0x1a,    /* 0xbc - < */
	0xa2,    /* 0xbd - = */
	0xa5,    /* 0xbe - > */
	0x1a,    /* 0xbf - ? */
	0x1a,    /* 0xc0 - @ */
	0x1a,    /* 0xc1 - A */
	0x1a,    /* 0xc2 - B */
	0x1a,    /* 0xc3 - C */
	0x1a,    /* 0xc4 - D */
	0x1a,    /* 0xc5 - E */
	0xe3,    /* 0xc6 - F */
	0xc3,    /* 0xc7 - G */
	0x1a,    /* 0xc8 - H */
	0x1a,    /* 0xc9 - I */
	0x1a,    /* 0xca - J */
	0x1a,    /* 0xcb - K */
	0x1a,    /* 0xcc - L */
	0x1a,    /* 0xcd - M */
	0x1a,    /* 0xce - N */
	0xa4,    /* 0xcf - O */
	0xf0,    /* 0xd0 - P */
	0xd0,    /* 0xd1 - Q */
	0xca,    /* 0xd2 - R */
	0xcb,    /* 0xd3 - S */
	0xc8,    /* 0xd4 - T */
	0x1a,    /* 0xd5 - U */
	0xcd,    /* 0xd6 - V */
	0xce,    /* 0xd7 - W */
	0xcf,    /* 0xd8 - X */
	0x1a,    /* 0xd9 - Y */
	0x1a,    /* 0xda - Z */
	0x1a,    /* 0xdb - [ */
	0x1a,    /* 0xdc - \ */
	0xa6,    /* 0xdd - ] */
	0xcc,    /* 0xde - ^ */
	0x1a,    /* 0xdf - _ */
	0xd3,    /* 0xe0 - ` */
	0xdf,    /* 0xe1 - a */
	0xd4,    /* 0xe2 - b */
	0xd2,    /* 0xe3 - c */
	0xf5,    /* 0xe4 - d */
	0xd5,    /* 0xe5 - e */
	0xb5,    /* 0xe6 - f */
	0xfe,    /* 0xe7 - g */
	0xde,    /* 0xe8 - h */
	0xda,    /* 0xe9 - i */
	0xdb,    /* 0xea - j */
	0xd9,    /* 0xeb - k */
	0xfd,    /* 0xec - l */
	0xdd,    /* 0xed - m */
	0xaf,    /* 0xee - n */
	0xb4,    /* 0xef - o */
	0xad,    /* 0xf0 - p */
	0xb1,    /* 0xf1 - q */
	0x1a,    /* 0xf2 - r */
	0xbe,    /* 0xf3 - s */
	0xb6,    /* 0xf4 - t */
	0xa7,    /* 0xf5 - u */
	0xf7,    /* 0xf6 - v */
	0xb8,    /* 0xf7 - w */
	0xb0,    /* 0xf8 - x */
	0xa8,    /* 0xf9 - y */
	0xb7,    /* 0xfa - z */
	0xb9,    /* 0xfb - { */
	0xb3,    /* 0xfc - | */
	0xb2,    /* 0xfd - } */
	0x1a,    /* 0xfe - ~ */
	0xa0};   /* 0xff -  */

static unsigned char is88591topc850[] = {
	0x00,    /* 0x00     */
	0x01,    /* 0x01     */
	0x02,    /* 0x02     */
	0x03,    /* 0x03     */
	0x04,    /* 0x04     */
	0x05,    /* 0x05     */
	0x06,    /* 0x06     */
	0x07,    /* 0x07     */
	0x08,    /* 0x08     */
	0x09,    /* 0x09     */
	0x0a,    /* 0x0a     */
	0x0b,    /* 0x0b     */
	0x0c,    /* 0x0c     */
	0x0d,    /* 0x0d     */
	0x0e,    /* 0x0e     */
	0x0f,    /* 0x0f     */
	0x10,    /* 0x10     */
	0x11,    /* 0x11     */
	0x12,    /* 0x12     */
	0x13,    /* 0x13     */
	0x14,    /* 0x14     */
	0x15,    /* 0x15     */
	0x16,    /* 0x16     */
	0x17,    /* 0x17     */
	0x18,    /* 0x18     */
	0x19,    /* 0x19     */
	0x1a,    /* 0x1a     */
	0x1b,    /* 0x1b     */
	0x1c,    /* 0x1c     */
	0x1d,    /* 0x1d     */
	0x1e,    /* 0x1e     */
	0x1f,    /* 0x1f     */
	0x20,    /* 0x20 -   */
	0x21,    /* 0x21 - ! */
	0x22,    /* 0x22 - " */
	0x23,    /* 0x23 - # */
	0x24,    /* 0x24 - $ */
	0x25,    /* 0x25 - % */
	0x26,    /* 0x26 - & */
	0x27,    /* 0x27 - ' */
	0x28,    /* 0x28 - ( */
	0x29,    /* 0x29 - ) */
	0x2a,    /* 0x2a - * */
	0x2b,    /* 0x2b - + */
	0x2c,    /* 0x2c - , */
	0x2d,    /* 0x2d - - */
	0x2e,    /* 0x2e - . */
	0x2f,    /* 0x2f - / */
	0x30,    /* 0x30 - 0 */
	0x31,    /* 0x31 - 1 */
	0x32,    /* 0x32 - 2 */
	0x33,    /* 0x33 - 3 */
	0x34,    /* 0x34 - 4 */
	0x35,    /* 0x35 - 5 */
	0x36,    /* 0x36 - 6 */
	0x37,    /* 0x37 - 7 */
	0x38,    /* 0x38 - 8 */
	0x39,    /* 0x39 - 9 */
	0x3a,    /* 0x3a - : */
	0x3b,    /* 0x3b - ; */
	0x3c,    /* 0x3c - < */
	0x3d,    /* 0x3d - = */
	0x3e,    /* 0x3e - > */
	0x3f,    /* 0x3f - ? */
	0x40,    /* 0x40 - @ */
	0x41,    /* 0x41 - A */
	0x42,    /* 0x42 - B */
	0x43,    /* 0x43 - C */
	0x44,    /* 0x44 - D */
	0x45,    /* 0x45 - E */
	0x46,    /* 0x46 - F */
	0x47,    /* 0x47 - G */
	0x48,    /* 0x48 - H */
	0x49,    /* 0x49 - I */
	0x4a,    /* 0x4a - J */
	0x4b,    /* 0x4b - K */
	0x4c,    /* 0x4c - L */
	0x4d,    /* 0x4d - M */
	0x4e,    /* 0x4e - N */
	0x4f,    /* 0x4f - O */
	0x50,    /* 0x50 - P */
	0x51,    /* 0x51 - Q */
	0x52,    /* 0x52 - R */
	0x53,    /* 0x53 - S */
	0x54,    /* 0x54 - T */
	0x55,    /* 0x55 - U */
	0x56,    /* 0x56 - V */
	0x57,    /* 0x57 - W */
	0x58,    /* 0x58 - X */
	0x59,    /* 0x59 - Y */
	0x5a,    /* 0x5a - Z */
	0x5b,    /* 0x5b - [ */
	0x5c,    /* 0x5c - \ */
	0x5d,    /* 0x5d - ] */
	0x5e,    /* 0x5e - ^ */
	0x5f,    /* 0x5f - _ */
	0x60,    /* 0x60 - ` */
	0x61,    /* 0x61 - a */
	0x62,    /* 0x62 - b */
	0x63,    /* 0x63 - c */
	0x64,    /* 0x64 - d */
	0x65,    /* 0x65 - e */
	0x66,    /* 0x66 - f */
	0x67,    /* 0x67 - g */
	0x68,    /* 0x68 - h */
	0x69,    /* 0x69 - i */
	0x6a,    /* 0x6a - j */
	0x6b,    /* 0x6b - k */
	0x6c,    /* 0x6c - l */
	0x6d,    /* 0x6d - m */
	0x6e,    /* 0x6e - n */
	0x6f,    /* 0x6f - o */
	0x70,    /* 0x70 - p */
	0x71,    /* 0x71 - q */
	0x72,    /* 0x72 - r */
	0x73,    /* 0x73 - s */
	0x74,    /* 0x74 - t */
	0x75,    /* 0x75 - u */
	0x76,    /* 0x76 - v */
	0x77,    /* 0x77 - w */
	0x78,    /* 0x78 - x */
	0x79,    /* 0x79 - y */
	0x7a,    /* 0x7a - z */
	0x7b,    /* 0x7b - { */
	0x7c,    /* 0x7c - | */
	0x7d,    /* 0x7d - } */
	0x7e,    /* 0x7e - ~ */
	0x7f,    /* 0x7f -  */
	0x1a,    /* 0x80     */
	0x1a,    /* 0x81     */
	0x1a,    /* 0x82     */
	0x1a,    /* 0x83     */
	0x1a,    /* 0x84     */
	0x1a,    /* 0x85     */
	0x1a,    /* 0x86     */
	0x1a,    /* 0x87     */
	0x1a,    /* 0x88     */
	0x1a,    /* 0x89     */
	0x1a,    /* 0x8a     */
	0x1a,    /* 0x8b     */
	0x1a,    /* 0x8c     */
	0x1a,    /* 0x8d     */
	0x1a,    /* 0x8e     */
	0x1a,    /* 0x8f     */
	0x1a,    /* 0x90     */
	0x1a,    /* 0x91     */
	0x1a,    /* 0x92     */
	0x1a,    /* 0x93     */
	0x1a,    /* 0x94     */
	0x1a,    /* 0x95     */
	0x1a,    /* 0x96     */
	0x1a,    /* 0x97     */
	0x1a,    /* 0x98     */
	0x1a,    /* 0x99     */
	0x1a,    /* 0x9a     */
	0x1a,    /* 0x9b     */
	0x1a,    /* 0x9c     */
	0x1a,    /* 0x9d     */
	0x1a,    /* 0x9e     */
	0x1a,    /* 0x9f     */
	0xff,    /* 0xa0     */
	0xad,    /* 0xa1 - - */
	0xbd,    /* 0xa2 - = */
	0x9c,    /* 0xa3 -  */
	0xcf,    /* 0xa4 - O */
	0xbe,    /* 0xa5 - > */
	0xdd,    /* 0xa6 - ] */
	0xf5,    /* 0xa7 - u */
	0xf9,    /* 0xa8 - y */
	0xb8,    /* 0xa9 - 8 */
	0xa6,    /* 0xaa - & */
	0xae,    /* 0xab - . */
	0xaa,    /* 0xac - * */
	0xf0,    /* 0xad - p */
	0xa9,    /* 0xae - ) */
	0xee,    /* 0xaf - n */
	0xf8,    /* 0xb0 - x */
	0xf1,    /* 0xb1 - q */
	0xfd,    /* 0xb2 - } */
	0xfc,    /* 0xb3 - | */
	0xef,    /* 0xb4 - o */
	0xe6,    /* 0xb5 - f */
	0xf4,    /* 0xb6 - t */
	0xfa,    /* 0xb7 - z */
	0xf7,    /* 0xb8 - w */
	0xfb,    /* 0xb9 - { */
	0xa7,    /* 0xba - ' */
	0xaf,    /* 0xbb - / */
	0xac,    /* 0xbc - , */
	0xab,    /* 0xbd - + */
	0xf3,    /* 0xbe - s */
	0xa8,    /* 0xbf - ( */
	0xb7,    /* 0xc0 - 7 */
	0xb5,    /* 0xc1 - 5 */
	0xb6,    /* 0xc2 - 6 */
	0xc7,    /* 0xc3 - G */
	0x8e,    /* 0xc4 -  */
	0x8f,    /* 0xc5 -  */
	0x92,    /* 0xc6 -  */
	0x80,    /* 0xc7 -  */
	0xd4,    /* 0xc8 - T */
	0x90,    /* 0xc9 -  */
	0xd2,    /* 0xca - R */
	0xd3,    /* 0xcb - S */
	0xde,    /* 0xcc - ^ */
	0xd6,    /* 0xcd - V */
	0xd7,    /* 0xce - W */
	0xd8,    /* 0xcf - X */
	0xd1,    /* 0xd0 - Q */
	0xa5,    /* 0xd1 - % */
	0xe3,    /* 0xd2 - c */
	0xe0,    /* 0xd3 - ` */
	0xe2,    /* 0xd4 - b */
	0xe5,    /* 0xd5 - e */
	0x99,    /* 0xd6 -  */
	0x9e,    /* 0xd7 -  */
	0x9d,    /* 0xd8 -  */
	0xeb,    /* 0xd9 - k */
	0xe9,    /* 0xda - i */
	0xea,    /* 0xdb - j */
	0x9a,    /* 0xdc -  */
	0xed,    /* 0xdd - m */
	0xe8,    /* 0xde - h */
	0xe1,    /* 0xdf - a */
	0x85,    /* 0xe0 -  */
	0xa0,    /* 0xe1 -   */
	0x83,    /* 0xe2 -  */
	0xc6,    /* 0xe3 - F */
	0x84,    /* 0xe4 -  */
	0x86,    /* 0xe5 -  */
	0x91,    /* 0xe6 -  */
	0x87,    /* 0xe7 -  */
	0x8a,    /* 0xe8 - 
 */
	0x82,    /* 0xe9 -  */
	0x88,    /* 0xea -  */
	0x89,    /* 0xeb - 	 */
	0x8d,    /* 0xec - 
 */
	0xa1,    /* 0xed - ! */
	0x8c,    /* 0xee -  */
	0x8b,    /* 0xef -  */
	0xd0,    /* 0xf0 - P */
	0xa4,    /* 0xf1 - $ */
	0x95,    /* 0xf2 -  */
	0xa2,    /* 0xf3 - " */
	0x93,    /* 0xf4 -  */
	0xe4,    /* 0xf5 - d */
	0x94,    /* 0xf6 -  */
	0xf6,    /* 0xf7 - v */
	0x9b,    /* 0xf8 -  */
	0x97,    /* 0xf9 -  */
	0xa3,    /* 0xfa - # */
	0x96,    /* 0xfb -  */
	0x81,    /* 0xfc -  */
	0xec,    /* 0xfd - l */
	0xe7,    /* 0xfe - g */
	0x98};   /* 0xff -  */

/*
 * NAME: main
 *
 * FUNCTION: 
 *  Iconv converts the contents of <infile> from the code page
 *  represented by <from> to the code page represented by <to>.
 *  If <infile> is not specified, standard input is read
 *  instead. Conversion is performed on a byte-by-byte basis.
 *
 * EXECUTION ENVIRONMENT:
 *
 * DATA STRUCTURES: The character set vector is defined as a static
 *                    array of type char.
 *
 * RETURN VALUE DESCRIPTION: The results are written to standard output.
 *
 * EXTERNAL PROCEDURES CALLED:  None
 */
main (int argc, char *argv[])
{
    int errflg=0;		/* error flag for command line argument */
    int c;			/* command line option */
    int d;			/* command line option */
    int goodfrom;		/* flag for verifying command line argument */
    int infile=STDIN;		/* input file to be converted */
    unsigned char *tbl;		/* pointer to the chosen conversion table */
    extern char *optarg;	/* command line argument */
    char *fcode=(char *)0;	/* original code page */
    char *tcode=(char *)0;	/* converting code page */
    unsigned char bufs[81];

    scmc_catd = catopen(MF_ICONV, 0);
    while((c=getopt(argc,argv,"f:t:")) != EOF)
    {
        switch(c)
        {
            case 'f':
                fcode = optarg;
                break;
            case 't':
                tcode = optarg;
                break;
            case '?':
                errflg++;
        } /* case */

        if(errflg)
        {
            fprintf (stderr,MSGSTR(M_MSG_1, "Usage: %s -f <from> -t <to> [<infile>]\n"),argv[0]);
            exit (2);
        }
    } /* while */

    if(!fcode || !tcode)
    {
        fprintf (stderr,MSGSTR(M_MSG_1, "Usage: %s -f <from> -t <to> [<infile>]\n"), argv[0]);
        exit (1);
    }

    goodfrom = 0;

    if (strcmp(fcode,"pc850") == 0) {
        goodfrom = 1;
        if (strcmp(tcode,IS591) == 0) {
            tbl = pc850to88591;
        }
        else {
        fprintf (stderr,MSGSTR(M_MSG_2, "iconv: Invalid <to> specification - %s\n"), tcode);
        exit (2);
        }
    }

    if (strcmp(fcode,IS591) == 0) {
        goodfrom = 1;
        if (strcmp(tcode,"pc850") == 0) {
            tbl = is88591topc850;
        }
        else {
        fprintf (stderr,  MSGSTR(M_MSG_2, "iconv: Invalid <to> specification - %s\n"), tcode);
        exit (2);
        }
    }

    if (goodfrom == 0) {
        fprintf (stderr,  MSGSTR(M_MSG_3, "iconv: Invalid <from> specification - %s\n"), fcode);
        exit (4);
    }

    if (argc == 6) {     /* read infile */
        close(STDIN);
        if ((infile = open(argv[argc-1], O_RDONLY)) == -1) {
            fprintf (stderr,MSGSTR(M_MSG_4, "iconv: Cannot open %s\n"),argv[argc-1]);
            exit (4);
        }
    }
    while ((c = read(infile,bufs,80)) != NULL)
    {
	d = c;
	while(c--)
	    bufs[c] = tbl[bufs[c]];
        write(STDOUT,bufs,d);
    }
    exit (0);
}
