/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

#if !defined(lint) && !defined(_NOIDENT)
static char rcsid[] = "@(#)$RCSfile: colcrt.c,v $ $Revision: 1.2 $ (OSF) $Date: 1994/11/19 01:20:46 $";
#endif

/*
 * COMPONENT_NAME: (CMDTEXT) Text Formatting Services
 *
 * FUNCTIONS:
 *
 * ORIGINS: 10,26,27
 *
 * This module contains IBM CONFIDENTIAL code. -- (IBM
 * Confidential Restricted when combined with the aggregated
 * modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * colcrt.c	1.3  com/bsd.d/colcrt.d,3.1,9021 12/21/89 13:08:01
 */

/*
 * Copyright (c) 1980 Regents of the University of California. All rights
 * reserved.	The Berkeley software License Agreement specifies the terms
 * and conditions for redistribution. 
 */

/*
 * #ifndef lint char copyright[] = "@(#) Copyright (c) 1980 Regents of the
 * University of California.\n\ All rights reserved.\n"; #endif not lint 
 */

/*
 * #ifndef lint static char sccsid[] = "@(#)colcrt.c	5.1 (Berkeley)
 * 5/31/85"; #endif not lint 
 */
#include <locale.h>
#include "nl_types.h"
#include "colcrt_msg.h"
nl_catd         catd;
#define MSGSTR(n,s) catgets(catd,MS_COLCRT,n,s)

#include <NLchar.h>
#include <stdio.h>
/*
 * colcrt - replaces col for crts with new nroff esp. when using tbl. Bill
 * Joy UCB July 14, 1977 
 *
 * This filter uses a screen buffer, 267 half-lines by 132 columns. It
 * interprets the up and down sequences generated by the new nroff when used
 * with tbl and by \u \d and \r. General overstriking doesn't work correctly.
 * Underlining is split onto multiple lines, etc. 
 *
 * Option - suppresses all underlining. Option -2 forces printing of all half
 * lines. 
 */
#define COLUMN	264
int             contline;
int             controw;

#define ROW	 267

char            page[ROW][COLUMN];
#ifdef KJI
char           *upos;		/* Save the last underline position */
#endif

int             outline = 1;
int             outcol,
                codepos,
                codcont;
int             underline;

char            suppresul;
char            printall;

char           *progname;
FILE           *f;
char           *curpos;
int             charcont;

main (argc, argv)
    int             argc;
    char           *argv[];
{
    register        c;
    register char  *cp,
                   *dp;
    register       *ctmp;
    int             ii;
    char            tmp[300];

    catd = catopen (MF_COLCRT, 0);
    setlocale(LC_ALL, "");

    argc--;
    progname = *argv++;
    while (argc > 0 && argv[0][0] == '-')
    {
	switch (argv[0][1])
	{
	case 0:
	    suppresul = 1;
	    break;
	case '2':
	    printall = 1;
	    break;
	default:
	    printf (MSGSTR (USAGE, "usage: %s [ - ] [ -2 ] [ file ... ]\n"), progname);	/* MSG */
	    fflush (stdout);
	    exit (1);
	}
	argc--;
	argv++;
    }
    do
    {
	if (argc > 0)
	{
	    close (0);
	    if ((f = fopen (argv[0], "r")) == 0)
	    {
		fflush (stdout);
		perror (argv[0]);
		exit (1);
	    }
	    argc--;
	    argv++;
	}
	for (;;)
	{
	    c = getc (stdin);
	    if (c == -1)
	    {
		pflush (outline);
		fflush (stdout);
		break;
	    }
	    switch (c)
	    {
	    case '\n':
		if (outline >= 265)
		    pflush (62);
		outline += 2;
		outcol = 0;
		charcont = 0;
		controw = 0;
		continue;
	    case '\016':
	    case '\017':
		continue;
	    case 033:
		c = getc (stdin);
		switch (c)
		{
		case '9':
		    if (outline >= 266)
			pflush (62);
		    for (ii = 0; ii < outcol; ii++)
		    {
			if (page[outline][ii] == '\0')
			    tmp[ii] = ' ';
			else
			    tmp[ii] = page[outline][ii];
		    }
		    tmp[outcol] = '\0';
		    codepos = NLstrdlen (tmp);
		    outline++;
		    for (ii = 0, codcont = 0;; ii++)
		    {
			if (NCisshift (page[outline][ii]))
			    ii++;
			if (codepos == codcont)
			    break;
			codcont++;
		    }
		    outcol = ii;
		    continue;
		case '8':
		    if (outline >= 1)
		    {
			for (ii = 0; ii < outcol; ii++)
			{
			    if (page[outline][ii] == '\0')
			    {
				tmp[ii] = ' ';
			    } else
			    {
				tmp[ii] = page[outline][ii];
			    }
			}
			tmp[outcol] = '\0';
			codepos = NLstrdlen (tmp);
			outline--;
			for (ii = 0, codcont = 0;; ii++)
			{
			    if (NCisshift (page[outline][ii]))
				ii++;
			    if (codepos == codcont)
				break;
			    codcont++;
			}
			outcol = ii;
		    }
		    continue;
		case '7':
		    for (ii = 0; ii < outcol; ii++)
		    {
			if (page[outline][ii] == '\0')
			    tmp[ii] = ' ';
			else
			    tmp[ii] = page[outline][ii];
		    }
		    tmp[outcol] = '\0';
		    codepos = NLstrdlen (tmp);
		    outline -= 2;
		    for (ii = 0, codcont = 0;; ii++)
		    {
			if (NCisshift (page[outline][ii]))
			    ii++;
			if (codepos == codcont)
			    break;
			codcont++;
		    }
		    outcol = ii;
		    if (outline < 0)
			outline = 0;
		    continue;
		default:
		    continue;
		}
	    case '\b':
		if (outcol)
		{
		    curpos = &page[outline][outcol];
		    backstep (page[outline], &curpos);
		    outcol -= ((&page[outline][outcol]) - (curpos));
		}
		if (charcont)
		    charcont--;
		contline = 0;
		continue;
	    case '\t':
		outcol += 8;
		outcol &= ~7;
		outcol--;
		charcont += 8;
		charcont &= ~7;
		charcont--;
		c = ' ';
	    default:
		if (NLstrdlen (page[outline]) >= 132)
		{
		    outcol++;
		    charcont++;
		    continue;
		}
		cp = &page[outline][outcol];
		outcol++;
		charcont++;
		if (c == '_')
		{
		    if (suppresul)
			continue;
#ifndef KJI
		    cp = &page[outline + 1][charcont - 1];
		    contline++;
		    underline = 1;
#else
		    cp += COLUMN;
		    upos = cp + 1;
		    underline = 2;
#endif
		    c = '-';
		} else
		{
		    contline = 0;
		}
		if (*cp == 0)
		{
		    *cp = c;
		    if (underline == 1)
		    {
			dp = page[outline + 1] - 1;
		    } else
		    {
			dp = cp - outcol;
		    }
		    for (cp--; cp > dp && *cp == 0; cp--)
		    {
			*cp = ' ';
		    }
		} else
		{
		    if (plus (c, *cp) || plus (*cp, c))
		    {
			*cp = '+';
		    } else
		    if (*cp == ' ' || *cp == 0)
		    {
			*cp = c;
		    }
		}

		if (NCisshift (c))
		{
		    *(++cp) = c;
		    c = getc (stdin);
		    *(++cp) = c;
		    outcol++;
#ifdef KJI
		    if (underline == 1)
			if (*upos == '|')
			    *upos = '+';
			else
			if (*upos == ' ' || *upos == 0)
			    *upos = '-';
#endif
		}
		if (underline)
		    underline--;
		continue;
	    }
	}
    }
    while (argc > 0);
    fflush (stdout);
    exit (0);
}
plus (c, d)
    char            c,
                    d;
{

    return (c == '|' && d == '-' || d == '_');
}

int             first;

pflush (ol)
    int             ol;
{
    register int    i,
                    j;
    register char  *cp;
    char            lastomit;
    int             l;

    l = ol;
    lastomit = 0;
    if (l > 266)
	l = 266;
    else
	l |= 1;
    for (i = first | 1; i < l; i++)
    {
	move (i, i - 1);
	move (i, i + 1);
    }
    for (i = first; i < l; i++)
    {
	cp = page[i];
	if (printall == 0 && lastomit == 0 && *cp == 0)
	{
	    lastomit = 1;
	    continue;
	}
	lastomit = 0;
	printf ("%s\n", cp);
    }
    bcopy (page[ol], page, (267 - ol) * COLUMN);
    bzero (page[267 - ol], ol * COLUMN);
    outline -= ol;
    outcol = 0;
    first = 1;
}

move (l, m)
    int             l,
                    m;
{
    register char  *cp,
                   *dp;

    for (cp = page[l], dp = page[m]; *cp;
	 cp += NLchrlen (cp), dp += NLchrlen (dp))
    {
	switch (*cp)
	{
	case '|':
	    if (*dp != ' ' && *dp != '|' && *dp != 0)
		return;
	    break;
	case ' ':
	    break;
	default:
	    return;
	}
    }
    if (*cp == 0)
    {
	for (cp = page[l], dp = page[m]; *cp;
	     cp += NLchrlen (cp), dp += NLchrlen (dp))
	    if (*cp == '|')
		*dp = '|';
	    else
	    if (*dp == 0)
		*dp = ' ';
	page[l][0] = 0;
    }
}

backstep (bufstart, bufptr)
    char           *bufstart;
    char          **bufptr;
{
    char           *p;

    if (*bufptr <= bufstart)
	return (NULL);
    *bufptr -= 1;
    if (NCisshift (**bufptr))
	*bufptr -= 1;
    else
    {
	for (p = *bufptr; p > bufstart && NCisshift (p[-1]); --p)
	    ;
	if ((int) (*bufptr - p) & 1)
	    *bufptr -= 1;
    }
    return (1);
}
