/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/* @(#)init.h	1.15  com/cmd/oper/init,3.1,8951 9/18/89 10:54:02 */
/*
 * COMPONENT_NAME: (CMDOPER) commands needed for basic system needs
 *
 * FUNCTIONS: 
 *
 * ORIGINS: 3, 27
 *
 * This module contains IBM CONFIDENTIAL code. -- (IBM
 * Confidential Restricted when combined with the aggregated
 * modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 */

/*	In case of bugs, there are four flavors of debug available.	*/
/*									*/
/*	UDEBUG		Will generate a version of "init" that can	*/
/*			be run as a user process.  In this form,	*/
/*			certain signals will cause core dumps and	*/
/*			and a file called "debug" is written in the	*/
/*			directory where "init" was started.  It also	*/
/*			reads the local directory for utmp, inittab	*/
/*			and the other files it usually gets from	*/
/*			/etc.						*/
/*									*/
/*	XDEBUG		Generates an "init" which runs in the usual	*/
/*			way, but generates a file, /etc/debug, with	*/
/*			information about process removal, level	*/
/*			changes, and accounting.			*/
/*									*/
/*	DEBUG1		This symbol adds more debug to what would be	*/
/*			generated by XDEBUG or UDEBUG.  It has		*/
/*			detailed information about each process		*/
/*			spawned from inittab.  DEBUG1 by itself is	*/
/*			equivalent to XDEBUG and DEBUG1.  It can be	*/
/*			added to UDEBUG to get a user process version.	*/
/*									*/
/*	ACCTDEBUG	Generate debug from the accounting program	*/
/*			only.						*/
/*									*/
/* There is the compile-time option available for your perusal:         */
/*									*/
/*	NLS		The IBM native language conversion system.	*/
/*									*/
/*									*/

#ifdef	ACCTDEBUG
#define	DEBUGGER
#endif

#ifdef	XDEBUG
#ifndef	DEBUGGER
#define	DEBUGGER
#endif
#endif

#ifdef	UDEBUG
#ifndef	XDEBUG
#define	XDEBUG
#endif
#ifndef	ACCTDEBUG
#define	ACCTDEBUG
#endif
#ifndef	DEBUGGER
#define	DEBUGGER
#endif
#endif

#ifdef	DEBUG1
#ifndef	XDEBUG
#define	XDEBUG
#endif
#ifndef	ACCTDEBUG
#define	ACCTDEBUG
#endif
#ifndef	DEBUGGER
#define	DEBUGGER
#endif
#endif

#define	FAILURE	-1

/*	SLEEPTIME	The "number of seconds 'init' sleeps between	*/
/*			wakeups if nothing else requires this 'init'"	*/
/*			wakeup.						*/
/*	MAXCMDL		The maximum length of a command string in	*/
/*			/etc/inittab.					*/
/*	EXEC		The length of the prefix string added to all	*/
/*			commands found in /etc/inittab.			*/
/*	TWARN		The amount of time between warning signal,	*/
/*			SIGTERM, and the fatal kill signal, SIGKILL.	*/
/*	WARNFREQUENCY	The number of consecutive failures to find an	*/
/*			empty slot in "init's" internal "proc_table"	*/
/*			before another error message will be generated.	*/
#define	SLEEPTIME	5*60
#define	MAXCMDL	1024
#define IDENT_LEN 14	/* Length of identifier field in inittab */
#define	EXEC	(sizeof("exec ") - 1)
#define	TWARN	15
#define	WARNFREQUENCY	25

/*	Correspondence of signals to init actions.			*/
#define LVLQ	SIGHUP
#define	LVL0	SIGINT
#define	LVL1	SIGQUIT
#define	LVL2	SIGILL
#define	LVL3	SIGTRAP
#define	LVL4	SIGIOT
#define	LVL5	SIGEMT
#define	LVL6	SIGFPE
#define	LVL7	SIGTTIN
#define	LVL8	SIGTTOU
#define	LVL9	SIGIO
#define	SINGLE_USER	SIGBUS
#define	LVLa	SIGSEGV
#define	LVLb	SIGSYS
#define	LVLc	SIGPIPE
#define SHUTDOWN SIGTERM

/*	Bit Mask for each level.  Used to determine legal levels.
	Init code assumes no gaps between MASK0 and MASKSU.	*/
#define	MASK0	0x0001
#define	MASK1	0x0002
#define	MASK2	0x0004
#define	MASK3	0x0008
#define	MASK4	0x0010
#define	MASK5	0x0020
#define	MASK6	0x0040
#define	MASK7	0x0080
#define	MASK8	0x0100
#define	MASK9	0x0200
#define	MASKSU	0x0400	/* note gap for 2 new codes */
#define	MASKa	0x2000
#define	MASKb	0x4000
#define	MASKc	0x8000

/*	Legal action field values.					*/
/* Kill process if on, otherwise ignore */
#define	OFF		0
/* Continually restart process when it dies */
#define	RESPAWN		1
/* Respawn for a,b,c type processes */
#define	ONDEMAND	RESPAWN
/* Start process.  Do not respawn when dead */
#define	ONCE		2
/* Perform once and wait to complete */
#define	WAIT		3
/* Start at boot time only */
#define	BOOT		4
/* Start at boot time and wait for complete */
#define	BOOTWAIT	5
/* Start on powerfail */
#define	POWERFAIL	6
/* Start and wait for complete on powerfail */
#define	POWERWAIT	7
/* Default level "init" should start at. */
#define	INITDEFAULT	8
/* Actions performed before init speaks. */
#define	SYSINIT		9

#define	M_OFF		0001
#define	M_RESPAWN	0002
#define	M_ONDEMAND	M_RESPAWN
#define	M_ONCE		0004
#define	M_WAIT		0010
#define	M_BOOT		0020
#define	M_BOOTWAIT	0040
#define	M_PF		0100
#define	M_PWAIT		0200
#define	M_INITDEFAULT	0400
#define M_SYSINIT	01000


/*	Init can be in either of three main states, "normal" mode	*/
/*	where it is processing entries for the lines file in a normal	*/
/*	fashion, "boot" mode, where it is only interested in the boot	*/
/*	actions, and "powerfail" mode, where it is only interested in	*/
/*	powerfail related actions.  The following masks declare the	*/
/*	legal actions for each mode.					*/
#define	NORMAL_MODES	(M_OFF | M_RESPAWN | M_ONCE | M_WAIT)
#define	BOOT_MODES	(M_BOOT | M_BOOTWAIT)
#define	PF_MODES	(M_PF | M_PWAIT)

#define	ID	1
#define	LEVELS	2
#define	ACTION	3
#define	COMMAND	4
#define TRUE	1
#define FALSE	0

/***************************************************
* process ids
* process numbers
* Init's internal proc table
***************************************************/
#define	id_eq(x,y)	(strncmp(x, y, IDENT_LEN) ? FALSE : TRUE)
#ifdef UDEBUG
pid_t SPECIALPID;	/* Any pid can be made special for debugging */
#else
/* Normally the special pid is process 1 */
#define	SPECIALPID	1
#endif

#ifdef NPROC
#undef NPROC
#endif
#define	NPROC	2000


struct proc {
	struct proc *p_next;
	struct proc *p_prev;
	time_t p_time;	/* Start time for a series of respawns */
	pid_t p_pid;	/* Process id */
	short p_count;	/* How many respawns of command in current series. */
	char p_id[IDENT_LEN];	/* unique id of process */
	short p_flags;
	short p_exit;	/* Exit status of a process which died */
};

extern struct proc *proc_table;	/* Table of active processes */
extern struct proc dummy;	/* A zero table used when calling "account"
				   for non-process type accounting. */
#define	NULLPROC	((struct proc *)(0))
#define	NO_ROOM		((struct proc *)(FAILURE))

/*	Flags for the "p_flags" word of a proc_table entry.		*/
/*									*/
/*	LIVING			Process is alive.			*/
/*	NOCLEANUP		"efork()" is not allowed to cleanup	*/
/*					this entry even if process is	*/
/*					dead.				*/
/*	NAMED			This process has a name, i.e. came from	*/
/*					/etc/inittab.			*/
/*	DEMANDREQUEST		Process started by a "telinit [abc]"	*/
/*					command.  Processes formed this	*/
/*					way are respawnable and immune	*/
/*					to level changes as long as	*/
/*					their entry exists in inittab.	*/
/*	TOUCHED			Flag used by "remove" to determine	*/
/*					whether it has looked at an	*/
/*					entry while checking for	*/
/*					processes to be killed.		*/
/*	WARNED			Flag used by "remove" to mark processes	*/
/*					that have been sent the		*/
/*					SIGTERM signal.  If they don't	*/
/*					die in 30 seconds, they will	*/
/*					be sent the SIGKILL signal.	*/
/*	KILLED			Flag used by "remove" to say that a	*/
/*					process has been sent both	*/
/*					kill signals.  Such processes	*/
/*					should die immediately, but in	*/
/*					case they don't, this prevents	*/
/*					"init" from trying to kill it	*/
/*					again and again, and hogging	*/
/*					the process table of the	*/
/*					operating system.		*/
#define	LIVING		0x1
#define	NOCLEANUP	0x2
#define	NAMED		0x4
#define	DEMANDREQUEST	0x8
#define	TOUCHED		0x10
#define	WARNED		0x20
#define	KILLED		0x40

/*	Respawn limits for processes that are to be respawned.		*/
/*									*/
/*	SPAWN_INTERVAL		The number of seconds over which	*/
/*				"init" will try to respawn a process	*/
/*				SPAWN_LIMIT times before it gets mad.	*/
/*									*/
/*	SPAWN_LIMIT		The number of respawns "init" will	*/
/*				attempt in SPANW_INTERVAL seconds	*/
/*				it generates an error message and	*/
/*				inhibits further tries for INHIBIT	*/
/*				seconds.				*/
/*									*/
/*	INHIBIT			The number of seconds "init" ignores	*/
/*				an entry it had trouble spawning	*/
/*				unless a "telinit Q" is received.	*/
#define	SPAWN_INTERVAL	(2*60)
#define	SPAWN_LIMIT	20
#define	INHIBIT		(5*60)

/***********************************
* This is the command fields struc 
* read in from the inittab file entry.
***********************************/
struct CMD_LINE {
	char 	c_id[IDENT_LEN];/* unique id of process to be affected */
	short 	c_levels;	/* Mask of legal levels for process */
	short 	c_action;	/* Mask for type of action required */
	char	*c_command;	/* Pointer to init command */
};

/*	Following are symbols for the various types of errors for	*/
/*	which "error_time" keeps timing entries.  MAX_E_TYPES is the	*/
/*	number of types currently being kept.				*/
#define	FULLTABLE	0
#define	BADLINE		1
#define	MAX_E_TYPES	2

static struct ERRORTIMES {
	long e_time;	/* Time of last message. */
	long e_max;	/* Amount of time to wait until next message. */
} err_times[MAX_E_TYPES] = { 0, 120, 0, 120 };

/***************************************
*	Useful file and device names.  *
***************************************/
extern char	*CONSOLE;
extern char	*SYSCON;


extern char	*UTMP;
extern char	*WTMP;
extern char	*INITTAB;
#ifdef	DEBUGGER
extern char	*DBG_FILE;
#endif

#if defined(NLS) || defined(KJI)
/*
if NLCTAB_KEY is changed here it must also be changed in NLchar.h in 
/usr/include/sys
*/
#define NLCTAB_KEY 1052
extern char  defctab[];
#endif

/*************************************
* The following structures contain a set
* of modes for /dev/console. The macros
* are defined in sys/termio.h.
*************************************/

#include	<unistd.h>
#include	<sys/termios.h>

extern struct  termios  dflt_termios;
extern struct termios   termios;


/*****************************************
* EXTERNAL VARIABLES
*****************************************/

extern int	n_prev[];
extern int	cur_state;
extern int	prev_state;
extern int	new_state;
extern int	prior_state;
extern int	op_modes;

/* A Flag And Its Masks */
extern int wakeup_flags;

#define W_USRSIGNAL	0x1
#define W_CHILDEATH	0x2
#define W_POWERFAIL	0x4
#define W_SHUTDOWN	0x8

extern unsigned int	spawncnt, pausecnt;
extern int	rsflag;
extern pid_t	own_pid;
