/* Source code copyright 1989 by Alan M. Carroll, all rights reserved.
 * This code may be freely distributed as long as the copyright is preserved.
 */

/*
 * $Revision: 1.1.1.1 $
 * $Source: /bsdi/MASTER/BSDI_OS/contrib/emacs/epoch-src/xdefault.h,v $
 * $Date: 1992/07/28 00:45:32 $
 * $Author: polk $
 */
typedef enum
    {
    XDT_Int,				/* convert to int and store */
    XDT_String,				/* keep the string */
    XDT_BoolT,			/* set char to 0/1 for off/on, default 1 */
    XDT_BoolF,			/* set char to 0/1 for off/on, default 0 */
    XDT_Flag,				/* set true if present */
    XDT_Window				/* X-window id (run-time) */
    } XDefaultType ;

struct XDefaultEntry
    {
    VOID * addr;		/* address of default */
    XDefaultType type;		/* type of default */
    char * name;	/* fully qualified name of the default */
    char * class;	/* and class */
    } ;

struct Default_Set
    {
    char *name;			/* name of the screen */
    char *resource;		/* resource name for screen */
    char *class;		/* resource class for the screen */
    char *default_geometry;	/* hard-wired default */
    char *requested_geometry;	/* user-specified value */
    char *foreground;		/* foreground color */
    char *background;		/* background color */
    char *cursor;		/* cursor color */
    char *xfcursor;		/* X foreground cursor color */
    char *xbcursor;		/* X background cursor color */
    char *font;			/* font name */
    char *icon_name;		/* icon name property */

    int plane;			/* x display plane (negative->default plane) */

    int in_border;		/* internal border width */
    int out_border;		/* external border width */
    char *color_border;		/* border color */

    int min_height;		/* min # of lines */
    int min_width;		/* min # of columns */

    int cursor_glyph;		/* index into cursor font */

    char initial_state;		/* initial state hint */
    char reverse;		/* reverse videO, yip! yip! */
    char update_screen;		/* update when not current screen */
    char motion_hints;		/* Enable motion hints */
    Window parent;		/* X window id for parent */
    char nonlocal_minibuf;	/* distinct minibuf */
    } ;

extern struct Default_Set XD_screen,XD_minibuf;
