case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting utils/messages (with variable substitutions)"
echo $startsh > messages
cat >>messages <<'!NO!SUBS!'
# messages: part of the Elm mail system
# @(#)Id: messages.SH,v 5.2 1992/10/17 22:38:58 syd Exp 
#		Copyright (c) 1988-1992 USENET Community Trust
# 		Copyright (c) 1986,1987 Dave Taylor
 
if [ "$2" != "" ]; then
  echo Usage: messages \{folder-name\} 1>&2
  exit 1
fi
 
if [ "$1" = "" ]; then
!NO!SUBS!
echo "  fname=\${MAIL-$maildir/\$LOGNAME}" >> messages
cat >>messages <<'!NO!SUBS!'
  optional="in your incoming mailbox"
else
  optional="in folder $1"
  first=`expr "$1" : "\(.\).*"`
  if [ "$first" = "=" ]; then
    last=`expr "$1" : ".\(.*\)"`
    fname="`grep maildir $HOME/.elm/elmrc | awk -F= '{print $2}'| tr -d ' '`/$last"
  else
    fname=$1
  fi
fi

if [ -f "$fname" ]; then
  mcount=`egrep -c "^From " $fname`
else
  echo "Folder $1 does not exist."
  exit 0
fi
 
if [ "$mcount" -eq 1 ]; then
  echo There is 1 message $optional.
elif [ "$mcount" -eq 0 ]; then
  echo There are no messages $optional.
else
  echo There are $mcount messages $optional.
fi
 
exit $mcount
!NO!SUBS!
