/* $Header:_set.c 12.0$ */
/* $ACIS:_set.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_set.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_set.c 12.0$";
#endif

#include "whim.h"
VI_Color(color)
  INT16 color;			    /* new color */
  begin
#include "whimdcl.h"
    if (saving) { JOURNL(V_COLOR);
		  JOURNL(color);}
    /* force out pending graphics before we change color */
    VI_Force();
    /* set global color static accordingly */
    parms.color = color;
  end

VI_Clip(lx,ly,hx,hy)
  INT16 lx,ly,hx,hy;		     /* new clipping window */
  begin
#include "whimdcl.h"
    if (saving) { JOURNL(V_CLIP);
		  JOURNL(lx);
		  JOURNL(ly);
		  JOURNL(hx);
		  JOURNL(hy);}
    /* force out pending graphics before we change clipping window */
    VI_Force();
    /* record user clipping values, for query purposes */
    parms.userclx = lx;
    parms.usercly = ly;
    parms.userchx = hx;
    parms.userchy = hy;
    /* set global color static accordingly */
    parms.cliplx = max(0,lx);
    parms.cliply = max(0,ly);
    parms.cliphx = min(1023,hx);
    parms.cliphy = min(799,hy);
  end

VI_Merge(merge)
  INT16 merge;			   /* merge mode */
  begin
#include "whimdcl.h"
    if (saving) { JOURNL(V_MERGE);
		  JOURNL(merge); }
    clear(2);	/* 2-word order */
    vikint[vikoff++] = 1;	       /* merge order */
    vikint[vikoff++] = merge;	  /* merge mode */
  end

VI_Font(fontid)
  INT16 fontid; 		    /* font id */
  begin
#include "whimdcl.h"
  INT16 found;
  fontdesc *font;
  char *fntname;
    if (saving) { font = fonts;
		  found = 0;
		  fntname = "notfound";
		  while (found == 0 && font != NULL)
		      { if (font->id == fontid)
			  { found = 1;
			    fntname = font->name;
			  }
			  else font = font->nfont;
		      }
		  JOURNL(V_FONT);
		  strjour(fntname);
		}
    clear(2);	/* 2-word order */
    vikint[vikoff++] = 2;	      /* font order */
    vikint[vikoff++] = fontid;	 /* font id */
  end

VI_Width(width)
  INT16 width;			      /* line width */
  begin
#include "whimdcl.h"
    if (saving) { JOURNL(V_WIDTH);
		  JOURNL(width); }
    clear(2);	/* 2-word order */
    vikint[vikoff++] = 4;	      /* width order */
    vikint[vikoff++] = width;	 /* line width */
  end

VI_Dash(dashpat,dashlen)
  INT16 dashpat,dashlen;		     /* new line pattern */
  begin
#include "whimdcl.h"

    if (saving) { JOURNL(V_DASH);
		  JOURNL(dashpat);
		  JOURNL(dashlen); }

    clear(3);	/* 3-word order */
    vikint[vikoff++] = 3;	      /* dash order */
    vikint[vikoff++] = dashpat;  /* dash pattern */
    vikint[vikoff++] = dashlen;  /* dash length */
  end
