/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:tth29.c 12.0$ */
/* $ACIS:tth29.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ucb/window/RCS/tth29.c,v $ */

#ifndef lint
static char *rcsid = "$Header:tth29.c 12.0$";
#endif

#ifndef lint
static char sccsid[] = "@(#)tth29.c	3.4 5/2/86";
#endif

/*
 * Copyright (c) 1983 Regents of the University of California,
 * All rights reserved.  Redistribution permitted subject to
 * the terms of the Berkeley Software License Agreement.
 */

#include "ww.h"
#include "tt.h"

/*
kC|h29|heath-29|z29|zenith-29:\
	:am:bc=\ED:bt=\E-:cr=^M:do=^J:nl=^J:bl=^G:\
	:al=\EL:le=^H:bs:cd=\EJ:ce=\EK:cl=\EE:cm=\EY%+ %+ :co#80:dc=\EN:\
	:dl=1*\EM:do=\EB:ei=\EO:ho=\EH:im=\E@:li#24:mi:nd=\EC:as=\EF:ae=\EG:\
	:ms:ta=^I:pt:sr=\EI:se=\Eq:so=\Ep:up=\EA:vs=\Ex4:ve=\Ey4:\
	:kb=^H:ku=\EA:kd=\EB:kl=\ED:kr=\EC:kh=\EH:kn#1:k0=\E~:l0=HOME:\
	:k1=\ES:k2=\ET:k3=\EU:k4=\EV:k5=\EW:k6=\EP:k7=\EQ:k8=\ER:k9=\E01:\
	:es:hs:ts=\Ej\Ex5\Ex1\EY8%+ \Eo:fs=\Ek\Ey5:ds=\Ey1:us=\Es8:ue=\Es0:
*/

extern struct tt_str *gen_XS;
extern struct tt_str *gen_XE;

#define pc(c)	ttputc('c')
#define esc()	pc(\033)

h29_setmodes(new)
register new;
{
	register modes = '0';

	if (new & WWM_REV)
		modes |= 1;
	if (new & WWM_BLK)
		modes |= 2;
	if (new & WWM_UL)
		modes |= 8;
	esc();
	pc(s);
	ttputc(modes);
	if (new & WWM_GRP) {
		if ((tt.tt_modes & WWM_GRP) == 0)
			esc(), pc(F);
	} else
		if (tt.tt_modes & WWM_GRP)
			esc(), pc(G);
	if (new & WWM_USR) {
		if ((tt.tt_modes & WWM_USR) == 0 && gen_XS)
			ttxputs(gen_XS);
	} else
		if (tt.tt_modes & WWM_USR && gen_XE)
			ttxputs(gen_XE);
	tt.tt_modes = new;
}

tt_h29()
{
	if (tt_h19() < 0)
		return -1;
	tt.tt_setmodes = h29_setmodes;
	tt.tt_availmodes |= WWM_BLK|WWM_UL;
	return 0;
}
