/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:frexp.c 12.0$ */
/* $ACIS:frexp.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/gen/RCS/frexp.c,v $ */

#ifndef lint
static char *rcsid = "$Header:frexp.c 12.0$";
#endif

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)frexp.c	5.2 (Berkeley) 3/9/86";
#endif LIBC_SCCS and not lint

/*
 *	the call
 *		x = frexp(arg,&exp);
 *	must return a double fp quantity x which is <1.0
 *	and the corresponding binary exponent "exp".
 *	such that
 *		arg = x*2^exp
 *	if the argument is 0.0, return 0.0 mantissa and 0 exponent.
 */

double
frexp(x,i)
double x;
int *i;
{
	int neg;
	int j;
	j = 0;
	neg = 0;
	if(x<0){
		x = -x;
		neg = 1;
		}
	if(x>=1.0)
		while(x>=1.0){
			j = j+1;
			x = x/2;
			}
	else if(x<0.5 && x != 0.0)
		while(x<0.5){
			j = j-1;
			x = 2*x;
			}
	*i = j;
	if(neg) x = -x;
	return(x);
	}
