/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:lockf.c 12.0$ */
/* $ACIS:lockf.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/compat-sys5/RCS/lockf.c,v $ */

#ifndef lint
static char *rcsid = "$Header:lockf.c 12.0$";
#endif

#include <sys/nfs_defines.h>


#ifdef VFS
/* @(#)lockf.c	1.1 87/12/30 3.2/4.3NFSSRC */
#ifndef lint
static	char sccsid[] = "@(#)lockf.c 1.3 86/10/07 SMI";
#endif

#include <sys/fcntl.h>
#include <errno.h>

extern int errno; 

/*
 * convert lockf() into fcntl() for SystemV compatibility
 */

lockf(fildes, function, size)
	int fildes;
	int function;
	long size;
{
	struct flock ld;
	register int cmd;

	cmd = F_SETLK;		/* assume non-blocking operation */
	ld.l_type = F_WRLCK;	/* lockf() only deals with exclusive locks */
	ld.l_whence = 1;	/* lock always starts at current position */
	ld.l_start = 0;		/* 0 offset from current position */
	ld.l_len = size;	/* may be negative */

	switch (function) {
	case F_TEST:
		if (fcntl(fildes, F_GETLK, &ld) != -1) {
			if (ld.l_type == F_UNLCK)
				return (0);
			else
				errno = EACCES;		/* EAGAIN ?? */
		}
		return (-1);

	default:
		errno = EINVAL;
		return (-1);

			/* the rest fall thru to the fcntl() at the end */
	case F_ULOCK:
		ld.l_type = F_UNLCK;
		break;

	case F_LOCK:
		cmd = F_SETLKW;	/* block, if not available */
		break;

	case F_TLOCK:
		break;
	}
	if (fcntl(fildes, cmd, &ld) == -1) {
		switch (errno) {
		/* this hack is purported to be for /usr/group compatibility */
		case ENOLCK:
			errno = EDEADLK;
		}
		return(-1);
	} else {
		return(0);
	}
}
#endif VFS
