/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:bzero.s 12.0$ */
/* $ACIS:bzero.s 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/bzero.s,v $ */

	.data
rcsid:	.asciz	"$Header:bzero.s 12.0$"
	.text

#include "LINKG.h"
 
 #	Zero memory subroutine for C language
 #	count = bzero(start, count)
 #		      r2     r3

ENTRY(bzero)
	bx	1f
	lis	r4,0		#fill constant

 #	Fill memory subroutine for C language
 #	count = mfill(start, count, byte)
 #		      r2     r3     r4
 
ENTRY(mfill)
 
1:	cas	r0,r3,r0		#count (# of bytes to fill)
 
 #fill single bytes until the source address is full-word aligned
 
srcfwa: 
	cas	r3,r2,r0	#current fill address
	nilz	r3,r3,3		#isolate low order two bits
	jz	ckfwll		#jump if fill address on full word
	inc	r2,1		#incr destination address by one byte
	sis	r0,1		#decr total count by one byte
	bpx	srcfwa		#loop if count > 0
	stc	r4,-1(r2)	#store one byte at the destination
 
		#return to the calling routine
 
return: 
	brx	r15		#return to calling routine
	lis	r2,0		#always return 0 result
 
		#setup a full word with the fill constant
 
ckfwll: mc23	r4,r4		#move fill constant into 3rd byte of r4
	mc13	r4,r4		#move fill constant into 2nd byte of r4
	mc03	r4,r4		#move fill constant into 1st byte of r4
 
		#check the residual byte count
 
	ai	r0,r0,-52	#unfilled byte count - 52
	jl	ckwds		#jump if < 52 bytes unfilled
 
		#save more of the caller's registers on the stack
 
	stm	r6,REG_OFFSET+24(sp)	#save caller's r6 thru r15 on the stack
 
		#set up 13 registers with the fill constant
 
	cas	r3,r4,r0		#duplicate fill constant
	cas	r5,r4,r0		#duplicate fill constant
	cas	r6,r4,r0		#duplicate fill constant
	cas	r7,r4,r0		#duplicate fill constant
	cas	r8,r4,r0		#duplicate fill constant
	cas	r9,r4,r0		#duplicate fill constant
	cas	r10,r4,r0		#duplicate fill constant
	cas	r11,r4,r0		#duplicate fill constant
	cas	r12,r4,r0		#duplicate fill constant
	cas	r13,r4,r0		#duplicate fill constant
	cas	r14,r4,r0		#duplicate fill constant
	cas	r15,r4,r0		#duplicate fill constant

		#fill blocks of 13 words
 
ll13ws: ai	r2,r2,52	#incr destination address by 13 words
	ai	r0,r0,-52	#decr total unfilled byte count
	bpx	ll13ws		#loop if another 13 words remain unfilld
	stm	r3,-52(r2)	#next 13 words of destination = r3-r15
 
		#restore most of the caller's registers from the stack
 
	lm	r6,REG_OFFSET+24(sp)	#restore caller's r6-r15 from the stack
 
		#check the residual byte count
 
ckwds:	ai	r0,r0,48	#unfilled byte count - 4
	jl	ckbyts		#jump if < 4 bytes unfilled
 
		#fill single words
 
llword: inc	r2,4		#incr destination address by one word
	sis	r0,4		#decr total unfilled byte count
	bpx	llword		#loop if another word remains unfilled
	st	r4,-4(r2)	#next destination word = r4
 
		#check the residual byte count
 
ckbyts: ais	r0,4		#unfilled byte count
	jz	return		#jump if no bytes unfilled
 
		#fill single bytes
 
llbyte: inc	r2,1		#incr destination address by one byte
	sis	r0,1		#decr total unfilled byte count
	bpx	llbyte		#loop if count > 0
	stc	r4,-1(r2)	#store one byte at the destination
	j	return		#refuse to do nibbles
 
	TTNOFRM
