/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:queue.c 12.0$ */
/* $ACIS:queue.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/server/RCS/queue.c,v $ */

#ifndef lint
static char *rcsid = "$Header:queue.c 12.0$";
#endif


#ifndef lint
static char rcsid_queue_c[] = "$Header:queue.c 12.0$";
#endif lint

/* This file contains the routines to enqueue and dequeue objects.
 * These routines are identical in function to the standard VAX C library
 * insque and remque functions, with two differences:
 *	1) my remque returns its argument as its value
 *	2) my remque guarantees that the forward and backward links of
 *	   the dequeued element point to itself.
 */


struct qhdr {
	struct qhdr *link, *rlink;
};

insque(new, header)
	register struct qhdr *new, *header;
{
	(*new).link = (*header).link;
	(*new).rlink = header;
	(*(*header).link).rlink = new;
	(*header).link = new;
}


struct qhdr *remque(elt)
	register struct qhdr *elt;
{
	(*(*elt).link).rlink = (*elt).rlink;
	(*(*elt).rlink).link = (*elt).link;
	(*elt).link = (*elt).rlink = elt;
	return(elt);
}
