/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdlog.c 12.0$ */
/* $ACIS:rvdlog.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/cntrl/RCS/rvdlog.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvdlog.c 12.0$";
#endif


#ifndef lint
static char *rcsid_rvdlog_c = "$Header:rvdlog.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* Tell RVD server to log statistics.
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<machineio/vdconst.h>

#define	BUFLEN	4096		/* Long enough to include an authenticator. */

rvdlog(argc, argv)
	int	argc;
	char	**argv;
{
	char	*server; 
	char	*cp;
	char	sbuf[BUFLEN];
	int	debug = 0;
	extern	char	*myname;

	if(argc > 1 && ! strcmp(argv[1], "-d")) {
		++debug;
		--argc;
		++argv;
	}

	if (argc < 2 || 3 < argc) {
		fprintf(stderr, "usage: %s [-a] server\n", myname);
		exit(1);
	}

	/* Handle the "-a" flag by inserting the appropriate command into
	 * the RVD control string.  cp points to the end of the string.
	 */
	if (argc == 3) {
		if (strcmp(argv[1], "-a")) {
			fprintf(stderr, "usage: %s [-a] server\n", myname);
			exit(1);
		}
		server = argv[2];
		sprintf(sbuf, "operation=log_all_statistics\npassword=\n");
	} else {
		server = argv[1];
		sprintf(sbuf, "operation=log_external_statistics\npassword=\n");
	}
	cp = sbuf + strlen(sbuf);

	/* Try an authenticated command first.
	 */
#ifdef	KERBEROS
	if ( get_auth(sbuf, server, myname, debug) &&
	    (ctl_init_send_close(sbuf, server, debug) == NULL))
		exit(NULL);
#endif	KERBEROS

	/* The authenticated command failed so prompt for a password.
	 */
	cp--;
	csprintf(cp, "%s", getpass("Password: ", VD_CAPAB_LEN));

	exit(ctl_init_send_close(sbuf, server, debug));
}
