/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdtab.h 12.0$ */
/* $ACIS:rvdtab.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/rvdtab.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidrvdtab = "$Header:rvdtab.h 12.0$";
#endif

/*
 * $Header:rvdtab.h 12.0$
 * $ACIS:rvdtab.h 12.0$
 * $Author: root $
 * $Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/rvdtab.h,v $
 */
#ifndef _RVDTAB_H_
#define _RVDTAB_H_

#include "canon.h"

#define RVDTAB_SYS "/etc/rvd/rvdtab"
#define RVDTAB_USR "%s/.rvdtab"      /* bleh! */

#define RVDTAB_VIP	0x001	     /* Very Important Pack */
#define RVDTAB_DEF      0x002	     /* up by default */
#define RVDTAB_UP	0x004	     /* spunup already */
#define RVDTAB_MNT	0x008	     /* mount'd already */
#define RVDTAB_MOTD	0x010	     /* motd seen for this entry (host) */

#define ZVDINFO		((struct vd_long_dev *)NULL)

typedef struct rvdtab {
	int flags;		/* application flags */
	int dev;		/* drive number */
	char *host;		/* server hostname */
	char *pack;		/* pack name */
	char *mode;		/* valid modes */
	char *dir;		/* mount directory */
	char *pw;		/* password */
	struct in_addr server;	/* server address or 0.0.0.0 */
} rvdtab_t, *rvdtab_p;
#define ZRVDTAB ((rvdtab_t *)NULL)

void rvd_debugOn();
void rvd_debugOff();
void rvd_parse(/*packname,host,pack*/);
void rvd_perror(/*errno,rvdtab*/);

void rvd_motd(/*hostname,server*/);

int rvd_createInit(/*argc,argv*/);
/* einval - too few args
 */

int rvd_init(/*filename*/);
/* util$yankFile()
 * eio - eof but no data in file
 */

int rvd_up(/*rvdent,mode,pw,ign,fsck*/);
/* evdbad:
 *  rvdeida - already spunup
 *  rvdespn - driveno in use
 *  rvdend - no free drives avail
 *  rvdefsck - fsck failed
 * eaddrnotavail - can't resolve host
 * enotdir - mount-dir not a dir
 * rvd$spinup()
 * mtab$mount()
 */

int rvd_down(/*rvdent,ign*/);
/* mtab$umount()
 * rvd$spindown()
 */

int rvd_spindown(/*driveno*/);
/* vdspind()
 * enoent - special file non-exist
 */

int rvd_spinup(/*server,packname,driveno,mode,passwd*/);
/* evdbad:
 *  rvdebmd - bad mode
 * vdspin()
 * enoent - special file non-exist
 */

int rvd_findFree();
/* evdbad:
 *  rvdend - no free drives avail
 */

int rvd_vipCheck();
int rvd_doneDrive(/*driveno*/);

caddr_t rvd_dev2nam(/*driveno*/);

rvdtab_p rvd_mktemp(/*pack,drive,host,modes,path,pw*/);

rvdtab_p rvd_findEnt(/*packname,mode*/);
/* eaddrnotavail - can't resolve host
 * evdbad:
 *  rvdepack - no such pack on client
 */

struct	vd_long_dev	*rvd_info(/*driveno*/);
/* enodev - driveno not found
 */

struct	vd_long_dev	*rvd_findPack(/*packname*/);
/* eaddrnotavail - can't resolve host
 * evdbad:
 *  rvdepack - no such pack on client
 */


int setrvdent();
int endrvdent();
/*
 * rvd$init()
 * rvd$findEnt()
 */
rvdtab_p getrvdent();
rvdtab_p getrvdnam(/*packname*/);
rvdtab_p getrvddir(/*path*/);
rvdtab_p getrvdhost(/*host*/);

#define rvd_getHost(_r_) ((caddr_t)((_r_)->host))
#define rvd_getServer(_r_) ((_r_)->server)
#define rvd_getPack(_r_) ((caddr_t)((_r_)->pack))
#define rvd_getDir(_r_) ((caddr_t)((_r_)->dir))
#define rvd_getDrive(_r_) ((int)((_r_)->dev))
#define rvd_getPW(_r_) ((caddr_t)((_r_)->pw))
#define rvd_getModes(_r_) ((caddr_t)((_r_)->mode))
#define rvd_getDefMode(_r_) ((char)((_r_)->mode[0]))

#define rvd_setServer(_r_,_s_) ((_r_)->server = (_s_))

#define rvd_selMode(_m_,_r_) (((_m_) == ' ') ? (_r_)->mode[0] : (_m_))

#define rvd_isDefault(_r_) ((_r_)->flags & RVDTAB_DEF)
#define rvd_havePW(_r_) ((_r_) ? ((int)(_r_)->pw[0]) : 0)

#endif
