/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:main_txt3812.c 12.0$ */
/* $ACIS:main_txt3812.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/txt3812/RCS/main_txt3812.c,v $ */

#ifndef lint
static char *rcsid = "$Header:main_txt3812.c 12.0$";
#endif

/***===================================================================***/

extern char *p3_JobType();

#define SJ_DEFAULT_TYPE(e)	p3_JobType(e)
#define SJ_ARG_PARSER(c,v,i,e)	p3_ParseArg(c,v,i,e)

#include <spooljob.c>
#include <pmp/pmp.h>
#include "setup_txt3812.h"

/***===================================================================***/

extern int p3_debug;
extern int ln_debug;

#ifdef DEBUG_UTILS
u_debug_arg debug_args[] = {
    "p3",   &p3_debug,
    "ln",   &ln_debug,
    NULL,  NULL
};

#endif /* DEBUG_UTILS */

/***============================================================***/

char *
p3_JobType(env)
register1 environ	*env;
{
register2 char		*fullname;
register3 char		*name;

    D_ENTRY1(p3_debug,"p3_JobType(0x%x)\n",env);
    fullname= env_String(env,"invocation_name",(char *)NULL);
    if (!fullname) 
	RETURN("text");
    name= rindex(fullname,'/');
    if (name)	name++;
    else	name= fullname;
    if 		(StrMatch(name,"txt3812"))	RETURN("text");
    else if	(StrMatch(name,"pmp3812"))	RETURN("pmp");
    else {
	warning1("Don't know job type for filter named %s\n",name);
	action("assuming \"text\"\n");
	RETURN("text");
    }
}

/***===================================================================***/

p3_ParseArg(argc,argv,ind,env)
register1 int      argc;
register2 char    *argv[];
register3 int      ind;
register4 environ *env;
{
extern int   optind;
extern int   optional;
extern char *optarg;
register5 int ch;
register6 int old= optional;

    D_ENTRY4(p3_debug,"p3_ParseArg(%d,0x%x,%d,0x%x)\n",argc,argv,ind,env);
    optind= ind;
    optional= TRUE;
    ch= getopt(argc,argv,"D?w:l:i:c");
    optional= old;
    switch (ch) {
#ifdef DEBUG_UTILS
	when 'D':	if (optarg) p_set_debug(optarg);
			else        p_set_debug("a");
#else
	when 'D':	warning("debugging arguments disabled\n");
			action("-D flag ignored\n");
#endif /* DEBUG_UTILS */
	case 'w':	
	case 'l':	
		break;
	case 'i':	
     		if (env_Int(env,	"text_indent",	DFL_INDENT) == 0)
			env_AddInt(env,"text_indent",atoi(optarg));
		break;
	case 'c':
		env_AddString(env,"job_type","ascii5152");
		break;
	default:
		warning1("Unknown flag '%c'\n",ch);
		action("ignored\n");
		optind++;
		RETURN(FALSE);
    }
    RETURN(TRUE);
}

/***===================================================================***/

FILE *
p3_Output(env)
register3 environ *env;
{
register1 char *host;
register2 char *user;
char cmd[100];

    D_ENTRY1(p3_debug,"p3_Output(0x%x,0x%x)\n",env);
    host= env_String(env,"host",DFL_HOST);
    user= env_String(env,"user",DFL_USER);
    sprintf(cmd,"%s -h %s -n %s ",OUTPUT_NAME,host,user);
    RETURN(popen(cmd,"w"));
}

/***===================================================================***/

/*ARGSUSED*/
int
p3_Cleanup(in,out)
register1 FILE *in;
register2 FILE *out;
{
    D_ENTRY2(p3_debug,"p3_Cleanup(0x%x,0x%x)\n",in,out);
    if (p_marked())
	p_eject(TRUE);
    p_close();
    RETURN(TRUE);
}

/***============================================================***/

/*ARGSUSED*/
int
ppmp(env,infil,outfil)
register5 environ *env;
register2 FILE    *infil;
register3 FILE    *outfil;
{
register1 int ch;
register4 int knt=0;

    D_ENTRY3(p3_debug,"ppmp(0x%x,0x%x,0x%x)\n",env,infil,outfil);
    while ((ch=getc(infil))!=EOF) {
	putc(ch,outfil);
	knt++;
    }
    RETURN(knt);
}

/***===================================================================***/

/*ARGSUSED*/
int
p5152(env,in,out)
register5 environ *env;
register2 FILE    *in;
register3 FILE    *out;
{
register1 int ch;
register4 int knt=0;
extern int p3_bail;

    D_ENTRY3(p3_debug,"p5152(0x%x,0x%x,0x%x)\n",env,in,out);
    fclose(out);
    out= popen(ASCII_NAME,"w");
    if (!out) {
	fatal1("Can't open '%s' for 5152 data stream\n",ASCII_NAME);
    }
    while (((ch=getc(in))!=EOF)&&(!p3_bail)) {
	putc(ch,out);
	knt++;
    }
    putc('\33',out);
    putc('C',out);
    putc(66,out);
    RETURN(knt);
}

/***============================================================***/

p3_CancelText()
{
extern int p3_bail;

    D_ENTRY(p3_debug,"p3_Cancel()\n");
    p3_bail= TRUE;
    RETURN(SJ_EXIT_PENDING);
}

/***============================================================***/

p3_CancelPmp()
{
    D_ENTRY(p3_debug,"p3_CancelPmp()\n");
    RETURN(SJ_IGNORE);
}

/***===================================================================***/

extern int   p3812();

sj_jobtype sj_types[]= {
    {"text",	   NULL, p3_Output, NULL, p3812, p3_Cleanup,p3_CancelText},
    { "ascii5152", NULL, p3_Output, NULL, p5152, NULL,      p3_CancelText},
    { "pmp",	   NULL, p3_Output, NULL, ppmp,  NULL,	 p3_CancelPmp},
    { NULL,        NULL, NULL,	NULL, NULL,  NULL, NULL  }
};

