/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:make_usqzpmp.c 12.0$ */
/* $ACIS:make_usqzpmp.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/bitprt_ca/RCS/make_usqzpmp.c,v $ */

#ifndef lint
static char *rcsid = "$Header:make_usqzpmp.c 12.0$";
#endif

#include <stdio.h>

#define LPIXELS	1024	/* required input-image scanline size */

#define CH_ALLWHITE 0x01
#define CH_ALLBLACK 0x02
#define CH_ALL0GREY 0x03
#define CH_ALL1GREY 0x04
#define CH_WHITE 0x80
#define CH_BLACK 0xa0
#define CH_GREY0 0xc0
#define CH_GREY1 0xe0
#define CH_1WH 0x10
#define CH_1BL 0x40
#define CH_IMAGE 0x70
char pmpbuf[512];
int pmpcnt;
int reddev;

unsigned char pl[256]={
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255
};
unsigned char ph[256]={
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,
	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,
	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
	192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
	195,195,195,195,195,195,195,195,195,195,195,195,195,195,195,195,
	204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
	207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,
	240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
	243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
	252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
};

main()
{
	int i,j,k,l;
	int bits,bytes;
#ifdef DEBUG
	fprintf(stderr,"make_usqzpmp started.\n");
#endif DEBUG
	reddev = 1;  /* use standard output for output */
	pmpinit();

	pmpprt(0xd3);
	pmpprt(0);
	pmpprt(0xd4);
	pmpprt(33);   /*unload font 33*/
	pmpprt(0xd4);
	pmpprt(34);   /*unload font 33*/
	pmpprt(0xc7);
	/* load macro for activating font 33 */
	pmpprt(0xf7);
	pmpprt(28);
	pmpnum(2);
	pmpprt(0xd3);
	pmpprt(33);   /*activate font 33*/
	/* load macro for activating font 34 */
	pmpprt(0xf7);
	pmpprt(29);
	pmpnum(2);
	pmpprt(0xd3);
	pmpprt(34);   /*activate font 34*/
	/*load macro 33 for end of line cursor positioning*/
	pmpprt(0xf7);
	pmpprt(30);
	pmpnum(6);
	pmpprt(0xe2);
	pmpnum(-2*LPIXELS);
	pmpprt(0xe3);
	pmpnum(2);
	/* get set to load font 33*/
	pmpprt(0xd3);
	pmpprt(33);   /*activate font 33*/
	pmpfrc();

	for (i=0;i<256;i++) {     /*loop for each possible character*/
		pmpprt(0xf0);
		pmpprt(i);
		pmpprt(2);
		pmpprt(16);
		pmpprt(0);
		pmpprt(0);
		pmpprt(0);
		pmpprt(ph[i]^-1);
		pmpprt(pl[i]^-1);
		pmpprt(ph[i]^-1);
		pmpprt(pl[i]^-1);
		pmpfrc();
	}

#ifdef DEBUG
	fprintf(stderr,"Font 33 loaded.\n");
#endif DEBUG

	pmpprt(0xd3);
	pmpprt(34);   /*activate font 34*/
	pmpfrc();
	for (i=CH_WHITE;i<32+CH_WHITE;i++) {    
		/*loop for each white character*/
		bytes=2*(i-CH_WHITE+1);
		bits=bytes*8;
		pmpprt(0xf4);
		pmpprt(0);
		pmpprt(i);
		pmpnum(2);
		pmpnum(bits);
		pmpnum(0);
		pmpnum(0);
		pmpnum(0);
		pmpprt(0);
		pmpnum(2*bytes);
		for (j=0;j<2;j++) for (k=0;k<bytes;k++) pmpprt(0);
		pmpfrc();
	}
	/*define a all white scan line*/
	bytes=2*128;
	bits=bytes*8;
	pmpprt(0xf4);
	pmpprt(0);
	pmpprt(CH_ALLWHITE);
	pmpnum(2);
	pmpnum(bits);
	pmpnum(0);
	pmpnum(0);
	pmpnum(0);
	pmpprt(0);
	pmpnum(2*bytes);
	for (j=0;j<2;j++) for (k=0,pmpfrc();k<bytes;k++) pmpprt(0);
	pmpfrc();
#ifdef DEBUG
	fprintf(stderr,"White loaded.\n");
#endif DEBUG
	for (i=CH_BLACK;i<32+CH_BLACK;i++) {    
		/*loop for each black character*/
		bytes=2*(i-CH_BLACK+1);
		bits=bytes*8;
		pmpprt(0xf4);
		pmpprt(0);
		pmpprt(i);
		pmpnum(2);
		pmpnum(bits);
		pmpnum(0);
		pmpnum(0);
		pmpnum(0);
		pmpprt(0);
		pmpnum(2*bytes);
		for (j=0;j<2;j++) for (k=0;k<bytes;k++) pmpprt(255);
		pmpfrc();
	}
	/*define a all black scan line*/
	bytes=2*128;
	bits=bytes*8;
	pmpprt(0xf4);
	pmpprt(0);
	pmpprt(CH_ALLBLACK);
	pmpnum(2);
	pmpnum(bits);
	pmpnum(0);
	pmpnum(0);
	pmpnum(0);
	pmpprt(0);
	pmpnum(2*bytes);
	for (j=0;j<2;j++) for (k=0,pmpfrc();k<bytes;k++) pmpprt(255);
	pmpfrc();
#ifdef DEBUG
	fprintf(stderr,"Black loaded.\n");
#endif DEBUG
	for (i=CH_GREY0;i<32+CH_GREY0;i++) {    
		/*loop for each grey character*/
		bytes=2*(i-CH_GREY0+1);
		bits=bytes*8;
		pmpprt(0xf4);
		pmpprt(0);
		pmpprt(i);
		pmpnum(2);
		pmpnum(bits);
		pmpnum(0);
		pmpnum(0);
		pmpnum(0);
		pmpprt(0);
		pmpnum(2*bytes);
		for (j=0;j<2;j++) for (k=0;k<bytes/2;k++) {
			pmpprt(ph[0xaa]);
			pmpprt(pl[0xaa]);
		}
		pmpfrc();
	}
	/*define a all grey0 scan line*/
	bytes=2*128;
	bits=bytes*8;
	pmpprt(0xf4);
	pmpprt(0);
	pmpprt(CH_ALL0GREY);
	pmpnum(2);
	pmpnum(bits);
	pmpnum(0);
	pmpnum(0);
	pmpnum(0);
	pmpprt(0);
	pmpnum(2*bytes);
	for (j=0;j<2;j++) for (k=0,pmpfrc();k<bytes/2;k++) {
		pmpprt(ph[0xaa]);
		pmpprt(pl[0xaa]);
	}
	pmpfrc();
#ifdef DEBUG
	fprintf(stderr,"Grey0 loaded.\n");
#endif DEBUG
	for (i=CH_GREY1;i<32+CH_GREY1;i++) {    
		/*loop for each grey character*/
		bytes=2*(i-CH_GREY1+1);
		bits=bytes*8;
		pmpprt(0xf4);
		pmpprt(0);
		pmpprt(i);
		pmpnum(2);
		pmpnum(bits);
		pmpnum(0);
		pmpnum(0);
		pmpnum(0);
		pmpprt(0);
		pmpnum(2*bytes);
		for (j=0;j<2;j++) for (k=0;k<bytes/2;k++) {
			pmpprt(ph[0x55]);
			pmpprt(pl[0x55]);
		}
		pmpfrc();
	}
	/*define a all grey1 scan line*/
	bytes=2*128;
	bits=bytes*8;
	pmpprt(0xf4);
	pmpprt(0);
	pmpprt(CH_ALL1GREY);
	pmpnum(2);
	pmpnum(bits);
	pmpnum(0);
	pmpnum(0);
	pmpnum(0);
	pmpprt(0);
	pmpnum(2*bytes);
	for (j=0;j<2;j++) for (k=0,pmpfrc();k<bytes/2;k++) {
		pmpprt(ph[0x55]);
		pmpprt(pl[0x55]);
	}
	pmpfrc();
#ifdef DEBUG
	fprintf(stderr,"Grey 1 loaded.\n");
#endif DEBUG
	for (i=0;i<6;i++) {     /*loop for 6 possible lengths*/
		int bit=0x80^-1;
		int point;
		bytes=2*(i+1);
		bits=8*bytes;
		for (j=0;j<8;j++) {   /*loop for 8 possible bit positions*/
			point=CH_1WH+8*i+j;
			pmpprt(0xf0);
			pmpprt(point);
			pmpprt(2);
			pmpprt(bits);
			pmpprt(0);
			pmpprt(0);
			pmpprt(0);
			for (k=0;k<2;k++) {
				pmpprt(ph[bit&255]);
				pmpprt(pl[bit&255]);
				for (l=2;l<bytes;l++) pmpprt(255);
			}
			bit >>= 1;
		}
		pmpfrc();
	}
#ifdef DEBUG
	fprintf(stderr,"1White loaded.\n");
#endif DEBUG
	for (i=0;i<6;i++) {     /*loop for 6 possible lengths*/
		int bit=0x80;
		int point;
		bytes=2*(i+1);
		bits=8*bytes;
		for (j=0;j<8;j++) {   /*loop for 8 possible bit positions*/
			point=CH_1BL+8*i+j;
			pmpprt(0xf0);
			pmpprt(point);
			pmpprt(2);
			pmpprt(bits);
			pmpprt(0);
			pmpprt(0);
			pmpprt(0);
			for (k=0;k<2;k++) {
				pmpprt(ph[bit]);
				pmpprt(pl[bit]);
				for (l=2;l<bytes;l++) pmpprt(000);
			}
			bit >>= 1;
		}
		pmpfrc();
	}
#ifdef DEBUG
	fprintf(stderr,"1Black loaded.\n");
#endif DEBUG
	for (i=0;i<16;i++) { /*each possible image nibble*/
		pmpprt(0xf0);
		pmpprt(CH_IMAGE+i);
		pmpprt(2);
		pmpprt(8);
		pmpprt(0);
		pmpprt(0);
		pmpprt(0);
		pmpprt(pl[i]^-1);
		pmpprt(pl[i]^-1);
	}
	pmpfrc();
#ifdef DEBUG
	fprintf(stderr,"Image loaded.\n");
#endif DEBUG
#ifdef DEBUG
	fprintf(stderr,"Font build done.\n");
#endif DEBUG
	return(0);	/* to satisfy return code for Makefile */
}
pmpinit()
{
	pmpcnt=0;
}
pmpnum(n)
int n;
{
	pmpprt(n/256);
	pmpprt(n%256);
}
pmpprt(ch)
char ch;
{
	if (pmpcnt > 511 ) {
		fprintf(stderr,"pmp buffer overflow.\n");
		exit(1);
	}
	pmpbuf[pmpcnt++]=ch;
}
pmpfrc()
{
	int i;
#ifdef NOT_LPR
	redprt(0x1b);
	redprt(0x5b);
	redprt(0x43);  /*PMP escape sequence*/
	redprt(pmpcnt%256);
	redprt(pmpcnt/256);	   /*length */
#endif
	for (i=0;i<pmpcnt;redprt(pmpbuf[i++])) {
	};
	pmpcnt=0;
}
redprt(ch)
char ch;
{
	static wc=1000;
	write(reddev,&ch,1);
	if (wc-- <= 0) {
#ifdef DEBUG
		fprintf(stderr,"!");
#endif DEBUG
		wc=1000;
	}
}

prntptr(pa)
int *pa;
{
	fprintf(stderr,"ptr=%x %x\n",pa[0],pa[1]);
}

initptr(pa,off)
int *pa;
int off;
{
	pa[0]=off;
	pa[1]=0xa400;
}

