/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vtime.c 12.0$ */
/* $ACIS:vtime.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/aedtest/RCS/vtime.c,v $ */

#ifndef lint
static char *rcsid = "$Header:vtime.c 12.0$";
#endif

/* vtime.c */
#include "vikst.h"

#include <sys/time.h>

#define SEC 0xf0008800
#define MIN 0xf0008802
#define HRS 0xf0008804
#define DAY 0xf0008806
#define RGA 0xf000880a
#define RGB 0xf000880b
#define BIN 4
#define C24 2 /* binary=4; 24-hr=2 */

#ifdef BSD
extern FILE *out,*spool;
extern INT32 ledstatus;
extern int v_control;
#endif

extern INT16 iteration;

uip() /* update in progress? */
{
	char status;
	status = *(char *) RGA;
	if (status < 0) 
		return(1);
	else
		return(0);
}

unsigned char bbcd(in)
	unsigned char in;
{
	unsigned char high;
	high = (in >> 4) * 10;
	return((in & 0xf) + high);
}

static char hsecs, hmins, hhrs, hday;
static char tsecs, tmins, thrs, tday;
static tfirst=1;

#ifndef BSD /* that is, running stand-alone */
gettime()
{
	char mode,valid,anoon;

	anoon = 0;
	while (uip()) delay(BUSWAIT);
	mode = *(char *) RGB;  /* get mode */
	tsecs = *(char *) SEC;
	tmins = *(char *) MIN;
	thrs = *(char *) HRS;
	tday = *(char *) DAY;

	if (!mode & (C24))
		{
		anoon = 1;
		thrs &=  0x7f;
		}
	if (!(mode & BIN))
		{
		tsecs = bbcd(tsecs);
		tmins = bbcd(tmins);
		thrs = bbcd(thrs);
		tday = bbcd(tday);
		}
	if (anoon) thrs += 12;
}
#else
 /* #include <sys/time.h> */
gettime()
{
   struct timeval tp;
   struct timezone tzp;
   long epochsecs;

   gettimeofday(&tp,&tzp);
   epochsecs = tp.tv_sec;
   tsecs = (char) (epochsecs % 60);
}
#endif

/* static */ INT16 seconds0,seconds1,secondsd;

dumptime()
{
	p4d("iteration=%d seconds0=%d seconds1=%d\n",iteration,seconds0,seconds1);
}

INT16 starttime()
/* initialize the above three static variables, tfirst, and tsecs */
{
	do
		{
		seconds0=seconds1=secondsd=0;
		tfirst = 1;
		tsecs = -1;

		while ((tsecs<0) || (tsecs>59)) gettime();
		tfirst=0;
		hsecs=tsecs;

		/* return the static variable's value */
		seconds0 = hsecs;
		}
	while (seconds0 == 59); /* this value leads to a timeout */
	return(secondsd);
}

	
INT16 elapsedtime()
{
#ifdef BSD
	ioctl(v_control,AED_LEDS,&ledstatus);
#endif
	gettime();
	if ((tsecs>=0) && (tsecs<60))
		{
		/* update the static variable if new time is valid */
		hsecs=tsecs;
		}
	/* use the static variable's value */
	seconds1 = hsecs;
	secondsd = seconds1-seconds0;
	if (seconds1 < seconds0) /* minute wrap */
		secondsd += 60;
	return(secondsd);
}

realtime(hours,minutes,seconds,hundreths)
INT16 *hours,*minutes,*seconds,*hundreths;
{
	gettime();
	if (tfirst)
		{
		while ((tsecs<0) || (tsecs>59)) gettime();
		tfirst=0;
		hsecs=tsecs;
		hmins=tmins;
		hhrs=thrs;
		hday = tday;
		}
	else if ((tsecs>=0) && (tsecs<60))
		{
		hsecs=tsecs;
		hmins=tmins;
		hhrs=thrs;
		hday = tday;
		}

	*hundreths = 0;
	*seconds = hsecs;
	*minutes = hmins;
	*hours = hhrs;
}

wseconds(howlong)
INT16 howlong;
{ 
	INT16 time;
 	/* debug PRINTF("wait: howlong=%8lx %d\n",howlong,howlong); */
	if ((howlong<1) || (howlong > 59))
		return;
	starttime();
#if(0)
	time = 0;
	do
	{
	time = elapsedtime();
/* 	PRINTF("time=%d howlong=%d\n",time,howlong); */
	}
  	while( time < howlong );
#else
	while (elapsedtime() < howlong);
#endif
}
