/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:diskpart.c 12.0$ */
/* $ACIS:diskpart.c 12.0$ */
/* $Source: /ibm/acis/usr/src/etc/RCS/diskpart.c,v $ */

#ifndef lint
static char *rcsid = "$Header:diskpart.c 12.0$";
#endif

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "@(#)diskpart.c	5.5 (Berkeley) 5/30/86";
#endif not lint

/*
 * Program to calculate standard disk partition sizes.
 */
#include <sys/param.h>

#include <stdio.h>
#include <disktab.h>
#ifdef ibm032
#include <machineio/hdconfig.h>
#endif

#define	NPARTITIONS	8
#define	PART(x)		(x - 'a')

/*
 * Default partition sizes, where they exist.
 */
#define	NDEFAULTS	4
int	defpart[NDEFAULTS][NPARTITIONS] = {
   { 15884, 66880, 0, 15884, 307200, 0, 0, 291346 },	/* ~ 356+ Mbytes */
   { 15884, 33440, 0, 15884, 55936, 0, 0, 291346 },	/* ~ 206-355 Mbytes */
   { 15884, 33440, 0, 15884, 55936, 0, 0, 0 },		/* ~ 61-205 Mbytes */
   { 15884, 10032, 0, 15884, 0, 0, 0, 0 },		/* ~ 20-60 Mbytes */
};

/*
 * Each array defines a layout for a disk;
 * that is, the collection of partitions totally
 * covers the physical space on a disk.
 */
#define	NLAYOUTS	3
char	layouts[NLAYOUTS][NPARTITIONS] = {
   { 'a', 'b', 'h', 'g' },
   { 'a', 'b', 'h', 'd', 'e', 'f' },
   { 'c' },
};

/*
 * Default disk block and disk block fragment
 * sizes for each file system.  Those file systems
 * with zero block and frag sizes are special cases
 * (e.g. swap areas or for access to the entire device).
 */
struct	defparam {
	int	p_bsize;	/* block size */
	int	p_fsize;	/* frag size */
} defparam[NPARTITIONS] = {
	{ 8192, 1024 },		/* a */
	{ 8192, 1024 },		/* b */
	{ 8192, 1024 },		/* c */
	{ 4096, 512 },		/* d */
	{ 8192, 1024 },		/* e */
	{ 8192, 1024 },		/* f */
	{ 8192, 1024 },		/* g */
	{ 8192, 1024 }		/* h */
};

#ifdef ibm032
/*
 * Each disk has some space reserved for a bad sector
 * forwarding table and the CE cylinder. There are 1000 blocks reserved
 * for bad sectors (disks space must be getting cheaper) and the last one
 * for CE use.
 */
int	badsecttable;		/* # sectors to leave at end of disk */
#else
/*
 * Each disk has some space reserved for a bad sector
 * forwarding table.  DEC standard 144 uses the first
 * 5 even numbered sectors in the last track of the
 * last cylinder for replicated storage of the bad sector
 * table; another 126 sectors past this is needed as a
 * pool of replacement sectors.
 */
int	badsecttable = 126;	/* # sectors */
#endif

int	pflag;			/* print device driver partition tables */
int	dflag;			/* print disktab entry */

struct	disktab *promptfordisk();

char	*progname;


main(argc, argv)
	int argc;
	char *argv[];
{
	struct disktab *dp;
	register int curcyl, spc, def, part, layout;
	int threshhold, numcyls[NPARTITIONS], startcyl[NPARTITIONS];
	char *lp;

	progname = argv[0];
	argc--, argv++;
	if (argc < 1) {
		fprintf(stderr, "usage: %s [ -p ] [ -d ] disk-type\n",progname);
		exit(1);
	}
	if (argc > 0 && strcmp(*argv, "-p") == 0) {
		pflag++;
		argc--, argv++;
	}
	if (argc > 0 && strcmp(*argv, "-d") == 0) {
		dflag++;
		argc--, argv++;
	}
	dp = getdiskbyname(*argv);
	if (dp == NULL) {
		if (isatty(0))
			dp = promptfordisk(*argv);
		if (dp == NULL) {
			fprintf(stderr, "%s: unknown disk type\n", *argv);
			exit(2);
		}
	}
	spc = dp->d_nsectors * dp->d_ntracks;
#ifdef ibm032
	/*
	 * Space is left at the end of the disk for the bad sector
	 * replacement blocks (1000 blocks) and the CE test cylinder
	 * The amount of space reserved is badsecttable rounded up to
	 * the next cylinder 
	 */
	badsecttable = spc + MAXBADBLKS;
	badsecttable = roundup(badsecttable, spc);
#else
	/*
	 * Bad sector table contains one track for the replicated
	 * copies of the table and enough full tracks preceding
	 * the last track to hold the pool of free blocks to which
	 * bad sectors are mapped.
	 */
	badsecttable = dp->d_nsectors + roundup(badsecttable, dp->d_nsectors);
#endif
	threshhold = howmany(spc, badsecttable);
#ifndef ibm032	/* we don't support bad144, and always have badsecttable */
	if (dp->d_badsectforw == 0) {
		badsecttable = 0;
		threshhold = 0;
	}
#endif

	/* 
	 * Figure out if disk is large enough for
	 * expanded swap area and 'd', 'e', and 'f'
	 * partitions.  Otherwise, use smaller defaults
	 * based on RK07.
	 */
	for (def = 0; def < NDEFAULTS; def++) {
#ifdef ibm032
		curcyl = 1;
#else
		curcyl = 0;
#endif
		for (part = PART('a'); part < NPARTITIONS; part++)
			curcyl += howmany(defpart[def][part], spc);
		if (curcyl < dp->d_ncylinders - threshhold)
			break;
	}
	if (def >= NDEFAULTS) {
		fprintf(stderr, "%s: disk too small, calculate by hand\n",
			*argv);
		exit(3);
	}

	/*
	 * Calculate number of cylinders allocated to each disk
	 * partition.  We may waste a bit of space here, but it's
	 * in the interest of compatibility (for mixed disk systems).
	 */
#ifdef ibm032
	/* we start at cylinder 1 since 0 is used for other things */
	for (curcyl = 1, part = PART('a'); part < NPARTITIONS; part++) {
#else
	for (curcyl = 0, part = PART('a'); part < NPARTITIONS; part++) {
#endif
		numcyls[part] = 0;
		if (defpart[def][part] != 0) {
			numcyls[part] = howmany(defpart[def][part], spc);
			curcyl += numcyls[part];
		}
	}
	numcyls[PART('f')] = dp->d_ncylinders - curcyl;
	numcyls[PART('g')] =
		numcyls[PART('d')] + numcyls[PART('e')] + numcyls[PART('f')];
	numcyls[PART('c')] = dp->d_ncylinders;
	defpart[def][PART('f')] = numcyls[PART('f')] * spc - badsecttable;
	defpart[def][PART('g')] = numcyls[PART('g')] * spc - badsecttable;
	defpart[def][PART('c')] = numcyls[PART('c')] * spc;
	if (!pflag)
		defpart[def][PART('c')] -= badsecttable;

	/*
	 * Calculate starting cylinder number for each partition.
	 * Note the 'h' partition is physically located before the
	 * 'g' or 'd' partition.  This is reflected in the layout
	 * arrays defined above.
	 */
	for (layout = 0; layout < NLAYOUTS; layout++) {
#ifdef ibm032
		curcyl = 1;
#else
		curcyl = 0;
#endif
		for (lp = layouts[layout]; *lp != 0; lp++) {
			startcyl[PART(*lp)] = curcyl;
			curcyl += numcyls[PART(*lp)];
		}
	}
	/*
	 * force partition c to start at 0
	 */
	startcyl[PART('c')] = 0;

	if (pflag) {
		printf("}, %s_sizes[%d] = {\n", dp->d_name, NPARTITIONS);
		for (part = PART('a'); part < NPARTITIONS; part++) {
			if (numcyls[part] == 0) {
				printf("\t0,\t0,\n");
				continue;
			}
			if (dp->d_sectoffset == 0) {
			       printf("\t%d,\t%d,\t\t/* %c=cyl %d thru %d */\n",
					defpart[def][part], startcyl[part],
					'A' + part, startcyl[part],
#ifdef ibm032
					startcyl[part] + (defpart[def][part]+spc-1)/spc - 1);
#else
					startcyl[part] + numcyls[part] - 1);
#endif
				continue;
			}
			printf("\t%d,\t%d,\t\t/* %c=sectors %d thru %d */\n",
				defpart[def][part], spc * startcyl[part],
				'A' + part, spc * startcyl[part],
				spc * startcyl[part] + defpart[def][part] - 1);
		}
		exit(0);
	}
	if (dflag) {
		int nparts;

		/*
		 * In case the disk is in the ``in-between'' range
		 * where the 'g' partition is smaller than the 'h'
		 * partition, reverse the frag sizes so the /usr partition
		 * is always set up with a frag size larger than the
		 * user's partition.
		 */
		if (defpart[def][PART('g')] < defpart[def][PART('h')]) {
			int temp;

			temp = defparam[PART('h')].p_fsize;
			defparam[PART('h')].p_fsize =
				defparam[PART('g')].p_fsize;
			defparam[PART('g')].p_fsize = temp;
		}
		printf("%s:\\\n", dp->d_name);
		printf("\t:ty=%s:ns#%d:nt#%d:nc#%d:%s%s\\\n", dp->d_type,
			dp->d_nsectors, dp->d_ntracks, dp->d_ncylinders,
#ifdef ibm032
			"",
#else
			dp->d_badsectforw ? "sf:" : "",
#endif
			dp->d_sectoffset ? "so:" : "");
		for (nparts = 0, part = PART('a'); part < NPARTITIONS; part++)
			if (defpart[def][part] != 0)
				nparts++;
		for (part = PART('a'); part < NPARTITIONS; part++) {
			if (defpart[def][part] == 0)
				continue;
			printf("\t:p%c#%d:", 'a' + part, defpart[def][part]);
			if (defparam[part].p_bsize != 0) {
				printf("b%c#%d:f%c#%d:",
				  'a' + part, defparam[part].p_bsize,
				  'a' + part, defparam[part].p_fsize);
			}
			nparts--;
			printf("%s\n", nparts > 0 ? "\\" : "");
		}
		exit(0);
	}
	printf("%s: #sectors/track=%d, #tracks/cylinder=%d #cylinders=%d\n",
		dp->d_name, dp->d_nsectors, dp->d_ntracks, dp->d_ncylinders);
	printf("\n    Partition\t   Size\t   Range\n");
	for (part = PART('a'); part < NPARTITIONS; part++) {
		printf("\t%c\t", 'a' + part);
		if (numcyls[part] == 0) {
			printf(" unused\n");
			continue;
		}
		printf("%7d\t%4d - %d\n", defpart[def][part], startcyl[part],
#ifdef ibm032
			startcyl[part] + (defpart[def][part]+spc-1)/spc - 1);
#else
			startcyl[part] + numcyls[part] - 1);
#endif
	}
}

struct disktab disk;

struct	field {
	char	*f_name;
	char	*f_defaults;
	int	*f_location;
} fields[] = {
	{ "sector size",		"512",	&disk.d_secsize },
	{ "#sectors/track",		0,	&disk.d_nsectors },
	{ "#tracks/cylinder",		0,	&disk.d_ntracks },
	{ "#cylinders",			0,	&disk.d_ncylinders },
	{ "revolutions/minute",		"3600",	&disk.d_rpm },
	{ 0, 0, 0 },
};

struct disktab *
promptfordisk(name)
	char *name;
{
	register struct disktab *dp = &disk;
	register struct field *fp;
	static char type[BUFSIZ];
	char buf[BUFSIZ], *cp, *gets();

	dp->d_name = name;
	fprintf(stderr,
		"%s: unknown disk type, want to supply parameters (y/n)? ",
		name);
	(void) gets(buf);
	if (*buf != 'y')
		return ((struct disktab *)0);
gettype:
	fprintf(stderr, "type (winchester|removable|simulated)? ");
	(void) gets(type);
	if (strcmp(type, "winchester") && strcmp(type, "removable") &&
	    strcmp(type, "simulated")) {
		fprintf(stderr, "%s: bad disk type\n", type);
		goto gettype;
	}
	dp->d_type = type;
	fprintf(stderr, "(type <cr> to get default value, if only one)\n");
#ifndef ibm032
	fprintf(stderr, "Do %ss require sector or cylinder offsets (%s)? ",
		dp->d_name, "cylinder");
	(void) gets(buf);
	if (*buf == 's')
		dp->d_sectoffset = 1;
	else
#endif
		dp->d_sectoffset = 0;
#ifndef ibm032
	fprintf(stderr, "Do %ss support bad144 bad block forwarding (yes)? ",
		dp->d_name);
	(void) gets(buf);
	if (*buf != 'n')
#endif
		dp->d_badsectforw = 1;
#ifndef ibm032
	else
		dp->d_badsectforw = 0;
#endif
	for (fp = fields; fp->f_name != NULL; fp++) {
again:
		fprintf(stderr, "%s ", fp->f_name);
		if (fp->f_defaults != NULL)
			fprintf(stderr, "(%s)", fp->f_defaults);
		fprintf(stderr, "? ");
		cp = gets(buf);
		if (*cp == '\0') {
			if (fp->f_defaults == NULL) {
				fprintf(stderr, "no default value\n");
				goto again;
			}
			cp = fp->f_defaults;
		}
		*fp->f_location = atoi(cp);
		if (*fp->f_location == 0) {
			fprintf(stderr, "%s: bad value\n", cp);
			goto again;
		}
	}
	return (dp);
}
