/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:font3812.h 12.0$ */
/* $ACIS:font3812.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/h/RCS/font3812.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidfont3812 = "$Header:font3812.h 12.0$";
#endif

/*
 * font3812.h - C type defintions for processing font 3812 information
 */

#ifndef _FONT3812
#define _FONT3812

/*------------define fonts values that are constant in this program----*/
#define MaxCharSize 8192             /* this allows 1 inch square */
				     /* 240 * (240/8)             */
/*----Format for the .dat font files for 3812. ---------------------------*/
/*    This file contains the raster data for all the characters in the    */
/*    Font.  The .dat file contains some fixed length information for     */
/*    each character (char_info) followed by the variable length raster   */
/*    data for that character (r_data).                                   */
/*                                                                        */
/*-------------for fixed portion of the font information -----------------*/
typedef struct {
    short x;		/* width of bit pattern */
    short y;		/* height of bit pattern*/
    short a_space;	/* space before bits    */
    short c_space;	/* space following bits */
    short offset;	/* baseline offset      */
} char_info;
#define CharInfoLen (sizeof (char_info))

/*----------------per character info--------------------------------------*/
typedef struct {
    char_info c_data;
    char *r_data;	/* raster bit pattern   */
}  ibm_fdata;

/*-----Format for the .ndx file ------------------------------------------*/
/*     This file is an index into the font data by IBM character name.    */
/*     The .ndx file contains one index_data structure for each IBM       */
/*     character in the font.                                             */
/*                                                                        */
/*     Each 8 byte name corresponds to a IBM character name.              */
/*     The corresponding offset indicates the offset into the font data   */
/*         for that character.                                            */
/*     The corresponding length indicates the length of the font data.    */
typedef struct {
       char name[8];	/* IBM character name   */
       int offset;	/* offset into .dat file*/
       int length;	/* length for font data */
} index_data;
#define IndexDataLen (sizeof (index_data))

/*------Format for the code page index into font data --------------------*/
/*      An  offset file is build by width3812 for each font for a size */
/*      and a particular codepage table. They are named ff.s.cpage, where:  */
/*             ff    = the font family name                               */
/*             s     = the size                                */
/*             cpage = the name of the codepage.                          */
/*      for example:   ss.6.stdcp                                           */
/*     --------------------------------------------------------------     */
/*      The file has the following format:                                */
/*        total_chars   : integer */
/*        cp_index      : each entry is 8 bytes.  One entry for each      */
/*                        character listed in the copepage.               */

typedef struct {
    int offset;
    int length;
} cp_index;
#define cpIndexLen (sizeof (cp_index))

#endif	_FONT3812
