/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:printer3812.h 12.0$ */
/* $ACIS:printer3812.h 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/lpr/filters/RCS/printer3812.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidprinter3812 = "$Header:printer3812.h 12.0$";
#endif

/*
 * printer3812.h - C type definitions for processing error messages and
 * status messages from the IBM 3812 Pageprinter.
 */
#ifndef _MSG3812
#define _MSG3812

/*
 * Messages from Printer
 */
#define POWER_ON	0x14	/* Power on reset status	*/
#define PAGE_DONE	0x10	/* Page in exit tray		*/
#define INTERVENTION	0x11	/* Intervention required	*/
#define I_CLEARED	0x15	/* Intervention cleared		*/
#define COMMAND_ERR	0x12	/* Command exception status	*/
#define PRINTER_ERR	0x13	/* Printer Failure		*/
/* 
 * Intervention Required types:
 */
#define PAPER_JAM	0x01	/* paper jam			*/
#define TONER_LOW	0x02	/* Toner supply low		*/
#define EXIT_FULL	0x03	/* Exit tray full		*/
#define OUT_OF_PAPER	0x04	/* Paper supply empty		*/
#define STOP_KEY	0x05	/* Stop key depressed		*/
#define CANCEL_KEY	0x06	/* Cancel key depressed		*/
#define PMP_STOP	0x07	/* PMP STOP command		*/
#define COVER_OPEN	0x08	/* Cover open			*/
#define OFFSET_ERR	0x09	/* Job offset malfunction	*/
#define MEMORY_ERR	0x0A	/* Page Map memory error	*/
/*
 * Intervention Cleared types:
 */
#define CLR_PAPER_JAM	0x01	/* paper jam cleared		*/
#define CLR_TONER_LOW	0x02	/* Toner supply low cleared	*/
#define CLR_EXIT_FULL	0x03	/* Exit tray full cleared	*/
#define CLR_NO_PAPER	0x04	/* Paper supply replenished	*/
#define START_KEY	0x05	/* Start key depressed		*/
#define CLR_COVER_OPEN	0x08	/* Cover closed			*/
/*
 * Command exception status types:
 */
#define BAD_PMP_CMD	0x01	/* Invalid PMP command code	*/
#define BAD_PMP_PARAM	0x02	/* Invalid PMP parameter	*/
#define OUT_OF_PAGE_PAT	0x03	/* Pattern out of page		*/
#define OUT_OF_PAGE_VEC	0x04	/* Vector out of page		*/
#define OUT_OF_STORAGE	0x05	/* Insufficient storage		*/
#define UNDEFINED_LIB	0x06	/* Undefined libray file	*/
#define EXCEED_NEST_LIM	0x07	/* Macro nesting limit exceed	*/


static
char *irstatus[] = {	"Unknown",
			"Paper jam",
			"Toner supply is low",
			"Exit tray is full",
			"Out of paper",
			"Stop key was depressed",
			"Cancel key was depressed",
			"Printer stopped via PMP STOP command",
			"Cover open",
			"Job offset malfunction",
			"Page map memory error", 
	   	   };
#define IRSTATUS_CNT (sizeof irstatus/sizeof irstatus[0])

static
char *ircleared[] = {	"Invalid status",
			"Paper jam cleared",
			"Toner supply replenished",
			"Exit tray cleared",
			"Paper supply replenished",
			"Start key",
			"Invalid status(6)",
			"Invalid status(7)",
			"Cover closed",
		    };
#define IRCLEARED_CNT (sizeof ircleared/sizeof ircleared[0])

static
char *cmd_excp[] = {	"Invalid status",
			"Invalid PMP command code",
			"Invalid PMP command parameter",
			"Pattern out of page",
			"Vector out of page",
			"Insufficient printer storage",
			"Undefined Library File",
			"Macro nesting limit exceeded"
		   };
#define CMD_EXCP_CNT (sizeof cmd_excp/sizeof cmd_excp[0])
/*
 * The following structure (print_3812_flags) indicates what error 
 * the calling program wants to know about.  There is one
 * field (short) for each error 
 * message defined for the IBM 3812 Pageprinter.
 * If the field is 0, then ignore
 *		if 1, then return the message to filter.
 */ 
#define IBM3812_PMP_DATA 1
#define IBM3812_ASCII_DATA 2
#define IBM3812_IGNORE_ERR_MSG 0
#define IBM3812_RETURN_ERR_MSG 1

typedef struct {
    short type;
    short power_on;
    short page_done;
    short intervention[IRSTATUS_CNT];
    short i_cleared[IRCLEARED_CNT];
    short command_err[CMD_EXCP_CNT];
    short printer_err;
    long  sequence_id;
    char username[30];
    char hostname[30];
} print_3812_flags;

/*
 * This defines the size of the write buffers to the 3812
 */ 
#define IBM3812_BUFSIZ 1024
#endif	/* _MSG3812 */
