/* $Header:vi_copy.c 12.0$ */
/* $ACIS:vi_copy.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/vi_copy.c,v $ */

#ifndef lint
static char *rcsid = "$Header:vi_copy.c 12.0$";
#endif

#include "whim.h"
VI_Copy(sx,sy,tx,ty,wd,ht,merge)
  INT16 sx,sy;			     /* source top-left */
  INT16 tx,ty;			     /* target top-left */
  INT16 wd,ht;			     /* rectangle bounds */
  INT16 merge;			     /* merge mode */

  begin
#include "whimdcl.h"
    if (saving) { JOURNL(V_COPY);
		  JOURNL(sx);
		  JOURNL(sy);
		  JOURNL(tx);
		  JOURNL(ty);
		  JOURNL(wd);
		  JOURNL(ht);
		  JOURNL(merge); }

    /* force out any pending order streams */
    VI_Force();

    /* copy cannot handle rectangles that go out of bounds */
    if (sx < 0 || sy < 0 || (sx+wd-1) > 1023 || (sy+ht-1) > 799)
      return;

    if (tx < 0 || ty < 0 || (tx+wd-1) > 1023 || (ty+ht-1) > 799)
      return;

    /* build the copy command */
    vikint[1] = 3;	   /* copy command */
    vikint[2] = sx;	   /* source x */
    vikint[3] = sy;	   /* source y */
    vikint[4] = tx;	   /* target x */
    vikint[5] = ty;	   /* target y */
    vikint[6] = wd;	   /* width */
    vikint[7] = ht;	   /* height */
    vikint[8] = merge;	   /* merge */
    vikint[9] = 0;
    vikint[10] = 0;


    /* send command to Viking */
    command(10);
  end
