/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved. The Berkeley Software License Agreement
 * specifies the terms and conditions for redistribution.
 */
/* $Header:c_sqrt.c 12.0$ */
/* $ACIS:c_sqrt.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libF77/RCS/c_sqrt.c,v $ */

#ifndef lint
static char *rcsid = "$Header:c_sqrt.c 12.0$";
#endif

/* @(#)c_sqrt.c	5.1 - 86/12/09 - 09:04:38 */

#include "complex"

complex *
c_sqrt(r, z)
complex *r, *z;
{
double mag, sqrt(), cabs();

if( (mag = cabs(z->real, z->imag)) == 0.)
	r->real = r->imag = 0.;
else if(z->real > 0)
	{
	r->real = sqrt(0.5 * (mag + z->real) );
	r->imag = z->imag / r->real / 2;
	}
else
	{
	r->imag = sqrt(0.5 * (mag - z->real) );
	if(z->imag < 0)
		r->imag = - r->imag;
	r->real = z->imag / r->imag /2;
	}
return(r);
}
