/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:install.c 12.0$ */
/* $ACIS:install.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/install.c,v $ */

#ifndef lint
static char *rcsid = "$Header:install.c 12.0$";
#endif

#include "err.h"

/*
 * program to write out installation bitmap
 * so that zero blocks don't have to be written.
 * usage:
 * writeinstall input output
 */

#undef BSIZE
#undef BUFFSIZE

#define BSIZE 512
#define BUFFSIZE (512*8)

main(argc,argv)
char **argv;
{

#ifdef ATR
	int offset = 800;
#else
	int offset = 400;
#endif
	int length = 4096 * BSIZE;
	int datacount;		/* number of data blocks written */

	int bitcnt=0;		/* byte index for bitcnt */
	int input, output;
	char outbuff[BUFFSIZE];
	char inbuff[BUFFSIZE];
	char *inptr = inbuff+BUFFSIZE, *endptr = inbuff+BUFFSIZE;

	int vflg=0;

	struct header {
	char name[8];		/* BITMAP\0\0 */
	int count;		/* number of blocks written */
	int datacount;		/* number of data blocks written */
	char filler[512 - 8 - 2 * sizeof (int)];
	} header = { "BITMAP", 0 };

	char *infile = "fd(0,0)";
	char *outfile = "hd(0,1)";
	char bitmap[BSIZE];
	int len;

	if (argc > 1)
		infile = argv[1];
	if (argc > 2)
		outfile = argv[2];
	if (argc > 3)
		offset = atoi(argv[3]);

	printf("\nInstallation of MINIROOT (from %s at offset %d)",infile,offset);
	printf(" to %s\n\n",outfile);
	printf("Insert installation MINIROOT diskette and hit enter: ");

	offset *= BSIZE;

	getchar();

	if ((input = open(infile,0)) < 0)
		err("can't open %s for input",infile);
#ifdef STANDALONE
	if ((output = open(outfile,1)) < 0)
#else
	if ((output = creat(outfile,0666)) < 0)
#endif
		err("can't open %s for output",outfile);

	lseek(input, offset, 0);

	if (read(input, &header, sizeof header) != sizeof header)
		err("could not read header");

	if (strcmp(header.name, "BITMAP") != 0)
		err("bitmap not found");
	
	if (read(input, bitmap, sizeof bitmap) != sizeof bitmap)
		err("could not read bitmap");

	length = header.count * BSIZE * 8;
	datacount = header.datacount * BSIZE;
	if (datacount == 0)
		datacount = length;

	/* we are now positioned to read the actual data */

	printf("copying %d blocks from %s to %s\n", header.count * 8,
		infile, outfile);

	for (; length > 0; length -= len)
		{
		int map;
		int i;

		map = bitmap[bitcnt++];

		len = length > BUFFSIZE ? BUFFSIZE : length;
		
		for (i=0; i< len/BSIZE; ++i)
			{
			if (map & (0x80 >>i))
				{
				int l;
				if (vflg)
					printf("1");
				if (inptr >= endptr)
					{
					l = datacount > BUFFSIZE ? BUFFSIZE : datacount;
					if ((l = read(input, inbuff, l)) <= 0)
						err("read error");
					endptr = inbuff + l;
					inptr = inbuff;
					datacount -= l;
					}
				bcopy(inptr, outbuff+i*BSIZE, BSIZE);
				inptr += BSIZE;
				}
			else
				{
				if (vflg)
					printf("0");
				bzero(outbuff+i*BSIZE, BSIZE);
				}
			}
		write(output, outbuff, len);
		}
	printf("done\n");
}


#ifndef SAUTIL
#include "err.c"
#endif
