/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:dma.h 12.0$ */
/* $ACIS:dma.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/dma.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsiddma = "$Header:dma.h 12.0$";
#endif



/* The assignment of DMA channel request on the I/O bus doesn't correspond to
the actual DMA channel on the 8237 controller. The mapping is shown bellow.

  I/O bus channel         1st 8237    2nd 8237
       0                     2                       (8 bit)
       1                     1                       (8 bit)
       2                     0                       (8 bit)
       3                     3                       (8 bit)
       4                                 =           unsused
       5                                 1           (16 bit)
       6                                 2           (16 bit)
       7                                 3           (16 bit)

*/




/* DMA related registers */

#define  CRRB           0xF0008C60     /* component reset reg B    */
#define  DMRA           0xF00088E0     /* DMA mode reg. A          */
#define  DBRA           0xF00088C0     /* DMA buffering reg A      */

#define  CTL1_ENABLE          0x08     /*  8 bit controller        */
#define  CTL2_ENABLE          0x10     /* 16 bit controller        */


/*
Controller_1  registers  (channel 0-3)  8 bit

Current address register (16 bit)    R/W      CTL1_BASE + (2 * ch)
Current count register   (16 bit)    R/W      CTL1_BASE + (2 * ch) + 1
*/

#define CTL1_BASE       0xF0008840     /*    Controller 1 base register */
#define CTL1_CMD        0xF0008848     /* W  Command register           */
#define CTL1_STAT       0xF0008848     /* R  Status register            */
#define CTL1_REQ        0xF0008849     /* W  Request register           */
#define CTL1_SMASK      0xF000884A     /* W  Single bit mask register   */
#define CTL1_MODE       0xF000884B     /* W  Mode register              */
#define CTL1_FF         0xF000884C     /* W  Internal Flip-Flop         */
#define CTL1_TMP        0xF000884D     /* R  Temporary register         */
#define CTL1_CLR        0xF000884E     /* W  Clear mask  ???            */
#define CTL1_CLRA       0xF000884F     /* W  All mask register bits     */


/*
Controller_2  registers  (channel 5-7) 16 bit

Current address register (16 bit)    R/W      CTL2_BASE + (4 * ch)
Current count register   (16 bit)    R/W      CTL2_BASE + (4 * ch) + 2
*/

#define Ctl2_base       0xF0008860     /*    Controller 2 base register */
#define CTL2_CMD        0xF0008870     /* W  Command register           */
#define CTL2_STAT       0xF0008870     /* R  Status register            */
#define CTL2_REQ        0xF0008872     /* W  Request register           */
#define CTL2_SMASK      0xF0008874     /* W  Single bit mask register   */
#define CTL2_MODE       0xF0008876     /* W  Mode register              */
#define CTL2_FF         0xF0008878     /* W  Internal Flip-Flop         */
#define CTL2_TMP        0xF000887A     /* R  Temporary register         */
#define CTL2_CLR        0xF000887C     /* W  Clear mask  ???            */
#define CTL2_CLRA       0xF000887E     /* W  All mask register bits     */


/* dm_channel */

#define CHAN0   0
#define CHAN1   1
#define CHAN2   2
#define CHAN3   3
#define CHAN5   5
#define CHAN6   6
#define CHAN7   7
#define CHAN8   8

/* dm_operation  */

#define  DM_READ        0x8	       /* in the mode byte of the 8237 */
#define  DM_WRITE       0x4


/* dm_transfer   */

#define DM_DEMAND  0x0		       /* Demand transfer mode */
#define DM_SINGLE  0x40		       /* single mode transfer */
#define DM_BLOCK   0x80		       /* Block transfer mode  */
#define DM_CASCADE 0xC0		       /* Cascade mode         */

/* dm_party      */

#define DM_FIRST   1		       /* first party DMA      */
#define DM_THIRD   3		       /* third party DMA      */


struct dma_req {
	struct dma_req *forwrd;	       /* forward link       */
	/*           struct dma_req  *bckwrd;      /* backward link      */
	char *dm_bufaddr;	       /* buffer address     */
	int dm_length;		       /* buffer length      */
	int dm_channel;		       /* channel number     */
	int dm_operation;	       /* Read /write        */
	int dm_transfer;	       /* transfer type      */
	int dm_party;		       /* 1st / 3rd party    */
	int dm_error;		       /* returned error     */
	struct buf *bp;		       /* buffer             */
};

/* TCW control field ( bit 14-15 ) */
/* bit 15 */

#define  REAL_ACC              0       /* Real access       */
#define  VIRTUAL_ACC      0x8000       /* Virtual access    */

/* BIT 14 */

#define  RSC_ACC               0       /* RSC access        */
#define  IOB_ACC          0X4000       /* IO BUS access     */


#define TCW_BASE        0xF0010000     /* TCWs base address */



