/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#include "asm.h"
 # /* $Header:debugger.s 12.0$ */
 # /* $ACIS:debugger.s 12.0$ */
 # /* $Source: /ibm/acis/usr/sys/standca/RCS/debugger.s,v $ */

	.data
rcsid:	.asciz	"$Header:debugger.s 12.0$"
	.text

 #
 # assembler language interface to the debugger callable from
 # user level code
 #
 # we simulate an interrupt by storing iar, ics and cs
 # then doing a lps as if an interrupt had happened
 # note that the 'iar' is the return address (in gr15)
 #
	.set	vector	,	0x1a0		| fake interrupt vector
eye_profil(debugger):
	st	r15,vector(r0)	| return address
	mfs	scr_cs,r15	| get the cs
	sth	r15,vector+6(r0)	| and store it
	mfs	scr_ics,r15	| get the ics
	sth	r15,vector+4(r0)	| and store it
	l	r15,vector(r0)	| restore r15 for competeness
	lps	1,vector+8(r0)	| and transfer control to debugger
 # the debugger won't return to here - it will do a lps to return
 # to the simulated return point

 # 
 # interface code between the interrupt vectors and 
 # the trap routine. 
 # required for NCS 
 #
	.globl	_trapper
_trapper:
	CCALL(trap,0)
 # doesn't return to here
