/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:aedtty.c 12.0$ */
/* $ACIS:aedtty.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/aedtty.c,v $ */

#ifndef lint
static char *rcsid = "$Header:aedtty.c 12.0$";
#endif

#include "aed.h"
#if NAED > 0
#include "../machine/machparam.h"
#include "aedtty.h"
#include "../cacons/aed_tty_mcode.h"
#include "screen_conf.h"
#include "sa.h"

extern struct screen_sw screen_sw[];


aed_probe(rwaddr)
register char *rwaddr;
{
	short poll;
	int result;

	AED_ENTER(rwaddr=(char *));


	/* read control store to reset AED (Must be done for sensing) */
	aedrd(&poll, 1, 0X0000);
	AED_DELAY;

	/* Now do the normal screen probe routine */
	result = screen_probe(rwaddr);
	AED_EXIT();
	return(result);
}

int aed_in_init = 0;
aed_screen_init()
{
#ifndef AED_SET
	register int len;
	unsigned short aedcmd[10];
	short poll;		       /* semaphore word */

#endif AED_SET
	AED_ENTER();
	if (aed_in_init++) {
		screen_sw[CONS_AED].flags = 0;
		return(1);		/* for local aed things only */
	}

#ifndef AED_SET
	/* read control store to reset AED */
	aedrd(&poll, 1, 0X0000);
	AED_DELAY;

	/* copy microcode file into control store */
	aedwr(aed_tty_mcode, AEDTTY_MC_LEN / 2, 0x0000);
	AED_DELAY;

	/* send a null command to the AED to start and wait for ready */
	aedrd(&poll, 1, 0X0002);
	AED_DELAY;
	aed_tty_command(0, 0);

#endif AED_SET

	/* Initialize AED sram pointers */
	vinit();
	delay(5);
#ifndef BLACK_ON_WHITE
	vterm('\033');
	vterm('S');
#endif
	aed_in_init = 0;
	AED_EXIT();
	return(0);
}


aed_tty_command(buff, nwords)
	register char *buff;	       /* Buffer to give to AED */
	register short nwords;	       /* number of words to transfer */

{
	short poll;		       /* semaphore word */
	AED_ENTER();

	/* copy the AED buffer to shared ram */
	aedwr(buff, nwords, 0X4002);

	/* Wake up microcode */
	poll = 1;
	aedwr(&poll, 1, 0X4000);

	/* wait for completion */
	do {
		AED_DELAY;
		aedrd(&poll, 1, 0X4000);
	} while (poll != 0);
	AED_EXIT();

}


aed_screen_putc(c)
	register char c;
{
	AED_ENTER();
	vterm(c);
	AED_EXIT();
}


aed_put_status(pos,str)
	register int pos;
	register char *str;
{
	register int c;
	AED_ENTER();

	vterm('\033');		/* send out ESC */
	vterm('4');		/* 	     4  */
	vterm(pos+' ');		/* column position plus offset */

	do
		{
		c = *str++;
		vterm(c);
		}
	while (c);
	AED_EXIT();
}

/* print the aed screen */
static char dumpline[4] = {'\033', '8', 0, 0};
/* static */ char aedbuffer[128];

aed_screen_print(si, flag)
register /* SCREEN_INFO * */ si;
register int flag;
{
#define AED_LINES	52
#define AED_WIDTH	80	/* to get it started */
	register int l, i;
	register char *p;
	extern lpstatus;
	char *aedline();
	AED_ENTER();

	/* print out the aed screen buffer on the printer */

 	for (l = 0; l < AED_LINES; ++l) /* */
		{
		p = aedline(l);
		for (i = 0; i < AED_WIDTH; i++, p++) 
			{
			if (!*p) break;	/* quit at terminating null */
			if (lp_put(p[0])) 
				{
				hard_delay(250);
				goto done; /* quit if error */
				}
			}
		lp_put('\r');
		lp_put('\n');
		}
	lp_put('\f');		       /* skip to top of form */
done:
	put_status(33, "        ");
	lpstatus = -1;
	AED_EXIT();
}

char *aedline(line)
	register int line;
{
	char *s, c;
	dumpline[2] = ' ' + line;	/* blank plus line# offset */
	s = dumpline;
	while (c = *s++)
		vterm(c);		/* send dumpline request */
	vwait();			/* be sure dumpline is complete */
	aedrd(aedbuffer,AED_WIDTH/2,0X4100);
	 	/* for characters. Attribute array at 0x4180 */
	aedbuffer[AED_WIDTH] = '\0';	/* paranoia */
	return(aedbuffer);
}

#ifdef ATR
aed_rd(from, to, count)
short *from, *to;
int count;
{
	while (count-- > 0)
		*to++ = GET_PC2B(*from++);
}

aed_wr(from, to, count)
short *from, *to;
int count;
{
	while (count-- > 0)
		PUT_PC2B(*to++, *from++);
}
#endif ATR

#endif NAEDTTY
