/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:bootblock.c 12.0$ */
/* $ACIS:bootblock.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standatr/RCS/bootblock.c,v $ */

#ifndef lint
static char *rcsid = "$Header:bootblock.c 12.0$";
#endif

/*
 * dos block block
 */
#include "installboot.h"

#define BUILDSHORT(x)	LOBYTE(x),HIBYTE(x)

static char dbrec[] = {
	0xeb,0x34,0x90,				/* jump instruction */
	'I','B','M',' ',' ','3','.','3',	/* OEM */
	0x00,0x02,				/* block size (512) */
	0x00,					/* cluster size (changed by code) */
	0x01,0x00,				/* reserved */
	FAT_COUNT,				/* fat copies */
	BUILDSHORT(NUMBER_ENTRIES),		/* number dir entries */
	0x00,0x00,				/* size of device (changed by code) */
	LOBYTE(FAT_SIG1),			/* media descriptor */
	BUILDSHORT(FAT_SIZE/NBPS),		/* FAT size */
	0x00,0x00,				/* sectors (changed by code) */
	0x00,0x00,				/* tracks (changed by code) */
	0x00,0x00,				/* hidden (changed by code) */
	0x00,0x00,				/* start of boot program */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,
	0x00,0x00,0x00,0x00,0x01,0x00,0xfa,0x33,0xc0,0x8e,0xd0,0xbc,0x00,0x7c,0x16,0x07,
	0xbb,0x78,0x00,0x36,0xc5,0x37,0x1e,0x56,0x16,0x53,0xbf,0x2b,0x7c,0xb9,0x0b,0x00,
	0xfc,0xac,0x26,0x80,0x3d,0x00,0x74,0x03,0x26,0x8a,0x05,0xaa,0x8a,0xc4,0xe2,0xf1,
	0x06,0x1f,0x89,0x47,0x02,0xc7,0x07,0x2b,0x7c,0xfb,0xcd,0x13,0x72,0x67,0xa0,0x10,
	0x7c,0x98,0xf7,0x26,0x16,0x7c,0x03,0x06,0x1c,0x7c,0x03,0x06,0x0e,0x7c,0xa3,0x3f,
	0x7c,0xa3,0x37,0x7c,0xb8,0x20,0x00,0xf7,0x26,0x11,0x7c,0x8b,0x1e,0x0b,0x7c,0x03,
	0xc3,0x48,0xf7,0xf3,0x01,0x06,0x37,0x7c,0xbb,0x00,0x05,0xa1,0x3f,0x7c,0xe8,0x9f,
	0x00,0xb8,0x01,0x02,0xe8,0xb3,0x00,0x72,0x19,0x8b,0xfb,0xb9,0x0b,0x00,0xbe,0xd6,
	0x7d,0xf3,0xa6,0x75,0x0d,0x8d,0x7f,0x20,0xbe,0xe1,0x7d,0xb9,0x0b,0x00,0xf3,0xa6,
	0x74,0x18,0xbe,0x77,0x7d,0xe8,0x6a,0x00,0x32,0xe4,0xcd,0x16,0x5e,0x1f,0x8f,0x04,
	0x8f,0x44,0x02,0xcd,0x19,0xbe,0xc0,0x7d,0xeb,0xeb,0xa1,0x1c,0x05,0x33,0xd2,0xf7,
	0x36,0x0b,0x7c,0xfe,0xc0,0xa2,0x3c,0x7c,0xa1,0x37,0x7c,0xa3,0x3d,0x7c,0xbb,0x00,
	0x07,0xa1,0x37,0x7c,0xe8,0x49,0x00,0xa1,0x18,0x7c,0x2a,0x06,0x3b,0x7c,0x40,0x38,
	0x06,0x3c,0x7c,0x73,0x03,0xa0,0x3c,0x7c,0x50,0xe8,0x4e,0x00,0x58,0x72,0xc6,0x28,
	0x06,0x3c,0x7c,0x74,0x0c,0x01,0x06,0x37,0x7c,0xf7,0x26,0x0b,0x7c,0x03,0xd8,0xeb,
	0xd0,0x8a,0x2e,0x15,0x7c,0x8a,0x16,0xfd,0x7d,0x8b,0x1e,0x3d,0x7c,0xea,0x00,0x00,
	0x70,0x00,0xac,0x0a,0xc0,0x74,0x22,0xb4,0x0e,0xbb,0x07,0x00,0xcd,0x10,0xeb,0xf2,
	0x33,0xd2,0xf7,0x36,0x18,0x7c,0xfe,0xc2,0x88,0x16,0x3b,0x7c,0x33,0xd2,0xf7,0x36,
	0x1a,0x7c,0x88,0x16,0x2a,0x7c,0xa3,0x39,0x7c,0xc3,0xb4,0x02,0x8b,0x16,0x39,0x7c,
	0xb1,0x06,0xd2,0xe6,0x0a,0x36,0x3b,0x7c,0x8b,0xca,0x86,0xe9,0x8a,0x16,0xfd,0x7d,
	0x8a,0x36,0x2a,0x7c,0xcd,0x13,0xc3,0x0d,0x0a,0x4e,0x6f,0x6e,0x2d,0x53,0x79,0x73,
	0x74,0x65,0x6d,0x20,0x64,0x69,0x73,0x6b,0x20,0x6f,0x72,0x20,0x64,0x69,0x73,0x6b,
	0x20,0x65,0x72,0x72,0x6f,0x72,0x0d,0x0a,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,
	0x61,0x6e,0x64,0x20,0x73,0x74,0x72,0x69,0x6b,0x65,0x20,0x61,0x6e,0x79,0x20,0x6b,
	0x65,0x79,0x20,0x77,0x68,0x65,0x6e,0x20,0x72,0x65,0x61,0x64,0x79,0x0d,0x0a,0x00,
	0x0d,0x0a,0x44,0x69,0x73,0x6b,0x20,0x42,0x6f,0x6f,0x74,0x20,0x66,0x61,0x69,0x6c,
	0x75,0x72,0x65,0x0d,0x0a,0x00,0x49,0x42,0x4d,0x42,0x49,0x4f,0x20,0x20,0x43,0x4f,
	0x4d,0x49,0x42,0x4d,0x44,0x4f,0x53,0x20,0x20,0x43,0x4f,0x4d,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x55,0xaa
};

/* I gues I could have made dbrec dos_boot_rec & make it a global... */
struct dos_boot *dos_boot_rec = (struct dos_boot *)dbrec;
