/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pckbd.h 12.0$ */
/* $ACIS:pckbd.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/pckbd.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char    *rcsidpckbd = "$Header:pckbd.h 12.0$";
#endif

/* $Header:pckbd.h 12.0$ */
/* $ACIS:pckbd.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/pckbd.h,v $ */

#define DEBOUNCE        1



#define ESC_MARK	0x100
#define ALT_MARK	0x80
#define KBD_TIMEOUT	0x100
#define IID_MASK	0x07


int             getchar_timeout;/* used to provide 'default' input */
char            getchar_char;	/* the character to return */

#define KYB_CNTIW	0x64		/* Write Keyboard Ctrlr Cmd Byte */
#define KYB_CNTIR	0x64		/* Read Keyboard Ctrlr Cmd Byte  */
#define KYB_READ	0x60		/* Read data output port         */
#define KYB_WRITE	0x60		/* Write data output port (data) */

/*      AT interrupt mask register address                      */

#define AT_INT_MASK_ADDR 0x21


/*      Status Register Bit Definitions:                        */

#define KYB_OBF		0x01		/* Output Buffer Full - OK to Read */
#define KYB_IBF		0x02		/* Input Buffer Full - Controller  */
					/* has not read input         */
#define KYB_SYSFLAG	0x04		/* System Flag - Set by writing   */
					/* to Ctrlr Cmd Byte             */
#define KYB_CMDORDATA	0x08
					/* 1 = written to 0x64           */
#define KYB_INHIBIT	 0x10		/* 0 = Keyboard inhibited         */
#define KYB_XMIT_TIMEOUT 0x20		/* */
#define KYB_REC_TIMEOUT  0x40		/* */
#define KYB_PARITY	 0x80		/* 0 = last byte received from    */
 /* keyboard odd parity; 1 = even  */

/*      Keyboard Controller Commands:                                   */

#define CC_READ		0x20		/* Read Controller Command Byte */
#define CC_WRITE	0x60   		/*   Write Controller Command Byte */
#define CC_SELFTEST	0xaa		/* Start selftest: OK puts 55    */
					/* in output buffer             */
#define CC_IFTEST	0xab		/* Test keyboard clock and data  */
					/* bit-coded results            */
#define CC_DIAG_DUMP	0xac
#define CC_DISABLE_KYBD 0xad		/* Sets CT_DISABLE_KEYBD     */
#define CC_ENABLE_KYBD  0xae		/* Clears "                  */
#define CC_RD_INPORT	0xc0		/* Ctrlr reads input port, places */
					/* result in its output buffer.   */
					/* Used ONLY when output buffer   */
					/* is empty.                     */
#define CC_RD_OUTPORT	0xd0		/* Ctrlr reads its output port,   */
					/* places result in output buffer  */
#define CC_WR_OUTPORT	0xd1		/* Next byte written to 0x60            */
					/* placed in ctrlt output port.   */
					/* NOTE: nevr send bit 0 "low"    */


/*      define bits in Controller command byte here:                    */

#define CCB_OBFINT      0x01		/* 1 enables output-buffer-full */
					/* interrupt                   */
#define CCB_SYSFLAG     0x04		/* Places this bit in System        */
					/* flag bit of controller status */
					/* register                     */
#define CCB_INHIB_OVERRIDE 0x08		/* 1 disables kybd inhibit fctn  */
#define CCB_DISABLE_KYBD  0x10		/* 1 disables keyboard via clock */
					/* line low                     */
#define CCB_PCMODE	0x20		/* 1 sets kybd to support PC     */
					/* keyboard interface           */
#define CCB_PC_COMPAT	0x40		/* 1 converts scan codes to PC   */
#define CCB_RESERV	0x80		/* This bit ALWAYS 0!            */


/*      Keyboard Command Codes: Sent as data byte to KYB_WRITE             */


#define KBC_SCANSELECT	0xf0
#define KBC_MENU	0xf1
#define KBC_MAKE_BREAK	0xf4
#define KBC_RESET	0xff
#define KBC_RESEND	0xfe
#define KBC_SET_DEFAULT	0xf6
#define KBC_DEFAULT_DISABLE 0xf5
#define KBC_ENABLE	0xf4
#define KBC_TYPEMATIC	0xf3		/* Followed by 1 byte rate param  */
#define KBC_ECHO	0xee
#define KBC_LEDS	0xed		/* Second byte is LED mask:       */
#define KBC_SETALL_TMB	0xfa

/*      Keyboard Responses:  Read as data byte from KYB_READ                */

#define KBR_OK          0x00aa		/* Response from self-diagnostic  */
#define KBR_ACK         0xfa		/* Acknowledge from xmission         */
#define KBR_OVER_RUN    0xff		/* Overrun                            */
#define KBR_RESEND      0xfe		/* Resend Request             */
#define KBR_BREAK       0xf0		/* Keyboard BREAK code        */
#define KBR_FA          0x10		/* ACK Received    */
#define KBR_FE          0x20		/* RESEND Received         */
#define KBR_PR_LED      0x40		/* MODE indicator update  */


/* Keyboard leds */
#define       NUM_LED     0x02		/* Num lock led         */
#define       CAPS_LED    0x04		/* Caps lock led        */
#define       SCROLL_LED  0x01		/* Scroll lock led              */

/* Timer Addresses and Parameters       */
#define TIMER_2		0x042
#define TIMER_3		0x043
#define SPKR_PORT	0x061
#define SPKR_CONS1	0xb6
#define SPKR_CONS2	0x03
#define BEEP_FREQ	0x533
#define BEEP_TIME	0x50


#define CMD(cmd,data) cmd + (data <<8)	/* pack command and data */
#define TRACEF(x) if (atr_debug) printf x
