/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:mount.h 12.0$ */
/* $ACIS:mount.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/h/RCS/mount.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidmount = "$Header:mount.h 12.0$";
#endif

#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif

#ifndef VFS
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)mount.h	7.1 (Berkeley) 6/4/86
 */

/*
 * Mount structure.
 * One allocated on every mount.
 * Used to find the super block.
 */
struct	mount
{
	dev_t	m_dev;		/* device mounted */
	struct	buf *m_bufp;	/* pointer to superblock */
	struct	inode *m_inodp;	/* pointer to mounted on inode */
	struct	inode *m_qinod;	/* QUOTA: pointer to quota file */
#if (1) || defined(VICE)
	char	m_remote;	/* remote file system */
	char	m_mounted;	/* TRUE if this structure is in use */
	struct  inode *m_parent;/* The parent directory to the mounted on inode.  Bogus
				   method of handling chdir .. out of remote file system */
#endif
};
#ifdef KERNEL
struct	mount mount[NMOUNT];
#endif

#else !VFS

/* NFSSRC @(#)mount.h	2.1 86/04/11 */
/*	@(#)mount.h 1.1 86/02/03 SMI	*/

/*
 * mount options
 */
#define M_RDONLY	0x01		/* mount fs read only */
#define M_NOSUID	0x02		/* mount fs with setuid not allowed */

/*
 * File system types, these corespond to entries in fsconf
 */
#define	MOUNT_UFS	0
#define	MOUNT_NFS	1
#define	MOUNT_PC	2
#define MOUNT_AFS	3
#define MOUNT_DFS	4
#define	MOUNT_MAXTYPE	4

struct ufs_args {
	char	*fspec;
};

#ifdef NFS

struct nfs_args {
	struct sockaddr_in	*addr;		/* file server address */
	fhandle_t		*fh;		/* File handle to be mounted */
	int			flags;		/* flags */
	int			wsize;		/* write size in bytes */
	int			rsize;		/* read size in bytes */
	int			timeo;		/* initial timeout in .1 secs */
	int			retrans;	/* times to retry send */
	char			*hostname;	/* server's name */
};

/*
 * NFS mount option flags
 */
#define	NFSMNT_SOFT	0x001	/* soft mount (hard is default) */
#define	NFSMNT_WSIZE	0x002	/* set write size */
#define	NFSMNT_RSIZE	0x004	/* set read size */
#define	NFSMNT_TIMEO	0x008	/* set initial timeout */
#define	NFSMNT_RETRANS	0x010	/* set number of request retrys */
#define	NFSMNT_HOSTNAME	0x020	/* set hostname for error printf */
#define NFSMNT_INT	0x040	/* allow interrupts on hard mount */
#endif NFS

#ifdef AFS
struct afs_args {
	int			type;		/* flags */
};
#define AFS_MAIN	0
#endif AFS

#ifdef DFS
struct dfs_args {
	char	*fspec;
	u_long	mnt_flags;
	uid_t	def_uid;
	gid_t	def_gid;
};
#endif DFS

/*
 * sun's pc file system
 */
#ifdef PCFS
struct pc_args {
	char	*fspec;
};
#endif PCFS

#ifdef KERNEL
/*
 * mount filesystem type switch table
 */
extern struct vfsops *vfssw[];
#endif

#endif !VFS
