/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:asyreg.h 12.0$ */
/* $ACIS:asyreg.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/caio/RCS/asyreg.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidasyreg = "$Header:asyreg.h 12.0$";
#endif

/* Register Definitions */
struct asydevice {
	unsigned char txb;	/* Transmit Buffer */
#define rxb txb			/* Receive Buffer */
#define dllsb txb		/* Divisor Latch Least Significant Byte */
	unsigned char ier;	/* Interrupt Enable Register */
#define dlmsb ier		/* Divisor Latch Most Significant Byte */
	unsigned char iir;	/* Interrupt Id Register */
#define fcr iir 		/* FIFO Control Register */
	unsigned char lcr;	/* Line Control Register */
	unsigned char mcr;	/* Modem Control Register */
	unsigned char lsr;	/* Line Status Register */
	unsigned char msr;	/* Modem Status Register */
	unsigned char ppir;	/* Pending Port Interrupt Register */
				/* Only meaningful when read from port 0 */
};

/* Interrupt Enable Register bit definitions */
#define IER_DR		0x01	/* Enable Received Data Available interrupts (and FIFO timeout interrupts) */
#define IER_THRE	0x02	/* Enable Transmitter Holding Reg Empty ints */
#define IER_LSR		0x04	/* Enable Receive line status ints */
#define IER_MSR		0x08	/* Enable Modem Status interrupts */


/* Interrupt Identification register bit definitions */
#define IIR_PEND	0x01	/* This Bit is 0 when an interrupt is pending */
#define IIR_CTI		0x0c	/* Character timeout - FIFO mode only */
#define IIR_MASK	0x0F	/* Mask off just the meaningful bits in iir */
/* Interrupt types in oder of priority (high to low) */
#define IIR_LSR		0x06	/* Line Status (Some error condition) */
#define IIR_RXB		0x04	/* Received data available */
#define IIR_TXB		0x02	/* Transmitter Holding Register Empty */
#define IIR_MSR		0x00	/* Modem Status Change */
#define IIR_FIFO2       0x40	/* FIFO mode enabled */
#define IIR_FIFO1       0x80	/* FIFO mode enabled */

/* FIFO Control register bit definitions */
#define FCR_FCR7		0x80 	/* Trigger level */
#define FCR_FCR6     		0x40    /* Trigger level */
#define FCR_FCR3	       	0x08	/* RXRDY and TXRDY mode */
#define FCR_FCR2     		0x04 	/* Clear XMIT FIFO */
#define FCR_FCR1        	0x02	/* Clear RCVR FIFO */
#define FCR_FCR0        	0x01	/* Enable XMIT and RCVR FIFO */ 


/* Line Control Register bit defintions */
#define LCR_WLS		0x03	/* Word Length Select Mask */
#define LCR_5BIT	0x00	/* 5 data bits */
#define LCR_6BIT	0x01	/* 6 data bits */
#define LCR_7BIT	0x02	/* 7 data bits */
#define LCR_8BIT	0x03	/* 8 data bits */
#define LCR_STB		0x04	/* Select Number of Stop Bits */
#define LCR_PEN		0x08	/* Parity Enable */
#define LCR_EPS		0x10	/* Even Parity Select */
#define LCR_STP		0x20	/* Stick Parity */
#define LCR_SETB	0x40	/* Set Break */
#define LCR_DLAB	0x80	/* Divisor Latch Access Bit */

/* Modem Control Register bit definitions */
#define MCR_OFF		0x00	/* Drop line on modem */
#define MCR_DTR		0x01	/* Data Terminal Ready */
#define MCR_RTS		0x02	/* Request To Send */
#define MCR_IEN		0x08	/* Modem Int Enable (PC/AT aynch card only) */
#define MCR_LOOP	0x10	/* Loopback diagnostic */

/* Line Status Registers bit definitions */
#define LSR_DR		0x01	/* Data Ready */
#define LSR_OR		0x02	/* Overrun Error */
#define LSR_PE		0x04	/* Parity Error */
#define LSR_FE		0x08	/* Framing Error */
#define LSR_BI		0x10	/* Break Interrupt */
#define LSR_THRE	0x20	/* Transmitter Holding Register Empty */
#define LSR_TSRE	0x40	/* Tx Shift Register Empty */

/* Modem Status Register bit definitions */
#define MSR_DCTS	0x01	/* Delta Clear To Send */
#define MSR_DDSR	0x02	/* Delta Data Set Ready */
#define MSR_TERI	0x04	/* Trailing Edge Ring Indicator */
#define MSR_DDCD	0x08	/* Delta Data Carrier Detect (DRLSD) */
#define MSR_CTS		0x10	/* Clear To Send */
#define MSR_DSR		0x20	/* Data Set Ready */
#define MSR_RI		0x40	/* Ring Indicator */
#define MSR_DCD 	0x80	/* Data Carrier Detect (RLSD) */

/* Masks to determine which ports in the ppir have pending ints */
#define PORT_A	0x01		/* port 0 */
#define PORT_B	0x02		/* port 1 */
#define PORT_C	0x04		/* port 2 */
#define PORT_D	0x08		/* port 3 */

#define spl_asy()	_spl3()
