/*
 * P_R_P_Q_# (C) CSTYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PRSTERTY OF IBM
 * REFER TO CSTYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:st.c 12.0$ */
/* $ACIS:st.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/st.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char    *rcsid = "$Header:st.c 12.0$";
#endif

/* $Header:st.c 12.0$ */
/* $ACIS:st.c 12.0$ */

#include "st.h"
#if NST > 0
#include	"../h/param.h"
#include	"../h/vm.h"
#include	"../h/buf.h"
#include	"../h/time.h"
#include	"../h/proc.h"
#include	"../h/errno.h"
#include	"../machine/pte.h"
#include	"../machine/io.h"
#include	"../machineio/ioccvar.h"
#include	"../h/kernel.h"
#include	"../h/systm.h"
#include	"../h/cmap.h"
#include	"../h/dk.h"
#include	"../h/uio.h"
#include	"../h/ioctl.h"
#include 	"../h/file.h"
#include	"../ca_atr/pcif.h"
#include	"../pc_code/dio.h"
#include	"../machine/mmu.h"
#include	"../machine/debug.h"
#include 	"../machine/dkio.h"



caddr_t         real_buf_addr();

struct pc_dpl   st_dpl[NST];

#define	ST_SPL()	_spl3()	/* CPU level 3 */

#define UNIT_SHIFT	5
#define NPART	(1<<UNIT_SHIFT)
#define PART_MASK	(NPART-1)

#define	STUNIT(dev)	(minor(dev) >> UNIT_SHIFT)
#define STPART(dev)	(minor(dev) & PART_MASK)

#define	BSIZE	DEV_BSIZE
#define STBPS	DEV_BSIZE

#define PAGESIZE 2048
#define STTIMEOUT	30	/* number of seconds til interrupt known lost */
#define	STFORMREQ	0x0b	/* magic flgs for stformat */
 /* internal command flags */
#define	B_CTRL		0x80000000	/* ctrl request */
#define	B_CLOSE		0x81000000	/* close request */
#define	B_STATUS	0x82000000	/* get status request */
#define	B_OPEN		0x83000000	/* open request */
#define	B_RESET		0x84000000	/* reset request */

unsigned        stbusy;

#define b_cylin	b_resid

struct st_softc {
	int             timer;	/* timer for watchdog */
	u_short         type[NST];
}               sts;


struct buf      ropbuf[NST];	/* buffers for raw I/O */
struct buf      stutab[NST];	/* per drive buffers */

struct iocc_ctlr *stminfo[NSTC];
struct iocc_device *stdinfo[NST];

int 
stprobe(), stslave(), stattach(), stdgo(), stint();
int             stwstart, 
stwatch(), ststrategy();

int        stminphys();

int	stdebug = 0;

caddr_t         ststd[] = {
			   0
};

struct iocc_driver stcdriver = {
    stprobe, stslave, stattach, stdgo, ststd, "st", stdinfo, "stc", stminfo,
				stint, 0
};

char           *bioserrmsg();

#define STIRQ	12

/*
 * we have to handle the problem that both the block and character
 * device may be open, and only the final close should actually do
 * anything to the device. We do this by assuming that the block
 * and character device MAJOR number are different (which they normally
 * would be).
 */
int st_open_flag[NST * NPART];	/* bits to indicate if open */
int st_size[NST * NPART];	/* size (in blocks) */

stprobe()
{

	pcvec_map[STIRQ] = 1;

	st_dpl[0].op_code = DISKOP_RESET;
	st_dpl[0].drive = 0;

	if (pc_req(CB_TAPEREQ, &st_dpl[0], TAPEENT) < 0)
		return (PROBE_BAD);

	PROBE_DELAY(20000);

	return (PROBE_OK);

}


stslave(iod)
	register struct iocc_device *iod;
{
	register short  unit = iod->iod_unit;
	register u_char eq_byte = (u_char) (equip & 0x00ff);

	if (unit < NST)		/* there has to be drive 1 */
		return (1);	/* tell em it's there */

	return(0);
}


stattach(iod)
	register struct iocc_device *iod;
{
	static float    mspw =.0000016097;
	register struct buf *dp = &stutab[iod->iod_unit];

	if (stwstart == 0) {
		timeout(stwatch, (caddr_t) 0, hz);
		++stwstart;
	}
	dp->b_actf = NULL;
	dp->b_actl = NULL;
	dp->b_active = 0;
	sts.timer = 0;
	if (iod->iod_dk >= 0)
		dk_mspw[iod->iod_dk] = mspw;
	return (1);
}



stopen(dev, flags)
	dev_t           dev;
	int             flags;
{
	register int    unit = STUNIT(dev);
	register struct iocc_device *ui;

	DEBUGF(stdebug & SHOW_OPEN, printf("stopen dev=%x entered\n",dev));

	if (unit >= NST || (ui = stdinfo[unit]) == 0 || ui->iod_alive == 0)
		return (ENXIO);


	if (st_open_flag[minor(dev)] == 0) {
		if (stautodensity(dev, flags) < 0)
			return (EIO);	/* return error if no disk */
	}

	st_open_flag[minor(dev)] |= 1 << major(dev);	/* now open */

	DEBUGF(stdebug & SHOW_OPEN, printf("stopen exit\n"));
	return (0);
}


stautodensity(dev, flags)
	dev_t           dev;
	int             flags;
{
	register int    unit = STUNIT(dev);
	struct pc_dpl   dpl;
	int             return_code;

	DEBUGF(stdebug & SHOW_OPEN, printf("stautodensity dev=%x entered\n",dev));

	bzero(&dpl, sizeof(struct pc_dpl));

	dpl.op_code = DISKOP_OPEN;	/* open the drive */
	dpl.drive = minor(dev);
	dpl.number = (flags & FWRITE) != 0;

	if (flags == STFORMREQ)
		return (0);

	if ((return_code = st_op(&dpl)) < 0) {
		printf("st%d: door open or hardware fault.\n", unit);
		return (-1);
	}
#ifdef notdef
	if ((return_code & STWP) && (flags & FWRITE)) {
		printf("st%d: write protected\n", unit);
		return (-1);
	}
#endif
	DEBUGF(stdebug & SHOW_OPEN, printf("open done\n"));

	return (0);
}



stclose(dev, flag)
	dev_t           dev;
{
	register int    unit = STUNIT(dev);
	struct pc_dpl   dpl;
	int             return_code;

	st_open_flag[minor(dev)] &= ~(1 << major(dev));	/* now closed */

	bzero(&dpl, sizeof(struct pc_dpl));

	dpl.op_code = DISKOP_CLOSE;	/* close the drive */
	dpl.drive = minor(dev);
	dpl.number = (flag & FWRITE) != 0;

	if (flag == STFORMREQ)
		return (0);

	if (st_open_flag[minor(dev)] == 0) {	/* last close */
		if ((return_code = st_op(&dpl)) < 0) {
			printf("st%d: door open or hardware fault.\n", unit);
			return (-1);
		}
	}
	DEBUGF(stdebug & SHOW_OPEN, printf("stclose: dev=0x%x\n", dev));
	return (0);
}





stread(dev, uio)
	dev_t           dev;
	struct uio     *uio;
{
	int             unit = STUNIT(dev);
	DEBUGF(stdebug & SHOW_RDWR, printf("stread entered\n"));

	if ((uio->uio_offset < 0) || (unit >= NST))
		return (ENXIO);

	return (physio(ststrategy, &ropbuf[unit], dev, B_READ, stminphys, uio));
}


stwrite(dev, uio)
	dev_t           dev;
	struct uio     *uio;
{
	int             unit = STUNIT(dev);

	DEBUGF(stdebug & SHOW_RDWR, printf("stwrite entered\n"));

	if ((uio->uio_offset < 0) || (unit >= NST))
		return (ENXIO);

	return (physio(ststrategy, &ropbuf[unit], dev, B_WRITE, stminphys, uio));
}



ststrategy(bp)
	register struct buf *bp;
{

	register int    unit = STUNIT(bp->b_dev);
	register struct iocc_device *iod;
	register struct buf *dp;
	register int    s;

	DEBUGF(stdebug & SHOW_RDWR, printf("ststrategy: bp=%x dev=%x blkno=%d addr=%x\n", bp, bp->b_dev, bp->b_blkno, bp->b_un.b_addr));

	iod = stdinfo[unit];

	if ((unit >= NST) || (iod->iod_alive == 0) || (iod == 0) ||
	    (st_open_flag[minor(bp->b_dev)] == 0 && (bp->b_flags&B_CTRL) == 0)
	    || (bp->b_blkno < 0)) {
		bp->b_error = ENXIO;
		bp->b_flags |= B_ERROR;
		iodone(bp);
		return;
	}

	/* sort in order by unit number, then block */
	bp->b_cylin = bp->b_blkno  + (STPART(bp->b_dev) << 24);

	s = ST_SPL();
	dp = &stutab[unit];
	disksort(dp, bp);

	if (dp->b_active == 0) {
		(void) stustart(iod);
		bp = &iod->iod_mi->ic_tab;
		if (bp->b_actf && bp->b_active == 0)
			(void) ststart(iod->iod_mi);
	}
	splx(s);
}



stustart(iod)
	register struct iocc_device *iod;
{
	register struct buf *dp;
	register struct iocc_ctlr *ic;

	dp = &stutab[iod->iod_unit];
	ic = iod->iod_mi;

	dp->b_forw = NULL;
	if (ic->ic_tab.b_actf == NULL)
		ic->ic_tab.b_actf = dp;
	else
		ic->ic_tab.b_actl->b_forw = dp;
	ic->ic_tab.b_actl = dp;
	dp->b_active++;

	return (0);
}


/*
 *	Controller Startup Routine:
 *
 *
 */
ststart(ic)
	register struct iocc_ctlr *ic;
{
	register struct buf *bp, *dp;
	register struct iocc_device *iod;

loop:
	if ((dp = ic->ic_tab.b_actf) == NULL)
		return;
	if ((bp = dp->b_actf) == NULL) {
		ic->ic_tab.b_actf = dp->b_forw;
		goto loop;
	}
	ic->ic_tab.b_active++;	/* Mark controller active */

	iod = stdinfo[STUNIT(bp->b_dev)];

	stdgo(bp);
	if (iod->iod_dk >= 0) {
		dk_busy |= 1 << iod->iod_dk;
		dk_seek[iod->iod_dk]++;
		dk_xfer[iod->iod_dk]++;
		dk_wds[iod->iod_dk] += bp->b_bcount >> 6;
	}
	return (0);
}


/* 
 * This function sends the command out via a cbcb call
 */

stdgo(bp)
	register struct buf *bp;
{
	int             i, unit = STUNIT(bp->b_dev);
	u_short         head, sector, xfer_cnt, cnt;
	char           *vir_addr, *xfer_addr;

	if ((bp->b_bcount < 0) || (bp->b_bcount >= 0x10000)) {
		printf("st%d: bad bcount = %x\n", unit, bp->b_bcount);
		bp->b_error = ENXIO;
		bp->b_flags |= B_ERROR;
		iodone(bp);
		return;
	}
	while (stbusy) {
		delay(10);
		if (i++ > 100)
			panic("st: Non-sync request attempt.");
	}

	vir_addr = bp->b_un.b_addr;
	xfer_addr = real_buf_addr(bp, vir_addr);
	xfer_cnt = (u_short) bp->b_bcount;

	if (bp->b_flags & B_CTRL) {

		switch (bp->b_flags & 0xff000000) {

		case B_RESET:
			st_dpl[unit].op_code = DISKOP_RESET;
			break;

		case B_STATUS:
			st_dpl[unit].op_code = DISKOP_STATUS;
			break;

		case B_OPEN:
			st_dpl[unit].op_code = DISKOP_OPEN;
			break;

		case B_CLOSE:
			st_dpl[unit].op_code = DISKOP_CLOSE;
			break;

		default:
			printf("st%d: Invalid internal command\n", unit);
			return (-1);

		}

		st_dpl[unit].atr_addr[0] = (int) xfer_addr;
		st_dpl[unit].atr_cnt[0] = BSIZE;
		st_dpl[unit].atr_addr[1] = 0;
		st_dpl[unit].atr_cnt[1] = 0;
		goto doit;
	} else {
		if (bp->b_flags & B_READ)
			st_dpl[unit].op_code = DISKOP_READ;
		else
			st_dpl[unit].op_code = DISKOP_WRITE;
	}

	st_dpl[unit].atr_addr[0] = (int) xfer_addr;	/* set up 1st tcw */

	if ((cnt = (PAGESIZE - ((int) xfer_addr & 0x000007ff))) > xfer_cnt)
		st_dpl[unit].atr_cnt[0] = (u_short) xfer_cnt;
	else
		st_dpl[unit].atr_cnt[0] = (u_short) cnt;

	xfer_cnt -= st_dpl[unit].atr_cnt[0];	/* adjust the total count */
	vir_addr += st_dpl[unit].atr_cnt[0];	/* adjust the virtual addr */
	/* we're on a boundry now */
	for (i = 1; xfer_cnt > PAGESIZE; i++) {	/* while there's a count */
		xfer_addr = real_buf_addr(bp, vir_addr);	/* fill out tcw's */
		st_dpl[unit].atr_addr[i] = (int) xfer_addr;
		st_dpl[unit].atr_cnt[i] = PAGESIZE;
		vir_addr += PAGESIZE;
		xfer_cnt -= PAGESIZE;
	}

	if (xfer_cnt) {		/* if there is a partial page left, do it */
		xfer_addr = real_buf_addr(bp, vir_addr);
		st_dpl[unit].atr_addr[i] = (int) xfer_addr;
		st_dpl[unit].atr_cnt[i] = xfer_cnt;
		i++;
	}
	st_dpl[unit].atr_addr[i] = 0;	/* mark end of request */
	st_dpl[unit].atr_cnt[i] = 0;

	/* Then fill in the rest of the dpl and send it off */
doit:
	sector = (u_short) bp->b_blkno;		/* low-order block number */
	head = bp->b_blkno >> 16;		/* high-order block number */

	st_dpl[unit].drive = minor(bp->b_dev);	/* load up the dpl */
	st_dpl[unit].sector = (u_short) sector;
	st_dpl[unit].cyl = (u_short) bp->b_cylin;
	st_dpl[unit].head = (u_short) head;
	st_dpl[unit].number = (u_short) ((bp->b_bcount + BSIZE - 1) / BSIZE);

	stbusy++;

	if (pc_req(CB_TAPEREQ, &st_dpl[unit], TAPEENT) < 0) {
		printf("st%d: pc_req failed\n", unit);
		bp->b_error = EIO;
		bp->b_flags |= B_ERROR;
		iodone(bp);
		return;
	}
}


stint(ctlr)
	int             ctlr;
{
	register struct buf *bp, *dp;
	register struct iocc_ctlr *ic;
	struct iocc_device *iod;
	struct pc_stat *st_stat;
	register int    unit, old_window;

	ic = stminfo[ctlr];

	if (ic == 0 || ic->ic_tab.b_active == 0) {
		return (1);
	}
	dp = ic->ic_tab.b_actf;
	if (dp->b_active == 0) {
		return (1);
	}
	bp = dp->b_actf;
	unit = STUNIT(bp->b_dev);

	old_window = get_512_window();	/* Save the current window */
	set_512_window(cbcb_addr);	/* Address the cbcb        */
	st_stat = (struct pc_stat *) (cbcb->cbcb_ent[TAPEENT].pc_cb + pcif_512_fw);
	st_stat += minor(bp->b_dev);


	if (st_stat->return_code & BIOS_ERROR) {
		printf("st%d: BIOS error code = %x<%s>\n", unit,
		       (char) (st_stat->return_code & 0x00ff),
		       bioserrmsg((char) (st_stat->return_code & 0x00ff)));
		bp->b_flags |= B_ERROR;
	}
	stbusy = 0;		/* clear the busy flag */

	/*
	 * Flag current request complete 
	 */
	if (ic->ic_tab.b_active) {	/* For when we do error recovery */
		ic->ic_tab.b_active = 0;
		ic->ic_tab.b_errcnt = 0;
		ic->ic_tab.b_actf = dp->b_forw;	/* rotate to next drive */
		dp->b_active = 0;
		dp->b_errcnt = 0;
		dp->b_actf = bp->av_forw;
		bp->b_resid = bp->b_bcount - st_stat->pad;	/* amount not xfer'ed */
		iodone(bp);

		/*
		 * If more work to do on this drive, restart it. 
		 */
		iod = stdinfo[unit];
		if (iod->iod_dk >= 0)
			dk_busy &= ~(1 << iod->iod_dk);
		if (dp->b_actf)
			stustart(iod);
	}
	ststart(ic);

	sts.timer = 0;		/* did not timeout */

	set_512_window(old_window);

	return (0);
}


/*
 * watchdog timer - checks to see if we've lost an interrupt
 * by having the timer click 30 times without being cleared
 * (by interrupt routine)
 */

stwatch(reg)
	caddr_t         reg;
{
	register struct st_softc *st = &sts;
	register struct iocc_ctlr *ic;
	register int    s = ST_SPL();
	register int    i;
	register struct buf *dp, *bp;
	struct pc_stat *st_stat;
	register int    old_window;

	for (i = 0; i < NSTC; ++i) {
		if ((ic = stminfo[i]) == 0 || ic->ic_alive == 0 || ic->ic_tab.b_active == 0) {
			st->timer = 0;
			continue;	/* not doing anything */
		}
		if (++st->timer > STTIMEOUT) {
			if ((dp = ic->ic_tab.b_actf) == NULL || (bp = dp->b_actf) == NULL)
				continue;

			old_window = get_512_window();
			set_512_window(cbcb_addr);
			st_stat = (struct pc_stat *) (cbcb->cbcb_ent[TAPEENT].pc_cb + pcif_512_fw);
			st_stat += STUNIT(bp->b_dev);

			if (st_stat->return_code & (BIOS_ERROR | BIOS_RET_OK)) {
				set_512_window(old_window);
				st->timer = 0;
				printf("st%d: stint called from stwatch\n", STUNIT(bp->b_dev));
				stint(i);
			} else {
				stbusy = 0;	/* clear the busy flag */
				st->timer = 0;
				set_512_window(old_window);
				printf("st%d: lost interrupt\n", STUNIT(bp->b_dev));
				ststart(ic);	/* retry it */
			}
		}
	}
	timeout(stwatch, (caddr_t) 0, hz);
	splx(s);
}




/*
 * Interface for internally generated commands.
 */

st_op(dpl)
	register struct pc_dpl *dpl;
{
	register ushort unit = dpl->drive;
	struct buf     *bp = geteblk(BSIZE);
	struct pc_stat *st_stat;
	register int    old_window, return_code;

	switch (dpl->op_code) {

	case DISKOP_RESET:
		bp->b_flags = B_RESET;
		break;

	case DISKOP_STATUS:
		bp->b_flags = B_STATUS;
		break;

	case DISKOP_OPEN:
		bp->b_flags = B_OPEN;
		break;

	case DISKOP_CLOSE:
		bp->b_flags = B_CLOSE;
		break;

	default:
		printf("st%d: Invalid st_op command\n", unit);
		return (-1);
	}

	bp->b_dev = (dev_t) makedev(0,unit);
	bp->b_blkno = dpl->cyl;
	bp->b_bcount = dpl->number * BSIZE;

	ststrategy(bp);
	iowait(bp);

	old_window = get_512_window();	/* Save the current window */
	set_512_window(cbcb_addr);	/* Address the cbcb        */
	st_stat = (struct pc_stat *) (cbcb->cbcb_ent[TAPEENT].pc_cb + pcif_512_fw);
	st_stat += unit;
	return_code = st_stat->return_code;
	st_size[unit] = st_stat->badblock;	/* size (in blocks) */
	set_512_window(old_window);

	if (bp->b_flags & B_ERROR)
		return_code = -1;

	brelse(bp);

	return (return_code);

}


/*
 * Control routine:
 * processes two kinds of requests:
 *
 *	(1) Format the diskette according to the specified data parameter.
 *	(2) Report the density of the diskette in the indicated drive
 *	    (since the density it automatically determined by the driver,
 *	     this is the only way to let an application program know the
 *	     density)
 *
 */


stioctl(dev, cmd, data, flag)
	dev_t           dev;
	caddr_t         data;
{
	int             unit = STUNIT(dev);
	DEBUGF(stdebug & SHOW_OPEN, printf("stioctl entered\n");
	);

	switch (cmd) {

#ifdef STIOC_GDENS
	case STIOC_GDENS:	/* get density */

		*(int *) data = (int) sts.type[unit];
		return (0);
#endif

#ifdef STIOC_RESET
	case STIOC_RESET:	/* reset specified unit */

		return (streset(unit));
#endif

	case DKIOCGPART:{
			register struct dkpart *dk = (struct dkpart *) data;

			dk->dk_size = st_size[minor(dev)];	/* size */
			dk->dk_start = 0;	/* start */
			dk->dk_blocksize = STBPS;	/* device blocksize */
			dk->dk_ntrack = 1;	/* tracks/cylinder */
			dk->dk_nsector = 23;	/* sectors/track */
			dk->dk_ncyl = 0;	/* cylinders */
			strcpy(dk->dk_name, "worm");	/* copy name */
			return (0);
		}
	}
	return (ENOTTY);	/* sigh */
}


streset(unit)
	int             unit;
{
	struct pc_dpl   dpl;

	bzero(&dpl, sizeof(struct pc_dpl));

	dpl.op_code = DISKOP_RESET;	/* reset the drive */
	dpl.drive = (u_short) unit;

	if (st_op(&dpl) < 0)
		return (-1);

	return (0);
}



#define STMAXPHYS	(1024 * 60)	/* 60K maximum transfer for hd & st */
stminphys(bp)
	struct buf     *bp;
{

	if (bp->b_bcount > STMAXPHYS)
		bp->b_bcount = STMAXPHYS;
}



/*
 * return partition size (for swap partitions)
 */

stsize(dev)
	dev_t           dev;
{
	register int    unit = STUNIT(dev);
	register struct iocc_device *iod;

	if (unit >= NST || (iod = stdinfo[unit]) == 0 || iod->iod_alive == 0)
		return (-1);

	return (5*1024*2);		/* pretend we've got 5meg */
}


#endif NST
