/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:kls.h 12.0$ */
/* $ACIS:kls.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/kls.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char    *rcsidkls = "$Header:kls.h 12.0$";
#endif


#ifndef DEBUGF
#include "../machine/debug.h"
#endif


#define KLS_CNTIW 0x64		/* 8042 control port write */
#define KLS_CNTIR 0x64		/* 8042 control port read */
#define KLS_READ  0x60		/* keyboard data read */
#define KLS_WRITE 0x60		/* keyboard data write */
#define KLS_ACK   0xfa
#define IID_MASK  0x07		/* mask for Ident code */
#define KLS_ERROR 0x07
#define KLS_REQ   0x03
#define KLS_KBD   0x01
#define KLS_INFO  0x00
#define KLS_TIMEOUT	0x100	/* if we have timed out */
#define KLSMAXTIME  100000

#define	KBD_LOCKED	0x20	/* Keyboard lock bit		 */

/* Keyboard leds */
#define	      CAPS_LED    0x04	/* Caps lock led             */
#define	      NUM_LED     0x02	/* Num lock led            */
#define	      SCROLL_LED  0x01	/* Scroll lock led          */

/*
 * Status Register Bit Definitions 
 */
#define KLS_OBF		0x01	/* OBF (output buffer full?) */
#define KLS_IBF		0x02	/* IBF (input buffer full?) */
#define KLS_SYSFLAG	0x04	/* Set by writing to CTRLR CMD byte */
#define KLS_CMDORDATA	0x08	/* 0 if write to 0x60; 1 if to 0x64 */
#define KLS_INHIBIT	0x10	/* If 0, Keylock set	 */
#define KLS_XMIT_TMO    0x20	/* Xmit timeout	 */
#define KLS_REC_TMO	0x40	/* Receive timeout    */
#define KLS_PARITY	0x80	/* 0 = last kyb byte odd; 1 = even  */

/*
 * Keyboard Controller Commands
*/

#define CC_READ 0x20		/* Read Controller Command Byte */
#define CC_WRITE 0x60		/* Write Controller Command Byte */
#define CC_SELFTEST 0xaa	/* Start selftest: OK puts 55    */
 /* in output buffer		   */
#define CC_IFTEST 0xab		/* Test keyboard clock and data  */
 /* bit-coded results		   */
#define CC_DIAG_DUMP 0xac
#define CC_DISABLE_KYBD 0xad	/* Sets CT_DISABLE_KEYBD	   */
#define CC_ENABLE_KYBD  0xae	/* Clears     "                  */
#define CC_RD_INPORT 0xc0	/* Ctrlr reads input port, places */
 /* result in its output buffer.   */
 /* Used ONLY when output buffer   */
 /* is empty.			    */
#define CC_RD_OUTPORT 0xd0	/* Ctrlr reads its output port,   */
 /* places result in output buffer  */
#define CC_WR_OUTPORT 0xd1	/* Next byte written to 0x60	    */
 /* placed in ctrlt output port.   */
 /* NOTE: nevr send bit 0 "low"    */

/*	Bits in Controller command byte: 			*/

#define	CCB_OBFINT	0x01	/* 1 enables output-buffer-full */
 /* interrupt			  */
#define CCB_SYSFLAG	0x04	/* Places this bit in System    */
 /* flag bit of controller status */
 /* register			   */
#define CCB_INHIB_OVERRIDE 0x08	/* 1 disables kybd inhibit fctn  */
#define CCB_DISABLE_KYBD  0x10	/* 1 disables keyboard via clock */
 /* line low			   */
#define CCB_PCMODE 0x20		/* 1 sets kybd to support PC	   */
 /* keyboard interface		   */
#define CCB_PC_COMPAT 0x40	/* 1 converts scan codes to PC   */
#define CCB_RESERV 0x80		/* This bit ALWAYS 0!		   */


/*	Keyboard Command Codes: Sent as data byte to KYB_WRITE		   */


#define KBC_MENU 		0xf1
#define KBC_MAKE_BREAK 		0xf4
#define KBC_SETALL_TMB 		0xfa
#define KBC_SCANSELECT 		0xf0
#define KBC_RESET 		0xff
#define KBC_RESEND 		0xfe
#define KBC_SET_DEFAULT 	0xf6
#define KBC_DEFAULT_DISABLE 	0xf5
#define KBC_ENABLE 		0xf4
#define KSCAN 			0xf4
#define NKSCAN 			0xf5
#define KBC_TYPEMATIC 		0xf3	/* Followed by 1 byte rate param  */
#define KBC_ECHO		0xee
#define KBC_LEDS		0xed	/* Second byte is LED mask:       */
#define SETLED			0xed	/* Second byte is LED mask:       */


/*	Keyboard Responses:  Read as data byte from KYB_READ                */

#define KBR_OK          0xaa	/* Response from self-diagnostic  */
#define KBR_ACK         0xfa	/* Acknowledge from xmission	  */
#define KBR_ERROR	0x00	/* Key Detection or Overrun Error */
#define KBR_RESEND	0xfe	/* Resend Request		  */
#define KBR_BREAK	0xf0	/* Keyboard BREAK code		  */

/* Keyboard flags ?? WBW */
#define KBR_FA		0x10	/* ACK Received			 */
#define KBR_FE		0x20	/* RESEND Received		 */
#define KBR_PR_LED	0x40	/* MODE indicator update	 */

/* These defines will set a list of keys to the associated type */
#define	KSETMAKE	0xFD	/* Set key list to Make		 */
#define KSETMKBRK	0xFC	/* Set make/break		 */
#define KSETRPT		0xFB	/* Set repeat [make/break]	 */
#define KSETDBRPT	0xFA	/* Double rate repeat/make break */

/* These defines set all keys to the associated type */
#define	KALLMAKE	0xF9	/* Set all keys to Make		 */
#define	KALLMKBRK	0xF8	/* All to make/break		 */
#define KALLRPT		0xF7	/* All repeat [make/break]	 */
#define	KDEAFULT	0xF6	/* All keys to default type	 */
#define	KTOGMENU	0xF1	/* Toggle Keytype Menu		 */

/* Flags to tell set_default_key_types what you want */
#define STANDARD_MENU	0
#define ALT_MENU	1

#define HAVE_REPEAT_MKBRK ALT_MENU
#define	KEYCLICK_DEFDUR	0x36
#define	KEYCLICK_AUTO(n)	klscmd(EXTCMD,((n)? 0x2e :0x3e),0)

/* Define Advanced (RT) Keyboard scan code set selection parameter */
#define ENH_AT_SCANCODES 3

/* Timer Addresses and Parameters	*/
#define TIMER_2 0x042
#define TIMER_3 0x043
#define SPKR_PORT 0x061
#define SPKR_CONS1 0xb6
#define SPKR_CONS2 0x03
#define BEEP_FREQ_HIGH ((1190000/896) >> 8)
#define BEEP_FREQ_LOW ((1190000/896) & 0xff)
#define BEEP_TIME (((0x04*182)/1280)?((0x04*182)/1280):1)
#define CLICKVOL 2

/* AT interrupt mask register address	*/

#define AT_INT_MASK_ADDR 0x21


/* NOTE: Reverted to 'OLD' version of CMD:			 */
#define CMD(cmd,data) cmd + (data <<8)	/* pack data and command */

#define kls_read(queue)	getc(&queue)
#define kls_flush(queue) while (getc(&queue) >= 0)
#define KLSSPL()	_spl2()
#define KLS_RESERVED 0x05	/* Here only for compatibility. get rid of .. */
#define KLSINVRET	(KLS_RESERVED << 8)
#define KLS_SOFT_ERROR	(KLS_INFO << 8) + 0x7e
#define KLS_WAIT	1
#define KLS_NOWAIT	0
#define	KLSPOOLSZ	10
#define KLS_SOFT_ACK    0x77	/* 77 is arbitrary: picked to "show up"  well */

/*	Defines for making PC requests */
#define		KBCMD		0x60
#define		MSCMD		0x01
#define		SPKCMD		0x02

/* used in klsint - may need for keyboard too ? */
#define		MS_DATA		0
#define 	MS_CMDRESP	1

/* Command Reject codes */
#define	MS_BUSY_REJ	0x104	/* unsuccessful mouse cmd requiring a retry */

/*
 * We have added the qp_param field for the ATR version.
 */
struct klsq {
	struct klsq    *qp_next;/* pointer to next command on queue */
	char            qp_dest, qp_cmd;	/* destination and command to send */
	char            qp_param;	/* command parameter */
	int             (*qp_callback) ();	/* routine to call when completed */
	int             qp_ret;	/* return status of command */
};

#define klsfree(free,qp)	qp->qp_next = free ; free = qp

#define FAIL(n)	TRACEF(("return %d\n",n))

#define YES 1
#define NO 0

/*
 *  The following defines are used for mouse commands
 *  which are passed from Unix to PS/2 BIOS for execution.
 */
#define	MSCMD_SWITCH	0x00		/* Enable/disable mouse	command	*/
#define MS_ENABLE	0x01		/* Enable mouse	transmissions	*/
#define MS_DISABLE	0x00		/* Disable mouse transmissions	*/

#define	MSCMD_RESET	0x01		/* Reset mouse command		*/

#define MSCMD_SETRATE	0x02		/* Set mouse sampling rate cmd	*/	
					/* See SAMPLE RATE CHART in	*/
					/*  this file for parameters	*/

#define MSCMD_SETRES	0x03		/* Set mouse resolution	command	*/
					/* See SET RESOLUTION CHART in	*/
					/*  this file for parameters	*/

#define MSCMD_GETDEV	0x04		/* Get mouse device ID command	*/

#define MSCMD_SETDPS	0x05		/* Set mouse data package size	*/
#define MS_1BDPS	0x01		/* 1 byte data package size	*/
#define MS_2BDPS	0x02		/* 2 byte data package size	*/
#define MS_3BDPS	0x03		/* 3 byte data package size	*/
#define MS_4BDPS	0x04		/* 4 byte data package size	*/
#define MS_5BDPS	0x05		/* 5 byte data package size	*/
#define MS_6BDPS	0x06		/* 6 byte data package size	*/
#define MS_7BDPS	0x07		/* 7 byte data package size	*/
#define MS_8BDPS	0x08		/* 8 byte data package size	*/

#define MSCMD_EXTEND	0x06		/* Mouse extended commands	*/	
#define MS_QSTATUS	0x00		/* Query mouse status		*/
#define MS_1TO1		0x01		/* Set mouse scaling to 1:1	*/
#define MS_2TO1		0x02		/* Set mouse scaling to 2:1	*/

/* The following defines are for RT PC compatibility */
#define MSTRANS		MS_ENABLE
#define	MSDIS		MS_DISABLE
#define RSMOUSE		MSCMD_RESET
#define	MSSETSAM	MSCMD_SETRATE
#define	MSSETRES	MSCMD_SETRES
#define	MSRDCONF	MSCMD_GETDEV
#define QYMOUSE		MS_QSTATUS
#define	MSEXPOFF	MS_1TO1
#define	MSEXPON		MS_2TO1
