/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:if_unreg.h 12.0$ */
/* $ACIS:if_unreg.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/if_unreg.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char    *rcsidif_unbreg = "$Header:if_unreg.h 12.0$";
#endif

/*
 * Ungermann-Bass NIC/ps2 ethernet adapter .h file  (4.3 driver)
 */

#define ETH_ADDR_SIZE	6

struct ubdevice {
	char            ub_csr;	/* Control/status reg */
	char            ub_ca;	/* Channel Attention port */
	char            ub_tic;	/* Timer Interrupt Clear port */
	char            ub_pos5;/* A read from this port will return the
				 * contents of POS location 5 */
};

#define UB_RESET	0x01	/* reset the hardware */
#define UB_GSFTINT	0x20	/* Generate software interrupt */

/******************************************************************************/

/* 
 * These are the command codes for the Pegasus Card
 */

#define UB_INIT 	0x40	/* Initialize */
#define UB_XMT_FR	0x41	/* Transmit Frame */
#define UB_RCV		0x42	/* Receive */
#define UB_STAT		0x43	/* Status */
#define UB_CAN_RCV	0x44	/* Cancel Receives */
#define UB_GT_XMT_BFR	0x45	/* Get Transmit Buffer */
#define UB_WR_XMT_BFR	0x46	/* Write Transmit Buffer */
#define UB_SD_XMT_BFR	0x47	/* Send Transmit Buffer */
#define	UB_RL_XMT_BFR	0x48	/* Release Transmit Buffer */
#define UB_RD_FR_DT	0x49	/* Read Frame Data */
#define UB_NX_RCV_BFR	0x4A	/* Next Receive Buffer */
#define UB_FL_FR	0x4B	/* Flush Frame */

/*
 * These are the Result Codes for the Pegasus Card
 */

#define UB_XMT_LT_ERR		0x10	/* Data length to long or short */
#define UB_XMT_ADDR_ERR		0x11	/* Data starts at odd address */
#define UB_UNKN_CMD_ERR		0x12	/* Undefined command code in ZCB */
#define UB_UNIMPL_ERR		0x13	/* Unimplemented command code */
#define UB_XMT_COMP_SUC		0x14	/* Transmit successfully complete */
#define UB_XMT_COMP_ERR		0x15	/* Transmit completed with error */
#define UB_RCV_COMP_SUC		0x16	/* Frame received successfully */
#define UB_RCV_FR_TRUN_ERR	0x17	/* Receive buffer was to small */
#define UB_INIT_COMP		0x18	/* Initialization completed */
#define UB_STAT_COMP		0x19	/* Status completed */
#define UB_NT_YT_INIT		0x1A	/* Not Yet Initialized */
#define UB_ALR_INIT		0x1B	/* Already Initialized */
#define UB_CMD_CAN		0x1C	/* Command cancelled */
#define UB_CAN_COMP		0x1D	/* Cancel complete */
#define UB_XMT_BFR_ASS		0x1E	/* Transmit buffer assigned */
#define UB_XMT_BFR_NT_ASS	0x1F	/* Transmit buffer not assigned */
#define UB_XMT_BFR_RL		0x20	/* Transmit buffer released */
#define UB_XMT_BFR_WR		0x21	/* Transmit buffer written */
#define UB_MR_DT_AVAIL		0x22	/* More Data available */
#define UB_NO_MR_RCV_BFR	0x23	/* No more receive buffers */
#define UB_FR_ID_INV		0x24	/* Frame ID invalid */
#define UB_FL_COMP		0x25	/* Flush completed */
#define UB_FR_TBL_OVRFL		0x26	/* Frame table overflow */

#define MAX_PAC_LEN	2000

/*
 * System State Bits 
 */

#define UB_INITIALIZED		0x8000
#define UB_RDY_TO_RCV		0x1000


/*
 * Define the ZCB as a structure. But all the parts of the structure must
 * be characters because of the alignment problems between the ROMP and
 * the Intel proccessors.
 */

#define LOWBYTE(x)	(((int)x) & 0xff)
#define HIGHBYTE(x)	((((int)x) >>8) & 0xff)
#define FRTHBYTE(x)	(((int)x) & 0xff)
#define THRDBYTE(x)	((((int)x) >>8) & 0xff)
#define SCNDBYTE(x)	((((int)x) >>16) & 0xff)
#define FRSTBYTE(x)	((((int)x) >>24) & 0xff)
#define B2S(x,y,z)	(((int)x) = ((y) << 8) | (z))
/****************************************************************************/
/*
 * The following are the command blocks that are used with the Pegasus Card
 */

/*
 * Command Block Header -- Common to all commands
 */

typedef struct ZCB_HEADER {
	char            z_command;
	char            z_status;
	char            z_result;
	char            z_report_code;
	char            z_options_lb;
	char            z_options_ub;
	char            z_post_routine_4th;
	char            z_post_routine_3rd;
	char            z_post_routine_2nd;
	char            z_lost_routine_1st;
	char            z_link_4th;
	char            z_link_3rd;
	char            z_link_2nd;
	char            z_link_1st;
}               ZCB_HEADER;

/*
 * Transmit Command Block
 */

typedef struct XMT_ZCB {
	char            z_xmt_data_len_lb;
	char            z_xmt_data_len_ub;
	char            z_xmt_data_addr_4th;
	char            z_xmt_data_addr_3rd;
	char            z_xmt_data_addr_2nd;
	char            z_xmt_data_addr_1st;
	char            z_xmt_hdwr_stat_lb;
	char            z_xmt_hdwr_stat_ub;
	char            z_xmt_bfr_id_lb;
	char            z_xmt_bfr_id_ub;
	char            z_xmt_bfr_addr_4th;
	char            z_xmt_bfr_addr_3rd;
	char            z_xmt_bfr_addr_2nd;
	char            z_xmt_bfr_addr_1st;
}               XMT_ZCB;

/*
 * Receive Command Block
 */

typedef struct RCV_ZCB {
	char            z_rcv_mode;
	char            z_rcv_stat;
	char            z_bfr_size_lb;
	char            z_bfr_size_ub;
	char            z_rcv_bfr_addr_4th;
	char            z_rcv_bfr_addr_3rd;
	char            z_rcv_bfr_addr_2nd;
	char            z_rcv_bfr_addr_1st;
	char            z_rcv_data_len_lb;
	char            z_rcv_data_len_ub;
	char            z_rcv_frame_ct_lb;
	char            z_rcv_frame_ct_ub;
	char            z_rcv_hdwr_stat_lb;
	char            z_rcv_hdwr_stat_ub;
	char            z_rcv_frame_id_lb;
	char            z_rcv_frame_id_ub;
	char            z_rcv_bfr_ptr_4th;
	char            z_rcv_bfr_ptr_3rd;
	char            z_rcv_bfr_ptr_2nd;
	char            z_rcv_bfr_ptr_1st;
	char            z_rcv_bfr_ct_lb;
	char            z_rcv_bfr_ct_ub;
	char            z_rcv_descript_4th;
	char            z_rcv_descript_3rd;
	char            z_rcv_descript_2nd;
	char            z_rcv_descript_1st;
}               RCV_ZCB;

#define Rcv_Mode_Incremental	1

/*
 * Initialize Command Block
 */

typedef struct INIT_ZCB {
	char            z_init_mode_lb;
	char            z_init_mode_ub;
	char            z_max_xmt_len_lb;
	char            z_max_xmt_len_ub;
	char            z_num_xmt_bfrs_lb;
	char            z_num_xmt_bfrs_ub;
	char            z_max_rcv_size_lb;
	char            z_max_rcv_size_ub;
	char            z_num_rcv_bfrs_lb;
	char            z_num_rcv_bfrs_ub;
	char            z_hole1[16];
	char            z_acq_modes_lb;
	char            z_acq_modes_ub;
	char            z_acq_max_xmt_len_lb;
	char            z_acq_max_xmt_len_ub;
	char            z_acq_num_xmt_bfrs_lb;
	char            z_acq_num_xmt_bfrs_ub;
	char            z_acq_max_rcv_size_lb;
	char            z_acq_max_rcv_size_ub;
	char            z_acq_num_rcv_bfrs_lb;
	char            z_acq_num_rcv_bfrs_ub;
	char            z_hole2[8];
}               INIT_ZCB;

/*
 * Status Command Block
 */

typedef struct STAT_ZCB {
	char            z_stat_state_lb;
	char            z_stat_state_ub;
	char            z_stat_modes_lb;
	char            z_stat_modes_ub;
	char            z_stat_max_xmt_len_lb;
	char            z_stat_max_xmt_len_ub;
	char            z_stat_num_xmt_bfrs_lb;
	char            z_stat_num_xmt_bfrs_ub;
	char            z_stat_max_rcv_size_lb;
	char            z_stat_max_rcv_size_ub;
	char            z_stat_num_rcv_bfrs_lb;
	char            z_stat_num_rcv_bfrs_ub;
	char            z_stat_id[ETH_ADDR_SIZE];
	char            z_stat_total_xmts_4th;
	char            z_stat_total_xmts_3rd;
	char            z_stat_total_xmts_2nd;
	char            z_stat_total_xmts_1st;
	char            z_stat_total_rcv_4th;
	char            z_stat_total_rcv_3rd;
	char            z_stat_total_rcv_2nd;
	char            z_stat_total_rcv_1st;
	char            z_stat_crc_err_4th;
	char            z_stat_crc_err_3rd;
	char            z_stat_crc_err_2nd;
	char            z_stat_crc_err_1st;
	char            z_stat_aln_err_4th;
	char            z_stat_aln_err_3rd;
	char            z_stat_aln_err_2nd;
	char            z_stat_aln_err_1st;
	char            z_stat_rsc_err_4th;
	char            z_stat_rsc_err_3rd;
	char            z_stat_rsc_err_2nd;
	char            z_stat_rsc_err_1st;
	char            z_stat_ovr_err_4th;
	char            z_stat_ovr_err_3rd;
	char            z_stat_ovr_err_2nd;
	char            z_stat_ovr_err_1st;
	char            z_hole3[24];
}               STAT_ZCB;

typedef struct ZCB {
	ZCB_HEADER      header;
	union {
		INIT_ZCB        init_zcb;
		STAT_ZCB        stat_zcb;
		XMT_ZCB         xmt_zcb;
		RCV_ZCB         rcv_zcb;
	}               ZCB_BODY;
#define zcbi ZCB_BODY.init_zcb
#define zcbs ZCB_BODY.stat_zcb
#define zcbt ZCB_BODY.xmt_zcb
#define zcbr ZCB_BODY.rcv_zcb
}               ZCB;
