/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:packet.h 12.0$ */
/* $ACIS:packet.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/packet.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidpacket = "$Header:packet.h 12.0$";
#endif

struct  rq_packet {			/* REQUEST PACKET */
	u_short pktno;			/* Up to pktnochk must match data */
	u_short pktnochk;		/*   packet format		  */
	u_long  blkno;			/* Starting read/write position  */
					/*   for disk arm (block number) */
	u_short npkts;			/* Number of data packets to be    */
	u_char  flags;			/* Read/write flags */
	u_char  fs;			/* File system index */
}rqp;


/* defines for rqp.flags */

#define READ_RQ         0x01            /* Read Request */
#define WRITE_RQ        0x02            /* Write Request */


/* Packet size definitions */

#define PACKET_SIZE     128		/* Current packet size */
#define PACKET_SHIFT	7		/* Log2(PACKET_SIZE) */

/* Constants for rs232 protocol */

#define SEC		100		/* Number of timmer tics per second */
#define CHAR_TIME_OUT   (SEC * 1)     	/* 1 second */
#define PURGE_TIME_OUT  (SEC * 1)	/* 1 second */
#define ACK_TIME_OUT    (SEC * 8)      	/* 8 seconds */
#define SOH_TIME_OUT    (SEC * 4)      	/* 4 seconds */
#define PKT_TIME_OUT	(SEC * 3)      	/* 3 seconds */


#define TIME_OUT        -1
#define SOH             0x01
#define ACK             0x06
#define NAK             0x15
#define DUP             0x00
#define CAN             0x18
#define ESC             0x1b

#define RETRY_LIMIT	30
#define POLL_TIME	250

/* Maximum number of packets allowed in one I/O request */

#define MAXPKTNO	0xffff

/* Misc constants */

#define	ENABLE	1
#define	DISABLE	0
#define	TRUE	1
#define	FALSE	0
#define EOF	0
