/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:frame.h 12.0$ */
/* $ACIS:frame.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/frame.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidframe = "$Header:frame.h 12.0$";
#endif
/*	Converged linkage convention stack frame
	r0	At call, contains the address of the callee's data area
	r1	Stack pointer; on entry points to caller's frame bottom, our top
	r2..r5	First 4 words of incoming arguments; r2,r3 = result
	r6..r13	Register variables; preserved on entry
	r14	Local data pointer; copied from r0 on entry
	r15	Link register

	From the top downward, the stack frame contains:
	ARG_SAVE	Prolog may store first 4 words of argument list here
	LINK_SAVE	5 words
	REG_SAVE	Up to 16 words for saving general registers
	FREG_SAVE	Up to 8 words for saving fp registers 2-5
	VAR_AREA	not fixed
	PARAM_AREA	not fixed, enough space for max outgoing argument list

*/

/*	Area sizes	*/
#define	ARG_SAVE_SZ	16
#define	LINK_SAVE_SZ	20
#define	REG_SAVE_SZ	64
#define	FREG_SAVE_SZ	32
#define	FRM_PROTECT	(-ARG_SAVE_SZ-LINK_SAVE_SZ-REG_SAVE_SZ)
			/* == -100, must be protected by the kernel */

/*	Offsets from sp on entry	*/
#define	ARG1_OFFSET	-16
#define	ARG2_OFFSET	-12
#define	ARG3_OFFSET	-8
#define	ARG4_OFFSET	-4
#define ARG5_OFFSET	0
#define	LINK_OFFSET	(-ARG_SAVE_SZ-LINK_SAVE_SZ) /* -36  Base of Link Area */
#define	REG_OFFSET	(LINK_OFFSET - REG_SAVE_SZ) /* -100 Base of Reg Area */
/* #define FREG_OFFSET	(REG_OFFSET - FREG_SAVE_SZ)    -164 Base of FReg Area */
#define REG_ARGS	4
#ifdef KERNEL
#define D_NOFRAME 2	/* Should be defined from debug.h	*/
#define TTNOFRM .align 1; .byte 0xdf, D_NOFRAME, 0xdf, 0;
#define KERNFRAME -1*FRM_PROTECT
#endif KERNEL
