#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header:rvice.rg 12.0$ 
# $ACIS:rvice.rg 12.0$ 
# $Source: /ibm/acis/usr/sys/afsint/RCS/rvice.rg,v $ 

package RVice

%{
#include	"rvaux.h"
#include	"rvice.h"

#define NULL		0
%}

proc RViceConnectFS	VICECONNECTFS
param UserName string
param WorkStationName string
param VenusName string
call
code
#ifdef SERVERSTUB
/* we must free, on server side, the allocated strings, after the call */
    free(UserName);
    free(WorkStationName);
    free(VenusName);
#endif
endcode
endproc

proc RViceFetch		VICEFETCH
code
#ifdef SERVERSTUB
    AccessList.SeqBody = 0;
#endif
endcode
param Fid struct ViceFid *
param BidFid struct ViceFid *
param Request long
param Bulk struct BD *
param AccessList struct BBS *
call
code
#ifdef CLIENTSTUB
    if (!xdr_BBS(&z_pb->xdrs, AccessList)) goto fail;
#else
    if (!xdr_BBS(&z_pb->xdrs, &AccessList)) goto fail;
    free(AccessList.SeqBody);
#endif
endcode
param Status ViceStatus *
endcode
endproc

proc RViceFetchP		VICEFETCHP
code
#ifdef SERVERSTUB
    AccessList.SeqBody = 0;
    OptionalData.SeqBody = 0;
#endif
endcode
param Fid struct ViceFid *
param BidFid struct ViceFid *
param Request long
param Bulk struct BD *
param AccessList struct BBS *
param OptionalData struct BBS *
call
code
#ifdef CLIENTSTUB
    if (!xdr_BBS(&z_pb->xdrs, AccessList)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, OptionalData)) goto fail;
#else
    if (!xdr_BBS(&z_pb->xdrs, &AccessList)) goto fail;
    free(AccessList.SeqBody);
    if (!xdr_BBS(&z_pb->xdrs, &OptionalData)) goto fail;
    free(OptionalData.SeqBody);
#endif
endcode
param Status ViceStatus *
endcode
endproc

proc RViceStore	VICESTORE
code
#ifdef SERVERSTUB
    AccessList.SeqBody = 0;
#endif
endcode
param Fid struct ViceFid *
param Request long
param AccessList struct CBS *
param Bulk struct BD *
param Status struct ViceStatus *
param Length long
call
code
#ifdef CLIENTSTUB
    if (!xdr_ViceStatus(&z_pb->xdrs, Status)) goto fail;
#else
    if (!xdr_ViceStatus(&z_pb->xdrs, &Status)) goto fail;
    free(AccessList.SeqBody);
#endif
endcode
endproc

proc RViceStoreP	VICESTOREP
code
#ifdef SERVERSTUB
    AccessList.SeqBody = 0;
    OptionalData.SeqBody = 0;
#endif
endcode
param Fid struct ViceFid *
param Request long
param AccessList struct CBS *
param OptionalData struct BBS *
param Bulk struct BD *
param Status struct ViceStatus *
param Length long
call
code
#ifdef CLIENTSTUB
    if (!xdr_ViceStatus(&z_pb->xdrs, Status)) goto fail;
#else
    if (!xdr_ViceStatus(&z_pb->xdrs, &Status)) goto fail;
    free(AccessList.SeqBody);
    free(OptionalData.SeqBody);
#endif
endcode
endproc

proc RViceRemove		VICEREMOVE
param Did ViceFid *
param Name string
call
param Status struct ViceStatus *
code
#ifdef SERVERSTUB
    free(Name);
#endif
endcode
endproc

proc RViceCreate		VICECREATE
param Did struct ViceFid *
param BidFid struct ViceFid *
param Name string
param Status struct ViceStatus *
call
code
#ifdef CLIENTSTUB
    if (!xdr_ViceStatus(&z_pb->xdrs, Status)) goto fail;
#else
    if (!xdr_ViceStatus(&z_pb->xdrs, &Status)) goto fail;
    free(Name);
#endif
endcode
param Fid struct ViceFid *
param DirStatus ViceStatus *
endproc
		 
proc RViceRename		VICERENAME
param OldDid struct ViceFid *
param OldName string
param NewDid ViceFid *
param NewName string
call
code
#ifdef SERVERSTUB
    free(OldName);
    free(NewName);
#endif
endcode
param OldDirStatus struct ViceStatus *
param NewDirStatus struct ViceStatus *
endproc

proc RViceSymLink		VICESYMLINK
param DID struct ViceFid *
param NewName string
param OldName string
param Status struct ViceStatus *
call
code
#ifdef CLIENTSTUB
    if (!xdr_ViceFid(&z_pb->xdrs, Status)) goto fail;
#else
    if (!xdr_ViceFid(&z_pb->xdrs, &Status)) goto fail;
    free(NewName);
    free(OldName);
#endif
endcode
param Fid struct ViceFid *
param DirStatus struct ViceStatus *
endproc

proc RViceLink			VICELINK
param Did struct ViceFid *
param Name string
param Fid struct ViceFid *
call
code
#ifdef SERVERSTUB
    free(Name);
#endif
endcode
param Status struct ViceStatus *
param DirStatus struct ViceStatus *
endproc

proc RViceMakeDir		VICEMAKEDIR
param Did struct ViceFid *
param Name string
param Status struct ViceStatus *
call
code
#ifdef CLIENTSTUB
    if (!xdr_ViceStatus(&z_pb->xdrs, Status)) goto fail;
#else
    if (!xdr_ViceStatus(&z_pb->xdrs, &Status)) goto fail;
    free(Name);
#endif
endcode
param NewDid struct ViceFid *
param DirStatus struct ViceStatus *
endproc
		 
proc RViceRemoveDir		VICEREMOVEDIR
param Did struct ViceFid *
param Name string
call
code
#ifdef SERVERSTUB
    free(Name);
#endif
endcode
param Status struct ViceStatus *
endproc

proc RViceRemoveCallBack	VICEREMOVECALLBACK
param Fid struct ViceFid *
endproc

proc RViceRemoveCallBackBulk	VICEREMOVECALLBACKBULK
param fids	struct ViceFid * nocode
param nfids	int	code
	if (!xdr_array(&z_pb->xdrs, (caddr_t *) &fids, (u_int *) &nfids, MAX_CB_FIDS, sizeof (*fids), xdr_ViceFid)) goto fail;
endcode
call
code
#ifdef SERVERSTUB
	free(fids);
#endif
endcode
endproc

proc RViceSetLock			VICESETLOCK
param Fid struct ViceFid *
param Type long
endproc

proc RViceExtendLock			VICEEXTENDLOCK
param Fid struct ViceFid *
endproc

proc RViceReleaseLock		VICERELEASELOCK
param Fid struct ViceFid *
endproc

proc RViceGetRootVolume	VICEGETROOTVOLUME
code
#ifdef SERVERSTUB
    Volume.SeqBody = 0;
#endif
endcode
param Volume struct BBS *
call
code
#ifdef CLIENTSTUB
    if (!xdr_BBS(&z_pb->xdrs, Volume)) goto fail;
#else
    if (!xdr_BBS(&z_pb->xdrs, &Volume)) goto fail;
    free(Volume.SeqBody);
#endif
endcode
endproc

proc RViceSetRootVolume	VICESETROOTVOLUME
param Volume string
call
code
#ifdef SERVERSTUB
    free(Volume);
#endif
endcode
endproc

proc RViceGetVolumeStatus	VICEGETVOLUMESTATUS
code
#ifdef SERVERSTUB
    Name.SeqBody = 0;
    OfflineMsg.SeqBody = 0;
    MOTD.SeqBody = 0;
#endif
endcode
param Vid long
param Status struct VolumeStatus *
param Name struct BBS *
param OfflineMsg struct BBS *
param MOTD struct BBS *
call
code
#ifdef CLIENTSTUB
    if (!xdr_VolumeStatus(&z_pb->xdrs, Status)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, Name)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, OfflineMsg)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, MOTD)) goto fail;
#else
    if (!xdr_VolumeStatus(&z_pb->xdrs, &Status)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, &Name)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, &OfflineMsg)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, &MOTD)) goto fail;
    free(Name.SeqBody);
    free(OfflineMsg.SeqBody);
    free(MOTD.SeqBody);
#endif
endcode
endproc

proc RViceSetVolumeStatus	VICESETVOLUMESTATUS
code
#ifdef SERVERSTUB
    Name.SeqBody = 0;
    OfflineMsg.SeqBody = 0;
    MOTD.SeqBody = 0;
#endif
endcode
param Vid long
param Status struct VolumeStatus *
param Name struct BBS *
param OfflineMsg struct BBS *
param MOTD struct BBS *
call
code
#ifdef CLIENTSTUB
    if (!xdr_VolumeStatus(&z_pb->xdrs, Status)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, Name)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, OfflineMsg)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, MOTD)) goto fail;
#else
    if (!xdr_VolumeStatus(&z_pb->xdrs, &Status)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, &Name)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, &OfflineMsg)) goto fail;
    if (!xdr_BBS(&z_pb->xdrs, &MOTD)) goto fail;
    free(Name.SeqBody);
    free(OfflineMsg.SeqBody);
    free(MOTD.SeqBody);
#endif
endcode
endproc

proc RViceDisconnectFS		VICEDISCONNECTFS
endproc

proc RViceGetTime			VICEGETTIME
call
param Seconds unsigned long *
param USeconds unsigned long *
endproc

proc RViceGetMessage		VICEGETMESSAGE
code
#ifdef SERVERSTUB
    Message.SeqBody = 0;
#endif
endcode
param MessageNumber long
param Message struct BBS *
call
code
#ifdef CLIENTSTUB
    if (!xdr_BBS(z_pb->xdrs, Message)) goto fail;
#else
    if (!xdr_BBS(z_pb->xdrs, &Message)) goto fail;
    free(Message.SeqBody);
#endif
endcode
endproc

proc RViceGetStatistics		VICEGETSTATISTICS
param Statistics struct ViceStatistics *
call
code
#ifdef CLIENTSTUB
    if (!xdr_ViceStatistics(&z_pb->xdrs, Statistics)) goto fail;
#else
    if (!xdr_ViceStatistics(&z_pb->xdrs, &Statistics)) goto fail;
#endif
endcode
endproc

proc RViceCheckToken		VICECHECKTOKEN
code
#ifdef SERVERSTUB
    token.SeqBody = 0;
#endif
endcode
param id long
param token struct CBS *
call
code
#ifdef SERVERSTUB
    free(token.SeqBody);
#endif
endcode
endproc

proc RViceGetVolumeInfo		VICEGETVOLUMEINFO
param Vid string
call
code
#ifdef SERVERSTUB
    free(Vid);
#endif
endcode
param Info struct VolumeInfo *
endproc

proc RViceEnableGroup		VICEENABLEGROUP
param GroupName string
call
code
#ifdef SERVERSTUB
    free(GroupName);
#endif
endcode
endproc

proc RViceDisableGroup		VICEDISABLEGROUP
param GroupName string
call
code
#ifdef SERVERSTUB
    free(GroupName);
#endif
endcode
endproc
