/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:rftp.h 12.0$ */
/* $ACIS:rftp.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/afs/RCS/rftp.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidrftp = "$Header:rftp.h 12.0$";
#endif

#define RFTP_NOTOPEN	(-101)
#define RFTP_TIMEOUT	(-102)
#define RFTP_IOERR	(-103)

/* the values for header.opcode */
#define	OData	1	/* this packet contains data */
#define	OAck	2	/* this packet acknowledges data */
#define	ONAck	3	/* negative acknowledgement -> something is wrong */
#define	OEnd	4	/* this packet acks the last ack of a transfer, ending the dally */
#define	OGo	5	/* you can start sending now */

/* the values for header.flags */
#define	HFAckMe	    1	    /* this OData packet should be acked */
#define	HFEnd	    2	    /* this OData packet is the last one containing data */

/* the values for rftp_conn.flags */
#define CFSender	0x1	/* this is the sender's connection (both) */
#define CFNAck		0x2	/* received/sent nack (send /recv side respectively) */
#define CFEnd		0x4	/* received an end (recv only) */
#define CFEmptyFile	0x8	/* need to force sending an empty packet */
#define CFMayTimeOut	0x10	/* this connection may time out */
#define CFWait		0x20	/* this connection is waiting for safe start */
#define CFSendGo	0x40	/* keep sending go's until we get some data */

struct rftp_server {
    struct osi_WaitHandle slHandle;	/* socket listener's wait handle */
    struct rftp_server *next;		/* next server in list */
    struct osi_socket *socket;		/* associated server socket */
    struct rftp_conn *connList;		/* connections for this server */
    long slCheckTime;			/* dead conn check time */
    long slRetryTime;			/* retransmit-check time */
    short states;			/* always have those states */
    short bigSleep;			/* sleep for a long time? */
    u_short port;
};

struct rftp_stat {
    long outNacks;
    long outRexmits;
    long sendCalls;
    long recvCalls;
    long inPackets;
    long outPackets;
    long deads;
    long lastCode;
};

struct rftp_conn {
    struct rftp_conn *next;	/* the next dude in the free/in-use list */
    long host;			/* other host */
    long portal;		/* other portal */
    long sid;			/* the sid */
    char *key;			/* key set from rpc connection */
    short flags;		/* some status flags */
    struct osi_file *fd;	/* the file descriptor in which to put/get the data */
    struct rftp_server *server;	/* the associated server */
    long code;			/* transfer's success code */
    union {
	struct {		/* receiver's state */
	    long seqno;		/* next packet expected */
	    long lastActive;	/* last time we heard from the other side */
	    long endTime;	/* time the end flag went on */
	    long lgTime;	/* last time we sent a go packet */
	} recv;
	struct {		/* sender's state */
	    long window;	/* first packet we can't send send due to window limitations */
	    long lastAck;	/* the last packet acked */
	    long laTime;	/* the time the last ack was sent */
	    long retries;	/* number of retries in a row without any progress */
	    long nextSend;	/* the next packet to read from file */
	    long bytesLeft;	/* bytes left to read */
	    long filePosn;	/* position in the file */
	    struct rftp_packet *rxmit;	/* the retransmission queue (sent once) */
	    struct rftp_packet *ra;	/* the read ahead queue (never sent) */
	    long raQSize;	/* number of entries in here */
	    short blksize;	/* file system blocksize for sender */
	    short fd;		/* the file descr we're dealing with */
	} send;
    } s;			/* generic state */
};

struct rftp_header {
    long protocolVersion;
    long sid;
    long seqno;
    long who;
    short opcode;
    short flags;
};

struct rftp_packet {
    struct rftp_packet *next;	/* next guy in the free list or conn queue */
    XDR xdr;			/* xdr structure for packing/unpacking */
    long length;		/* packet length including header */
    struct rftp_header header;	/* the unpacked header */
    struct mbuf *mbuf;			/* associated network buffer structure */
    char *data;			/* data starts here. */
};

struct rftp_server *rftp_NewServer();
