/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:physio.c 12.2$ */
/* $ACIS:physio.c 12.2$ */
/* $Source: /ibm/acis/usr/sys/afs/RCS/physio.c,v $ */

#ifndef lint
static char *rcsid = "$Header:physio.c 12.2$";
#endif

/* File		physio.cx
Author		Mike Kazar
NOTE		This is NOT the standard physio.cx for venus or, yet alone, vice.  It is a test one for use in src/dir.
Date		Now */

/* First we have the kernel hacks' include files. */
#include "../h/types.h"
#include "../h/param.h"
#include "../h/time.h"
#include "../h/kernel.h"
#include "../h/socket.h"
#include "../h/socketvar.h"
#include "../h/protosw.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/uio.h"
#include "../h/vfs.h"
#include "../h/vnode.h"
#include "../ufs/inode.h"
#include "../netinet/in.h"
#include "../h/mbuf.h"
#include "../afs/osi.h"

#define PAGESIZE 2048

static struct osi_dev cacheDevice;

physio_cleanup() {
    bzero(&cacheDevice, sizeof(cacheDevice));
}

dirp_SetCacheDev (adev)
    register struct osi_dev *adev; {
    bcopy(adev, &cacheDevice, sizeof(cacheDevice));
}

dirp_Read (fid, block, data)
    long *fid;		/* View the fid as longs. */
    long block;
    char *data; {
    struct osi_file *tf;
    long code;
    tf = osi_UFSOpen(&cacheDevice, fid[0]);
    if (!tf) Die("physio open");
    osi_Seek(tf, block * PAGESIZE);
    code = osi_Read(tf, data, PAGESIZE);
    osi_Close(tf);
    if (code < PAGESIZE) return 0;
    return 1;	    /* success */
}

dirp_Write(fid, block, data)
    long *fid;		/* View the fid as longs. */
    long block;
    char *data; {
    struct osi_file *tf;
    long code;
    tf = osi_UFSOpen(&cacheDevice, fid[0]);
    if (!tf) Die("physio open");
    osi_Seek(tf, block * PAGESIZE);
    code = osi_Write(tf, data, PAGESIZE);
    if (code < 0) Die("physio read");
    osi_Close(tf);
    return 1;	    /* success */
}

/* The following three routines provide the fid routines used by the buffer and directory packages. */

int dirp_Zap (afid)
register long *afid; {/* Zero out a file */
    *afid = 0;
}

int dirp_Eq (afid, bfid)
register long *afid, *bfid; {
    if (*afid != *bfid) return 0;
    return 1;
}

/* assign one fid to another */
int dirp_Cpy (dfid,sfid)
register long *dfid, *sfid; {
    *dfid = *sfid;
}

/* general afs abort */
Die(arg)
char *arg; {/* Print an error message and then exit. */
    char buffer[100];
    strcpy(buffer, "afs error -- ");
    strcpy(&buffer[strlen(buffer)], arg);    /* uggggh! very fun, sun */
    panic(buffer);
}
