/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvd_cksum.c 12.0$ */
/* $ACIS:rvd_cksum.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/server/RCS/rvd_cksum.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvd_cksum.c 12.0$";
#endif


#ifndef lint
static char rcsid_rvd_cksum_c[] = "$Header:rvd_cksum.c 12.0$";
#endif lint

/* This file contains a slow, C version rvd checksum.  Note that the
 * checksum is the 32-bit 2's complement sum of all the longwords
 * in the rvd packet; also note that the checksum has to be byte-swapped
 * before use.  Yes, I know this is a bogus checksum algorithm, but I
 * didn't design the protocol...
 */


#ifdef vax
#define FETCH_WORD(wp)	*wp
#else

#ifdef ibm032
#define CH(wp,byte) (((unsigned char *) wp) [byte])
#define FETCH_WORD(wp) (((((CH(wp,3) << 8) + CH(wp,2)) << 8) + CH(wp,1)) << 8) + CH(wp,0)
#else
#define CH(wp,byte) (((unsigned char *) wp) [byte])
#define FETCH_WORD(wp) (((((CH(wp,0) << 8) + CH(wp,1)) << 8) + CH(wp,2)) << 8) + CH(wp,3)
#endif
#endif

rvd_cksum(words, length)
register long *words;
register int length;
{
	register int sum;

	for (sum=0; (length -= sizeof (long)) >= 0; ++words)
		sum += FETCH_WORD(words);
	return(sum);
}

