/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:resolve_host.c 12.0$ */
/* $ACIS:resolve_host.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/resolve_host.c,v $ */

#ifndef lint
static char *rcsid = "$Header:resolve_host.c 12.0$";
#endif


#ifndef lint
static char rcsid_resolve_host_c[] = "$Header:resolve_host.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <signal.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

/* Resolve the specified host name into an internet address.  The "name" may
 * be either a character string name, or an address in the form a.b.c.d where
 * the pieces are octal, decimal, or hex numbers.  Returns a pointer to a
 * sockaddr_in struct (note this structure is statically allocated and must
 * be copied), or NULL if the name is unknown.
 */

struct sockaddr_in *
resolve_host(name)

register char *name;
{
	register struct hostent *fhost;
	static struct sockaddr_in sa;
	
	if ((sa.sin_addr.s_addr = inet_addr(name)) != -1) {
		sa.sin_family = AF_INET;	/* grot */
		sa.sin_port = 0;
	} else if ((fhost = gethostbyname(name)) != NULL) {
		sa.sin_family = fhost->h_addrtype;
		sa.sin_port = 0;
		bcopy(fhost->h_addr, &sa.sin_addr, fhost->h_length);
	} else
			return(NULL);
	return(&sa);
}

isbadhost(server)
struct sockaddr_in *server;
{
	return(server == NULL);
}
