/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:desc.c 12.0$ */
/* $ACIS:desc.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/desc.c,v $ */

#ifndef lint
static char *rcsid = "$Header:desc.c 12.0$";
#endif


#ifndef lint
static char rcsid_desc_c[] = "$Header:desc.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <machineio/vdconst.h>

#include "queue.h"
#include "physd.h"
#include "virtd.h"

#define	NOHOST		"(unclaimed)"

#define	percent(a,b)	(((a * 1000) / b + 5) / 10)

#define	pperms(v)	printf("%c%c%c", \
			  (v)->vd_modes & RVDMRO  ? 'r' : '-', \
			  (v)->vd_modes & RVDMSHR ? 's' : '-', \
			  (v)->vd_modes & RVDMEXC ? 'e' : '-')

char	*ltime(),
	*fhostname();

/*
 *	physical disk attributes.  if chase is non-zero,
 *	list associated virtual disks also.
 */

pd_dump(pd, chase, title)

struct physd	*pd;

{
	if(title)
		printf("\n%-12s %7s %7s %7s %5s %5s %-12s\n",
	  	"filesystem", "blocks", "used", "avail", "capacity", "disks",
	  	"  modified");

	printf("%-12.12s %7d %7d %7d %5d%%    %2d   %12s\n",
	  pd->pd_file, pd->pd_blocks, pd->pd_used,
	  (pd->pd_blocks - pd->pd_used), percent(pd->pd_used, pd->pd_blocks),
	  pd->pd_disks, ltime(pd->pd_modified));

	if(chase) {
		struct virtd	*vd, *td;

		td = (struct virtd *) &(pd->vd_forw);
		vd = ((struct virtd *) td)->vd_forw;

		while(vd != td) {
			vd_dump(vd, title);
			title = 0;
			vd = q_head(vd, struct virtd *);
		}
	}
}

/*
 *	virtual disk attributes.
 */

vd_dump(vd, title)

struct virtd	*vd;

{
	if(title)
		printf("\n%3s     %-12s %-16s %6s %6s %-12s %s\n",
		  "acc", "owner", "owning host", "offset", "blocks",
		  "  modified", "pack");

	pperms(vd);
	printf(" %-16.16s", vd->vd_desc);
	printf(" %-16.16s", vd->vd_host.s_addr ? fhostname(vd->vd_host) : NOHOST);
	printf(" %6d %6d %12s %s",
	  vd->vd_offset, vd->vd_blocks, ltime(vd->vd_modified), vd->vd_pack);
	if(vd->vd_links)
	  printf("(%d)", vd->vd_links);
	putchar('\n');
}
