/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:acl.c 12.0$ */
/* $ACIS:acl.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/acl.c,v $ */

#ifndef lint
static char *rcsid = "$Header:acl.c 12.0$";
#endif


#ifndef lint
static char acl_c[] = "$Header:acl.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include "rvd_types.h"

/* Quick and dirty to avoid adding another include file to the RVD
 * server code.  Real values should be defined when ismember is rewritten.
 */
#define	ISMEMBER	TRUE
#define	ISNOTMEMBER	FALSE
#define	ACLNOTFOUND	FALSE
#define	CANTTELL	FALSE
#define	REQUIRESREQ	FALSE
#define	BADACLNAME	FALSE

#define ACLNAMELEN	128
#define ACLDIR		"/site/rvd/acl/"

static	char	acl_name[512];

/* This routine returns TRUE if "name" is a valid access
 * control list name.  A valid name has the form "name.acl".
 */
boolean
is_aclname(name)
	char	*name;
{
	char	*cp;

	if ((cp = index(name, '.')) != (char *)NULL 
	&&  (strcmp("acl", ++cp) == NULL))
		return(TRUE);
	return(FALSE);
}

/* This routine looks up "name" in the file "acl".  Some day it will do
 * interesting things with name resolution, like pick up records from the
 * net.
 */
ismember(name, acl, recurse_flag)
	char	*name;			/* User name */
	char	*acl;			/* File name of access list */
	boolean	recurse_flag;		/* Future dev't */
{
	FILE	*acl_file;
	char	*cp;
	char	list_name[ACLNAMELEN];

	/* Make sure the file name is in the right format.
	 */
	if ((cp = rindex(acl, '/')) == NULL)
		cp = acl;
	if (!is_aclname(cp))
		return(BADACLNAME);

	/* Make sure the directory is always ACLDIR.
	 */
	if (strncmp(acl, ACLDIR, sizeof(ACLDIR) != 0)) {
		if ((cp = rindex(acl, '/')) == NULL)
			cp = acl;
		else
			cp++;
		sprintf(acl_name, "%s%s", ACLDIR, cp);
		if ((acl_file = fopen(acl_name, "r")) == NULL)
			return(ACLNOTFOUND);
	} else {
		if ((acl_file = fopen(acl, "r")) == NULL)
			return(ACLNOTFOUND);
	}

	/* Run through the list of names in the access control list file.
	 * Something better should be done if fclose returns an error (EOF)_.
	 */
	while ( fscanf(acl_file, "%s", list_name) > 0) {
		if (strcmp(name, list_name) == 0) {
			(void) fclose(acl_file);
			return(ISMEMBER);
		}
	}
	(void) fclose(acl_file);
	return(ISNOTMEMBER);
}
