/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdchlog.c 12.0$ */
/* $ACIS:rvdchlog.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/cntrl/RCS/rvdchlog.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvdchlog.c 12.0$";
#endif


#ifndef lint
static char *rcsid_rvdchlog_c = "$Header:rvdchlog.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


/* Tell RVD server to change log level.
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<machineio/vdconst.h>

#define	BUFLEN		4096	/* Long enough to include an authenticator. */

rvdchlog(argc, argv)
	int	argc;
	char	**argv;
{
	int	level;
	int	debug = 0;
	char	*server;
	char	sbuf[BUFLEN];
	extern	char	*myname;

	if(argc > 1 && ! strcmp(argv[1], "-d")) {
		++debug;
		--argc;
		++argv;
	}

	if (argc != 3) {
		fprintf(stderr, "usage: %s server log-level\n", myname);
		exit(1);
	}

	if(sscanf(argv[2], "%d", &level) != 1) {
		fprintf(stderr, "%s: non-numeric log level %s\n",
			myname, argv[2]);
		exit(4);
	}
	server = argv[1];

#ifdef  KERBEROS
	sprintf(sbuf, "operation=log_level\nlevel=%d\npassword=\n", level);
	if ( get_auth(sbuf, server, myname, debug) &&
	    (ctl_init_send_close(sbuf, server, debug) == NULL))
		    exit(NULL);
#endif  KERBEROS


	sprintf(sbuf, "operation=log_level\nlevel=%d\npassword=%s\n",
		level, getpass("Password: ", VD_CAPAB_LEN));

	exit(ctl_init_send_close(sbuf, argv[1], debug));
}
