/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:newvd.c 12.0$ */
/* $ACIS:newvd.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/newvd.c,v $ */

#ifndef lint
static char *rcsid = "$Header:newvd.c 12.0$";
#endif

/* This file if part of the Project Athena Remote Virtual Disk (rvd) client.
 *
 *	$Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/newvd.c,v $
 *	$Author: root $
 *	$Header:newvd.c 12.0$
 *	$ACIS:newvd.c 12.0$
 */

#ifndef lint
static char *rcsid_newvd_c = "$Header:newvd.c 12.0$";
#endif	lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <netinet/in.h>
#include <sysexits.h>
#include <machineio/vdreg.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <disktab.h>

newvd(argc, argv)
int argc;
char *argv[];

{
struct vd_longstat	vd_longstats;
struct vd_longstat	*stats = &vd_longstats;
struct vd_long_dev	*drives;
struct disktab		*disk;
int			driveno, status, blocks;
char			cmdbuf[BUFSIZ];
char			device[MAXPATHLEN];
int			cpg;
extern	char		*myname;
extern	int		vdcntrl;

	if (argc != 3) newvd_usage();

	if (*argv[1] < '0' || *argv[1] > '9') {
		fprintf(stderr, "%s: drive argument not a number\n", myname);
		newvd_usage();
	}

	if(ioctl(vdcntrl, VDIOCGETSTAT, &stats)) {
		perror(myname);
		exit(EX_OSERR);
	}

	driveno = atoi(argv[1]);

	if (driveno < 0 || driveno >= vd_longstats.num_drives ) {
		fprintf(stderr, "%s: drive number out of range 0-%d\n",
			myname, vd_longstats.num_drives - 1);
		newvd_usage();
	}
	sprintf(device,"/dev/rvd%da",driveno);

	if ((disk = getdiskbyname(argv[2])) == NULL) {
		fprintf(stderr, "%s: unknown physical disk type %s\n",
			myname, argv[2]);
		newvd_usage();
	}

	drives = (struct vd_long_dev *)
		malloc(vd_longstats.num_drives * sizeof(struct vd_long_dev));
	if(drives == 0) {
		fprintf(stderr, "%s: Could not get memory for drive structs\n",
			myname);
		exit(1);
	}
	if(ioctl(vdcntrl, VDIOCGETDRIVE, &drives)) {
		perror(myname);
		exit(EX_OSERR);
	}
	
	if ((drives[driveno].vd_device.state == OFF) ||
			(drives[driveno].vd_device.state == UNUSED)) {
		fprintf(stderr,": virtual drive is unused or off\n", myname);
		exit(EX_UNAVAILABLE);
	}

	blocks = drives[driveno].vd_device.nblocks;
	cpg = (blocks / (disk->d_nsectors*disk->d_ntracks)) / 16;
	cpg = cpg / 16;  cpg = cpg * 16;
	if (cpg == 0) cpg = 8;
	
	sprintf(cmdbuf, "/etc/mkfs %s %d %d %d %d %d %d 10 %d",
		device, blocks, disk->d_nsectors, disk->d_ntracks,
		disk->d_partitions[0].p_bsize,
		disk->d_partitions[0].p_fsize,
		cpg,
		(disk->d_rpm / 60));

	printf(cmdbuf);
	printf("\n");
	status = system(cmdbuf);
	exit(status >> 8);
}

newvd_usage()
{
	fprintf(stderr,
		"usage: %s <drive-number> <physical-disk-type>\n", myname);
	exit(EX_USAGE);
}
