/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: cvtto12.c,v 12.0 88/11/11 12:37:27 root dec88 $ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/src/RCS/cvtto12.c,v $ */

#ifndef lint
static char *rcsid = "$Header: cvtto12.c,v 12.0 88/11/11 12:37:27 root dec88 $";
#endif

/* 
 *  program to convert an ibm 3820 font into a sturcture
 *  to be used when printing on the IBM 3812 printer.
 */

/*-------------------include project and standard type defs---------*/
#include "itc.h"
#include "stddefs.h"

/*------------------include appropriate header files-------------------------*/
#include <stdio.h>
#include "font_tools.h"
#include "palloc.h"
#include "symtab.h"
#include "bits.h"
#include "raster.h"

/*-------------------include ibm font processing definitions ---------------*/
#include "ibmfonts.h"

/*--------Font type definitions---------------------------------------------*/
#include "fonts.h"
#include "wmFontTools.h"


/*--------------------------Global data objects-----------------------------*/
byte *pool;			/* the palloc pool used in this module */

/*-----------------print usage ---------------------------------------------*/
printusage()
{
  fprintf(stderr,"Usage: cvt20to12 [-M] [-c fontnameTBL] fontname \n");
  exit(1);
}
/*
 * main program: expects the name of the file, uses get_whole_file to read
 * in the font data and then call font_parse_ibm to process it.
 * One option -c which is the name of the font table for creating abreviated
 * font names.  Default is fontnameTBL.
 * The -M option will just give the name of the output font name. This is 
 * used by the Makefile for the priced fonts to determine the dependencies
 * between the pds file name and the fontname that is generated.
 */
main (argc, argv)
int argc;
char *argv[];
{
    ibm_fd_type ibm;		/* ibm font specific info */
    wmFontType wmf;		/* the font converted to wm format but still 
				   240 pels per inch */
    int get_whole_file ();
    byte *start_font;
    int font_size;
    int Makedefault;
    int Makenames;
    int DoDebug;
    string fontnameTbl;
    string input_file_name;
    FILE   *fontfile;


    raster_setup();
    fontnameTbl = "fontnameTBL";
    Makedefault = 0;
    Makenames = 0;
    DoDebug = 0;
    /* -----------Parse options and arguments ---------*/
    while (argc > 1)  {
	if (argv[1][0] == '-')  {
	    /* Handle options here */

	    switch (argv[1][1])  {
		case 'M':
		    Makedefault = 1;
		    break;
		case 'N':
		    Makenames = 1;
		    break;
		case 'd':
		    DoDebug = 1;
		    break;
		case 'c':
		    if (argv[1][2] != '\0')  {
			fontnameTbl = &argv[1][2];
		    }
		    else if (--argc > 1)  {
			argv++;
			fontnameTbl = argv[1];
		    }
		    else
		        printusage();
		    break;
		default:
		    printusage();
		    break;
	    }
	}
	else  {
	    /* Handle Arguments Here */

	    input_file_name = argv[1];
	}
	argc--;
	argv++;
    }
    
    if ((fontfile = fopen(input_file_name,"r")) ==NULL)	{
	fprintf(stderr,"Input file not found:%s\n",input_file_name);
	exit(1);
    }
   
    
    font_size = get_whole_file (fontfile, &start_font);
    if (font_size <= 0) {
	fprintf (stderr, "Parse IBM font: cannot read file\n");
	exit(1);
    }

    font_parse_ibm (start_font, font_size, &ibm);
    build3812(&ibm,&wmf,fontnameTbl,Makedefault,Makenames,DoDebug);
    exit(0);
}
