/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:dumpapa8.c 12.0$ */
/* $ACIS:dumpapa8.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/bitprt_ca/RCS/dumpapa8.c,v $ */

#ifndef lint
static char *rcsid = "$Header:dumpapa8.c 12.0$";
#endif

/* 
 * dumpapa8 -- prepares a file (or standard out)
 *	of the bitmap contents of the apa8 screen
 * 	for use by subsequent filters 
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/errno.h>

extern int errno, perror();

#define CHAR 8
#define VPIXELS 720
#define LPIXELS 1024
#define LBYTES (LPIXELS/CHAR)
#define VBYTES (VPIXELS/CHAR)
#define SCANLINES 512


#define APA8BUF 0xf4d00000
#define INT16 short
/* because the adapter uses address lines A1-A16, beginning at APA8BUF,
 * it is necessary to map word accesses to byte accesses.
 */


main(argc,argv)
int argc; 
char *argv[];
{
	int i,k;
	int dumpdev;
	INT16 *framebuf;
	char *pbuf,buf[VBYTES];
	struct  {
		int screenwidth;
		int screenheight;
	} 
	screensize;
#ifdef DEBUG
	fprintf(stderr,"dumpapa8 started.\n");
#endif

	dumpdev = fileno(stdout);
	if (argc > 1)
	{
		fprintf(stderr,"dumpapa8 takes no argument\n");
	}
	screensize.screenwidth = VPIXELS;
	screensize.screenheight = SCANLINES;
	/* first fill the screen buffer */
	if (open("/dev/bus",O_RDONLY) < 0) /* gain bus access */
	{
		perror("/dev/bus");
		exit(2);
	}
	if (((open("/dev/apa8",O_RDONLY)) < 0) &&
	    (errno == EBUSY))  /* see if we even have one */
	{
		perror("/dev/apa8");
		exit(2);
	}
	framebuf = (INT16 *) APA8BUF;
	write(dumpdev,&screensize,sizeof(screensize));
	for (i=0;i<screensize.screenheight;i++)
	{
		pbuf = buf;
		{
			for (k=0;k<VBYTES;k++)
				pbuf[k] = (framebuf[k]) >> 8;
			pbuf += VBYTES;
			framebuf += LBYTES; 
			/* actually INT16 addresses */
		}
		if (write(dumpdev,buf,VBYTES) < 0)
		{
#ifdef DEBUG
			fprintf(stderr,"dumpdev=%d\n",dumpdev);
#endif
			perror("could not write to file");
			exit(2);
		}
	}
	exit(0);
}
