 /* $Header:instrs.h 12.0$ */
 /* $ACIS:instrs.h 12.0$ */
 /* $Source: /ibm/acis/usr/src/bin/as_ca/RCS/instrs.h,v $ */
#ifndef lint
static char rcsidinstrs[] = "$Header:instrs.h 12.0$";
#endif
/* $Source: /ibm/acis/usr/src/bin/as_ca/RCS/instrs.h,v $ */
/*
 *	Copyright (c) 1982 Regents of the University of California
 *	@(#)instrs.h 4.5 6/9/83
 */
  
/*
 *	Argument data lengths
 *
 *	If you change these definitions, you must also change the tables
 *	in assizetab.c
 */
#define TYPN		0		/* nibble (4 bits) */
#define TYPB		1		/* byte (8 bits) */
#define TYPS		2		/* short integer (2 bytes) */
#define TYPL		3		/* long integer (4 bytes) */
#define TYPU		4		/* double long integer (8 bytes) */
#define TYPV		5		/* first half of split reloc. addr */
#define TYPY		6		/* variable number of bytes, 4 bit length field */
#define TYPZ		7		/* BI (20 bit) pc-rel addr */
#define TYPF		8		/* floating point - 32 bit */
#define TYPD		9		/* floating point - 64 bit */
#define TYPH	       10 		/* floating point - 128 bit */
#define TYPUNPACKED    11		/* unpacked into mantissa and exponent */
#define TYPNONE	       12		/* nothing */

#define	TYPMASK	        0x0f    	/* mask for the argument data length */
#define	TYPLG		4		/* number of bits the length takes up */

/*
 *      Argument types and argument access types used to test the 
 *      validity of the operands with the instructions.
 */
#define ACCN	(0<<TYPLG)		/* non-address referencing address */
#define	ACCR	(1<<TYPLG)		/* readable argument access */
#define	ACCW	(2<<TYPLG)		/* writable argument access */
#define	ACCM	(ACCR | ACCW)		/* readable and writable access */

#define ACCTMASK 0x30			/* mask for the argument access type */
#define ACCTLN  (TYPLG+2)		/* number of bits taken up by the
					   argument access type and the
					   argument data length */
  
#define ARGTA   (0<<ACCTLN)		/* address argument type */
#define ARGTG   (1<<ACCTLN)		/* register argument type */
#define ARGTI   (2<<ACCTLN)		/* immediate data argument type */
#define ARGTX   (3<<ACCTLN)		/* indexed address argument type */

#define ARGTMASK 0xc0			/* mask for the argument type */
   
#define ACCAN	(ARGTA | ACCN)		/* an uNsigned displacement */
#define ACCAR   (ARGTA | ACCR)       	/* readable address */
#define ACCAW   (ARGTA | ACCW)		/* writable address */
#define ACCAM   (ARGTA | ACCM)		/* branch or jump destination label*/
#define ACCGR   (ARGTG | ACCR)		/* readable register */
#define ACCGW   (ARGTG | ACCW)		/* writable register */
#define ACCGM   (ARGTG | ACCM)		/* readable and writable register */
#define ACCIR   (ARGTI | ACCR)		/* readable immediate data */
#define ACCIN	(ARGTI | ACCN)		/* uNsigned immediate data */
#define ACCXR   (ARGTX | ACCR)		/* readable indexed address */
#define ACCXW   (ARGTX | ACCW)		/* writable indexed address */
#define ACCXM   (ARGTX | ACCM)		/* readable and writable indexed */

#define ACCMASK 0xf0			/* mask for both the argument type
					   and the argument access type */
/*
 *	Constructors and extractors for argument types, argument access
 *      types, and argument data lengths.  Note that A_ACCEXT and A_TYPEXT
 *      are referenced within adb and sdb.
 */
#define A_CONS(access, type)	((access) | (type))
#define	A_ACCEXT(optype)	((optype) & ACCMASK)
#define	A_TYPEXT(optype)	((optype) & TYPMASK)

/*
 *	Construction of ACCXX and TYPX, to make the instrs table
 *	easy to use and read.
 */

/*
 *	For non-address referencing address arguments
 */
#define	A_ANB	A_CONS(ACCAN, TYPB)
#define A_ANS	A_CONS(ACCAN, TYPS)
#define	A_ANL	A_CONS(ACCAN, TYPL)
/*
 *	For readable memory address arguments
 */
#define	A_ARB	A_CONS(ACCAR, TYPB)
#define	A_ARS	A_CONS(ACCAR, TYPS)
#define	A_ARL	A_CONS(ACCAR, TYPL)
#define	A_ARU	A_CONS(ACCAR, TYPU)
#define	A_ARV	A_CONS(ACCAR, TYPV)
#define	A_ARY	A_CONS(ACCAR, TYPY)
#define	A_ARZ	A_CONS(ACCAR, TYPZ)
#define	A_ARF	A_CONS(ACCAR, TYPF)
#define A_ARD	A_CONS(ACCAR, TYPD)
/*
 *	For writable memory address arguments
 */
#define	A_AWB	A_CONS(ACCAW, TYPB)
#define	A_AWS	A_CONS(ACCAW, TYPS)
#define	A_AWL	A_CONS(ACCAW, TYPL)
#define	A_AWU	A_CONS(ACCAW, TYPU)
#define	A_AWV	A_CONS(ACCAW, TYPV)
#define	A_AWY	A_CONS(ACCAW, TYPY)
#define	A_AWZ	A_CONS(ACCAW, TYPZ)
#define	A_AWF	A_CONS(ACCAW, TYPF)
#define A_AWD	A_CONS(ACCAW, TYPD)
/*
 *	For readable and writable address arguments
 */
#define	A_AMB	A_CONS(ACCAM, TYPB)
#define	A_AMS	A_CONS(ACCAM, TYPS)
#define	A_AML	A_CONS(ACCAM, TYPL)
#define	A_AMU	A_CONS(ACCAM, TYPU)
#define	A_AMV	A_CONS(ACCAM, TYPV)
#define	A_AMY	A_CONS(ACCAM, TYPY)
#define	A_AMZ	A_CONS(ACCAM, TYPZ)
#define	A_AMF	A_CONS(ACCAM, TYPF)
#define A_AMD	A_CONS(ACCAM, TYPD)
/*
 *	For readable register arguments
 */
#define A_GRN	A_CONS(ACCGR, TYPN)
#define	A_GRB	A_CONS(ACCGR, TYPB)
#define	A_GRS	A_CONS(ACCGR, TYPS)
#define	A_GRL	A_CONS(ACCGR, TYPL)
#define	A_GRU	A_CONS(ACCGR, TYPU)
#define	A_GRV	A_CONS(ACCGR, TYPV)
#define	A_GRY	A_CONS(ACCGR, TYPY)
#define	A_GRZ	A_CONS(ACCGR, TYPZ)
#define	A_GRF	A_CONS(ACCGR, TYPF)
#define A_GRD	A_CONS(ACCGR, TYPD)
#define A_GRH   A_CONS(ACCGR, TYPH)
/*
 *	For writable register arguments
 */
#define A_GWN	A_CONS(ACCGW, TYPN)
#define	A_GWB	A_CONS(ACCGW, TYPB)
#define	A_GWS	A_CONS(ACCGW, TYPS)
#define	A_GWL	A_CONS(ACCGW, TYPL)
#define	A_GWU	A_CONS(ACCGW, TYPU)
#define	A_GWV	A_CONS(ACCGW, TYPV)
#define	A_GWY	A_CONS(ACCGW, TYPY)
#define	A_GWZ	A_CONS(ACCGW, TYPZ)
#define	A_GWF	A_CONS(ACCGW, TYPF)
#define A_GWD	A_CONS(ACCGW, TYPD)
#define A_GWH   A_CONS(ACCGW, TYPH)
/*
 *	For readable and writable register arguments
 */
#define A_GMN	A_CONS(ACCGM, TYPN)
#define	A_GMB	A_CONS(ACCGM, TYPB)
#define	A_GMS	A_CONS(ACCGM, TYPS)
#define	A_GML	A_CONS(ACCGM, TYPL)
#define	A_GMU	A_CONS(ACCGM, TYPU)
#define	A_GMV	A_CONS(ACCGM, TYPV)
#define	A_GMY	A_CONS(ACCGM, TYPY)
#define	A_GMZ	A_CONS(ACCGM, TYPZ)
#define	A_GMF	A_CONS(ACCGM, TYPF)
#define A_GMD	A_CONS(ACCGM, TYPD)
#define A_GMH   A_CONS(ACCGM, TYPH)
/*
 *	For readable immediate data arguments
 */
#define	A_IRN	A_CONS(ACCIR, TYPN)
#define	A_IRB	A_CONS(ACCIR, TYPB)
#define	A_IRS	A_CONS(ACCIR, TYPS)
#define A_INN	A_CONS(ACCIN, TYPN)
#define A_INB	A_CONS(ACCIN, TYPB)
#define A_INS	A_CONS(ACCIN, TYPS)
#define A_INY	A_CONS(ACCIN, TYPY)

/*
 *	For readable indexed address arguments
 */
#define	A_XRB	A_CONS(ACCXR, TYPB)
#define	A_XRS	A_CONS(ACCXR, TYPS)
#define	A_XRL	A_CONS(ACCXR, TYPL)
#define	A_XRU	A_CONS(ACCXR, TYPU)
#define	A_XRV	A_CONS(ACCXR, TYPV)
#define	A_XRY	A_CONS(ACCXR, TYPY)
#define	A_XRZ	A_CONS(ACCXR, TYPZ)
#define	A_XRF	A_CONS(ACCXR, TYPF)
#define A_XRD	A_CONS(ACCXR, TYPD)
#define A_XRH   A_CONS(ACCXR, TYPH)
/*
 *	For writable indexed address arguments
 */
#define	A_XWB	A_CONS(ACCXW, TYPB)
#define	A_XWS	A_CONS(ACCXW, TYPS)
#define	A_XWL	A_CONS(ACCXW, TYPL)
#define	A_XWU	A_CONS(ACCXW, TYPU)
#define	A_XWV	A_CONS(ACCXW, TYPV)
#define	A_XWY	A_CONS(ACCXW, TYPY)
#define	A_XWZ	A_CONS(ACCXW, TYPZ)
#define	A_XWF	A_CONS(ACCXW, TYPF)
#define A_XWD	A_CONS(ACCXW, TYPD)
#define A_XWH   A_CONS(ACCXW, TYPH)
/*
 *	For readable and writable indexed address arguments
 */
#define	A_XMB	A_CONS(ACCXM, TYPB)
#define	A_XMS	A_CONS(ACCXM, TYPS)
#define	A_XML	A_CONS(ACCXM, TYPL)
#define	A_XMU	A_CONS(ACCXM, TYPU)
#define	A_XMV	A_CONS(ACCXM, TYPV)
#define	A_XMY	A_CONS(ACCXM, TYPY)
#define	A_XMZ	A_CONS(ACCXM, TYPZ)
#define	A_XMF	A_CONS(ACCXM, TYPF)
#define A_XMD	A_CONS(ACCXM, TYPD)
#define A_XMH   A_CONS(ACCXM, TYPH)

#ifndef INSTTAB
/*
 *	Define what the entries in the table look like.
 *	This is only used for adb and sdb; not for as.
 */
#define	INSTTAB
struct insttab{
	char	*iname;
	u_char	eopcode;
	u_char	popcode;
	char	nargs;
	u_char	argtype[6];
} insttab[];

#define OP(name,eopcode,popdcode,nargs,a1,a2,a3,a4,a5,a6) {name,eopcode,popdcode,nargs,a1,a2,a3,a4,a5,a6}

#endif INSTTAB

/*
 *	Definitions for the escape byte
 */
#define	CORE	0			/* 8 bit op code, 2 byte instruction,
					   R and RI formats */
#define ESCX    1			/* 4 bit op code, X format instruction */
#define ESDS    2			/* 4 bit op code, D Short format */
#define ESJI	3			/* 5 bit op code, JI format */
#define ESRD	4			/* 8 bit op code, RD format */
#define ESBI	5			/* 8 bit op code, BI and BIB formats */
#define ESBA	6			/* 8 bit op code, BA format */
#define ESCD	7			/* 8 bit op code, D, DB, and D1 formats */
#define ESCDUS	8			/* ditto, but unsigned displacement */
#define ESCDUP	9			/* ditto, but refers to upper half of
					/* reg; signedness is irrelevant. */

#define ESDI	10			/* 8 bit op code, DI, DIN, and D2 formats */
#define ESDIUS	11			/* ditto, but unsigned displacement */

/*
 *	The following definitions are used to determine both the mask field and
 *	the opcode for the extended branch mnemonics.  The second field in the
 *	struct instab for a PSEUDO operator is a one byte type field.  
 *	For the extended branch mnemonics the type field is used as follows:
 *
 *	bit 0   	unused
 *	bit 1		if 1, a "branch on not condition bit" type instruction
 *			is to be generated.
 *	bit 2		if 1, a "branch with branch address in the register"
 *			type instruction is to be generated.
 *	bit 3		if 1, a "branch with execute" type instruction is to be
 *			generated.
 *	bits 4 - 7	the condition status bit number mask
 */
#define CSB_MASK	0x0f		/* the condition status bit mask */
#define OPCODE_MASK	0x70		/* the opcode mask */

#define BB_MASK		0x00		/* a bb instruction mask */
#define BBX_MASK	0x10		/* a bbx instruction mask */
#define BBR_MASK	0x20		/* a bbr instruction mask */
#define BBRX_MASK	0x30		/* a bbrx instruction mask */
#define BNB_MASK	0x40		/* a bnb instruction mask */
#define BNBX_MASK	0x50		/* a bnbx instruction mask */
#define BNBR_MASK	0x60		/* a bnbr instruction mask */
#define BNBRX_MASK	0x70		/* a bnbrx instruction mask */

#define BB_OP		0x8e		/* bb op code */
#define BBX_OP		0x8f		/* bbx op code */
#define BBR_OP		0xee		/* bbr op code */
#define BBRX_OP		0xef		/* bbrx op code */
#define BNB_OP		0x88		/* bnb op code */
#define BNBX_OP		0x89		/* bnbx op code */
#define BNBR_OP		0xe8		/* bnbr op code */
#define BNBRX_OP	0xe9		/* bnbrx op code */

#define JB_FLAG		0x11		/* a jb instruction */
#define JB_OP		0x08		/* jb op code */
#define JNB_FLAG	0x12		/* a jnb instruction */
#define JNB_OP		0x00		/* jnb op code */

/*
 *	The following definitions are used to determine both the opcode and 
 *	sometimes the immediate value for the special macro instructions.
 *	The second field in the struct instab for a PSEUDO operator is a 
 *	one byte type field.  
 *
 */
#define GET_PUT		0x08		/* a get or put special (bit) */
#define GP_MSK		0x07		/* which get/put special */
#define GP_CNT		8		/* number of entries in norm_ops */

#define SI_SPEC		0x80		/* a subtract immediate instruction macro */
#define MR_SPEC		0x81		/* a shorthand for cas r1,r2,0 */
#define ADD_SPEC	0x82		/* add macro */
#define SUB_SPEC	0x83		/* subtract macro */
#define CMP_SPEC	0x84		/* compare macro */
#define CMPL_SPEC	0x85		/* cpmplare logical macro */

#define ASC_GRP		0x80		/* a bit test for add, sub, or cmp */
#define ASC_MSK		0x07		/* which of the above */

#define NI_SPEC		0x22		/* an and immediate instruction macro */
#define	XI_SPEC		0x21		/* an exclusive or immediate instruction macro */
#define OI_SPEC		0x20		/* an or immediate instruction macro */
#define NXO_CNT		3		/* the number of ni, oi, si specials */

#define LD_STO		0x10		/* Bit to test for load or store */
#define LDSTO_MSK	0x0f		/* Which load or store special */
/* #define LDSTO_LDA	0x18		   Special op for LDA */
#define LDSTO_CNT	9		/* Number of load, store specials */
#define LOAD_CNT	5		/* Number of load specials */
#define STORE_CNT	4		/* Number of store specials */

#define SHRA_SPEC	0x43		/* a shift right algebraic instruction macro */
#define SHR_SPEC	0x42		/* a shift right instruction macro */
#define SHLA_SPEC	0x41		/* a shift left algebraic instruction macro */
#define SHL_SPEC	0x40		/* a shift left instruction macro */
#define SH_OP_CNT	4		/* the number of shift specials */
#define SPEC_MSK	0x07		/* which of the above */

#define GET_SPEC	0x0f		/* a load full word macro */
#define GETHA_SPEC	0x0d		/* a load signed half-word macro */
#define GETH_SPEC	0x08		/* a load unsigned half-word macro */
#define GETC_SPEC	0x0c		/* a load character macro */
#define PUTC_SPEC	0x09		/* a store character macro */
#define PUTH_SPEC	0x0a		/* a store half-word macro */
#define PUT_SPEC	0x0b		/* a store word macro */

#define SARI_OP		0xa0		/* shift right algebraic op code */
#define	SARI16_OP	0xa1		/* shift right algebraic plus sixteen */
#define	SRI_OP		0xa8		/* shift right immediate op code */
#define	SRI16_OP	0xa9		/* shift right immediate plus sixteen */
#define	SLI_OP		0xaa		/* shift left immediate op code */
#define	SLI16_OP	0xab		/* shift left immediate plus sixteen */
#define	CAS_OP		0x60
#define	AI_OP		0xc1		/* add immediate op code */
#define	OIU_OP		0xc3		/* or immediate upper half */
#define	OIL_OP		0xc4		/* or immediate lower half */
#define	NILZ_OP		0xc5		/* and immediate extended zeroes */
#define	NILO_OP		0xc6		/* and immediate extended ones */
#define XIL_OP		0xc7		/* exclusive or immediate lower half */
#define	CAL_OP		0xc8
#define	XIU_OP		0xd7		/* exclusive or immediate upper half */
#define	O_OP		0xe3		/* or */
#define	X_OP		0xe7		/* exclusive or */
#define N_OP		0xe5		/* and */

#define CAL16_OP	0xc2		
#define LIS_OP		0xa4
#define CAU_OP		0xd8
#define LC_OP		0xce
#define LH_OP		0xda
#define LHA_OP		0xca
#define L_OP		0xcd
#define STC_OP		0xde
#define STH_OP		0xdc
#define ST_OP		0xdd

#define LCS_OP		0x40
#define LHS_OP		0xeb		/* note not d-short format */
#define STCS_OP		0x10

#define AIS_OP		0x90
#define SIS_OP		0x92
#define CIS_OP		0x94

/*
 *	The following definitions define the op codes for certain D Short
 *	format, DI/DIN/D2 format, and BI format instructions that require
 *	special treatment.
 */
#define	LHAS_OP		0x50		/* load half algebraic short - requires
					   shifting the displacement 1 to right */
#define	LS_OP		0x70		/* load short - requires shifting
					   the displacement 2 to right */
#define	STHS_OP		0x20		/* store half short - requires shifting
					   the displacement 1 to right */
#define	STS_OP		0x30		/* store short - requires shifting
					   the displacement 2 to right */
#define	TI_OP		0xcc		/* trap on condition immediate - requires
					   16 bit value to be sign extended */
#define	CI_OP		0xd4		/* compare immediate - requires
					   16 bit value to be sign extended */
#define	CLI_OP		0xd3		/* compare logical immediate - requires
					   16 bit value to be sign extended */
#define	AEI_OP		0xd1		/* add extend immediate - requires 
					   16 bit value to be sign extended */
#define	SFI_OP		0xd2		/* subtract from immediate - requires 
					   16 bit value to be sign extended */
#define	NIUO_OP		0xd6		/* and immmediate upper half extended ones,
					   16 bit value to be sign extended */
#define A_OP		0xe1
#define S_OP		0xe2
#define C_OP		0xb4
#define CL_OP		0xb3

#define BALI_OP		0x8c		/* branch and link immediate */
#define BALIX_OP	0x8d		/* branch and link immediate, execute */

#define BALRX_OP	0xed		/* branch and link register, execute */
#define WITH_X		0x01		/* the 'with execute' bit */

/*
 *	The following definitions define the number of bits allowed
 *	in various fields of various instruction types.
 */
#define JIOFFSET	 3		/* bits allowed in the condition status
					   bit field in a JI format instruction */
#define ROFFSET		 4		/* bits allowed in the displacement
					   field in a D short format instruction 
					   and in the immediate field in an R
					   format instruction */
#define	DOFFSET		15		/* bits allowed in a signed displacement
					   field in a D format instruction */
#define	DIOFFSET	16		/* bits allowed in an unsigned displacement
					   field in most DI format instructions */
#define BAOFFSET	24		/* bits allowed in the displacement
					   field in a BA format instruction */

/*
 *	The following definitions define the maximum positive and negative
 *	values allowed in the displacement fields of JI, BI, and D format
 *	instructions.
 */
#define	MAX_POS_4BITS	15		/* maximum positive number that can be
					   contained in a signed 4 bit field */
#define	MAX_NEG_4BITS	-16		/* maximum negative number that can be
					   contained in a signed 4 bit field */
#define	MAX_POS_8BITS	127		/* maximum positive number that can be
					   contained in a signed 8 bit field */
#define	MAX_NEG_8BITS	-128		/* maximum negative number that can be
					   contained in a signed 8 bit field */
#define	MAX_POS_16BITS	32767		/* maximum positive number that can be
					   contained in a signed 16 bit field */
#define	MAX_NEG_16BITS	-32768		/* maximum negative number that can be
					   contained in a signed 16 bit field */
#define	MAX_POS_20BITS	524287		/* maximum positive number that can be
					   contained in a signed 20 bit field */
#define	MAX_NEG_20BITS	-524288		/* maximum negative number that can be
					   contained in a signed 20 bit field */
