/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: PIMwmInfo.c,v $ $Revision: 1.5 $ $Date: 92/03/13 17:53:42 $"
#endif
#endif

#include	<testlib.h>
#include	<PITests.h>

#include	"PIMwmInfo.h"


int	ErrorHandle(dpy, err_event)
Display	*dpy;
XErrorEvent	*err_event;
{

	char    msg[80];

	XGetErrorText(dpy, err_event->error_code, msg, 80);
	printf("X Error code: %s\n", msg);

	/*
	 * Window was not found, so result is False.
	 */
	PIInfo[PIInfo_cnt].actual_return = False;

}


main(argc, argv)
unsigned int	argc;
char	*argv[];
{

	Arg     args[10];
	int     n;
	int		i;

	n = 0;

    CommonTestInit(argc, argv);

    n = 0;
	XtSetArg(args[n], XmNwidth, 10); n++;
	XtSetArg(args[n], XmNheight, 10); n++;
	XtSetValues(Shell1, args, n);

	XtRealizeWidget(Shell1);

	XSetErrorHandler(ErrorHandle);

	top_wdw = XtWindow(Shell1);

    CommonPause();
	/*
 	 * Initialize the PIInfo data values
  	 */
	for (i = 0; i < NUM_TESTS; i++)
		PIInfo[i].actual_return = False;

/*
	/*
	 * Get the MwmInfo flags
	 */
	test_atom = XmInternAtom(display, "_MOTIF_WM_INFO", False);

	XGetWindowProperty(display, rootWindow, test_atom, 0, 100, False, 
					   AnyPropertyType, &new_type, &new_format, 
					   &new_nitems, &new_bytes_after,
					   (unsigned char **)(&mwm_get_info));

	/*
 	 * Check validity of info flags
 	 */
	PIInfo[PIInfo_cnt].actual_return =
		(
		( mwm_get_info->flags == MWM_INFO_STARTUP_STANDARD ) ||
		( mwm_get_info->flags == MWM_INFO_STARTUP_CUSTOM ));
	PIInfo_cnt++;

	/*
 	 * Check validity of wm_window while mwm running
 	 */
	/* Proper result here is TRUE */
	if (mwm_get_info->wm_window) {
		/*
		 * If XRaiseWindow() succeeds, then the property's 
		 * function IS working - the window SHOULD be valid
		 * while the window manager is running.
		 *
		 * So, we preload the result to be True, but if the
		 * XRaiseWindow() fails, the error handler will reset
		 * the result to False (an error condition).
		 */
		PIInfo[PIInfo_cnt].actual_return = True;
		XRaiseWindow(display, mwm_get_info->wm_window);
	}
	else {
		/*
		 * The window was NULL, so wm must not be running or
		 * is broken, and the window is not valid.  The result
		 * is False.
		 */
		PIInfo[PIInfo_cnt].actual_return = False;
	}
	XSync(display, False);
	PIInfo_cnt++;
    
    CommonPause();
/*
 * Put up a message box with the results of the test.
 */
	display_summary(NUM_TESTS, TEST_DESCRIP_LENGTH, PIInfo);

	CommonPause();

/*
 *  Loop and process events.
 */

	XtAppMainLoop(app_context);

}

